<?php

namespace App\Classes\Finance;
use App\Models\Finance\ChequeIncoming;
use DB;


class ChequeIncomingHelper
{
    function get_next_codes($date , $year , $branch)
    {
        $data['year_ser'] = intval( DB::table('cheque_incomings')
            ->where('finance_year_id' , $year)
            ->max('year_ser') ) + 1 ;

        $data['month_ser'] = intval( DB::table('cheque_incomings')
            ->where('finance_year_id' , $year)
            ->where('due_date' , 'like' , date("Y-m" , strtotime($date))."%" )
            ->max('month_ser') ) + 1 ;

        $data['branch_ser'] = intval( DB::table('cheque_incomings')
            ->where('branch_id' , $branch)
            ->max('branch_ser') ) + 1 ;

        return $data;
    }

    function can_edit_or_delete($id)
    {
        return true;
    }


    function generate_from_receipt_vouchers($voucher_id)
    {
        $voucher = DB::table('receipt_vouchers')
            ->where('receipt_voucher_id' , $voucher_id )
            ->first();
        $codes  = $this->get_next_codes($voucher->action_date , $voucher->finance_year_id , $voucher->branch_id );
        $seed   = [
            'finance_year_id'   => $voucher->finance_year_id ,
            'branch_id'         => $voucher->branch_id ,
            'daily_journal_id'  => 0 ,
            'cheque_number'     => $voucher->cheque_number ,
            'branch_ser'        => $codes['branch_ser'] ,
            'month_ser'         => $codes['month_ser'] ,
            'year_ser'          => $codes['year_ser'] ,
            'customer_id'       => $voucher->from_customer_id ,
            'supplier_id'       => $voucher->from_supplier_id ,
            'voucher_id'        => $voucher_id ,
            'bank_id'           => $voucher->to_bank_id ,
            'amount'            => $voucher->amount ,
            'due_date'          => $voucher->due_date ,
            'cheque_status_id'  => 0 ,
            'add_user'          => auth()->user()->id
        ];

        ChequeIncoming::add_cheque_incoming($seed);
        return true;
    }

}
