<?php

namespace App\Classes\Finance;

use App\Models\Finance\DailyJournal;
use App\Classes\General\General;

use DB;


class DailyJournalHelper {


    function can_edit_or_delete($id)
    {
        
        $account    = DB::table('daily_journal_m')->where('daily_journal_m_id' , $id )->first();

        if( $account->auto_generated == 1 ){
            return false;
        }

        return true;
    }

    function get_next_codes($date , $year , $branch){

        $data['year_ser'] = intval( DB::table('daily_journal_m')
            ->where('finance_year_id' , $year)
            ->max('year_ser') ) + 1 ;

        $data['month_ser'] = intval( DB::table('daily_journal_m')
            ->where('finance_year_id' , $year)
            ->where('journal_date' , 'like' , date("Y-m" , strtotime($date))."%" )
            ->max('month_ser') ) + 1 ;

        $data['branch_ser'] = intval( DB::table('daily_journal_m')
            ->where('finance_year_id' , $year)
            ->where('branch_id' , $branch)
            ->max('branch_ser') ) + 1 ;

        return $data;
    }

    function generate_journal($data, $items = [] , $attachments = [] ){

        if( !isset($items) || !is_array($items) || count($items) < 2 ){
            return array( false ,  trans("error.account_tree") );
        }

        if(round(collect($items)->sum('credit') , 2 ) != round( collect($items)->sum('debit') , 2 ) ){
            // return array( false ,  trans("error.credit_not_equal_debit") , 0 , $items );
        }

        $years  = (new General)->get_user_years(auth()->user()->id ?? 1  , 'en');
        $year   = array_search( date("Y" , strtotime($data['journal_date'])) , $years );
        if($year == ''){
            return array( false ,  trans("error.finance_year_not_aval") );
        }
        
        $codes = $this->get_next_codes($data['journal_date'] , $year , $data['branch_id'] );

        $master_seed = array(
            'finance_year_id'   => $year ,
            'branch_id'         => $data['branch_id'] ,
            'description'       => $data['des'] ,
            'year_ser'          => $codes['year_ser'] ,
            'month_ser'         => $codes['month_ser'] ,
            'branch_ser'        => $codes['branch_ser'] ,
            'journal_date'      => $data['journal_date'] ,
            'daily_type_id'     => $data['daily_type_id'] ,
            'auto_generated'    => $data['auto_generated'] ?? 1 ,
            'document_id'       => $data['document_id'] ?? 0 ,
            'confirmed'         => 1 ,
            'journal_active'    => 1 ,
            'add_user'          => auth()->user()->id  
        );

        $validator = validator()->make( $master_seed , DailyJournal::$master_rules );
        if($validator->fails())
        {
            return array( false ,  trans("error.add_fails") , '' ,$validator->errors() );
        }

        DB::beginTransaction();
            $check = DailyJournal::get_daily_journal_m($data['daily_journal_id'] ?? 0 , 'en');
            if(isset($check->m_id)){
                $id = $check->m_id;
                DailyJournal::delete_daily_journal_d($check->m_id);
                // DailyJournal::delete_daily_journal_files($check->m_id);

                if($check->finance_year_id == $master_seed['finance_year_id']){
                    unset($master_seed['year_ser'] , $master_seed['month_ser'] , $master_seed['branch_ser']);
                }

                DailyJournal::update_daily_journal_m($master_seed , $check->m_id );
                
            }else{
                $id = DailyJournal::add_daily_journal_m($master_seed);
            }
          
            foreach ($items as $row) {
                $det_seed = array(
                    'daily_journal_m_id'        => $id ,
                    'account_tree_id'           => intval($row['account_tree_id']) ,
                    'cost_centers'              => (is_array($row['cost_center_id'] ?? ''))? implode(',' , $row['cost_center_id']) : ( $row['cost_center_id'] ?? "" ),
                    'debit'                     => doubleval($row['debit']) ,
                    'credit'                    => doubleval($row['credit']) ,
                    'description'               => $row['description']
                );

                $validator = validator()->make( $det_seed , DailyJournal::$detaile_rules );
                if($validator->fails())
                {
                    return array( false ,  trans("error.add_fails") , '' , $items );
                }

                DailyJournal::add_daily_journal_d($det_seed);
            }

            foreach ($attachments as $row) {
                DB::table('daily_journal_files')
                    ->insert(
                        [
                            'daily_journal_id'  => $id ,
                            'file_name'         => $row->file_name ?? 'name' ,
                            'file_path'         => $row->file_path ?? 'path' ,
                            'file_ext'          => $row->file_ext ?? 'ext' 
                        ]
                    );
            }
            
        DB::commit();

        return array( true ,  trans("main.add_success") , $id );

    }


}