<?php
namespace App\Classes\General;

use App\Classes\General\Tafqeet\Tafqeet;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Main\Branch;
use App\Models\Main\Input;
use App\Models\Finance\Currency;
use App\Models\Main\Notiffications;
use App\Models\Main\Setting;

class General {

    public function get_extra_inputs($screen_id , $lang ){

        $master_inputs      = Input::all_inputs(array('active' => 1, 'lang' => $lang , 'location' => 1 , 'screen_id' => $screen_id));
        $detail_inputs      = Input::all_inputs(array('active' => 1, 'lang' => $lang , 'location' => 2 , 'screen_id' => $screen_id));

        foreach ($master_inputs as $key => $value) {
            $master_inputs[$key]->lookups = json_decode($master_inputs[$key]->lookups);
        }

        foreach ($detail_inputs as $key => $value) {
            $detail_inputs[$key]->lookups = json_decode($detail_inputs[$key]->lookups);
        }

        $return = [
            'master' => $master_inputs ,
            'detail' => $detail_inputs ,
        ];

        return $return;
    }


    public function numberToText($lang  , $number , $currency = "SAR" , $big = "SAR" , $small = "Halala" ) {

        if($lang == 'ar'){

            return Tafqeet::inArabic(round($number , 2) , strtolower($currency) );

        }elseif($lang == 'en'){

            $digit = new \NumberFormatter('en_US', \NumberFormatter::SPELLOUT);
            $numberParts = explode('.', (string) round($number,2));
            $formatedNumber =  $digit->format($numberParts[0])." ".$big;
            if (isset($numberParts[1] ) ) {
                $formatedNumber .= ' and ' . $digit->format($numberParts[1])." ".$small;
            }
            return ucwords($formatedNumber);

        }

    }

    public function check_date($date){

        $all_years  = $this->get_user_years(auth()->user()->id  , 'en' );
        $year       = array_search( date("Y" , strtotime($date)) , $all_years );
        if($year == ''){
            return array( 'check' => false , 'year_id' => 0 );
        }
        return array( 'check' => true , 'year_id' => $year );
    }

    public function get_user_branchs( $UserId , $lang ){
        return DB::table('branchs')->whereRaw("find_in_set(".$UserId." , users)")->where('branch_active' , 1 )->pluck('name_'.$lang.' as name' , 'branch_id')->toArray();
    }

    public function get_user_years( $UserId , $lang ){
        return DB::table('finance_years')->whereRaw("find_in_set(".auth()->user()->id." , users)")->where('finance_year_active' , 1 )->pluck('name' , 'finance_year_id')->toArray();
    }

    public function get_user_titles($UserId, $lang)
    {
        $user = User::find($UserId);
        $user_titles = explode(',', $user->user_titles);
        return DB::table('title')->whereIn('title_id', $user_titles)->select('title_id', 'title_name_'.$lang.' as name')->get();
    }

    public function get_current_shift($user){
        return DB::table('shifts')
            ->join('branchs' , 'shifts.branch_id' , '=' , 'branchs.branch_id')
            ->where('user_id' , $user)
            ->where('end_date' , null )
            ->first();
    }

    public function general_data($UserId , $lang){

        $user                   = User::find($UserId);
        $data['from']           = $_SERVER['HTTP_ORIGIN'] ?? '';
        $data['shift']          = $this->get_current_shift($UserId);
        $data['branchs']        = $this->get_user_branchs($UserId,$lang);
        $data['years']          = $this->get_user_years($UserId,$lang);
        $data['titles']         = $this->get_user_titles($UserId,$lang);
        $data['current_branch'] = $data['shift']->branch_id ?? request()->header('branchid') ?? $user->default_branch ?? 0 ;
        $data['current_year']   = request()->header('yearid') ?? $user->default_year ?? 0 ;
        $data['current_title']  = request()->header('titleid') ?? $user->title_id ?? 0 ;
        $data['branch_data']    = Branch::get_branch( $data['current_branch'] , $lang );
        $data['currency']       = Currency::get_currency( Setting::get_main_setting_by_code('default_currency')->value ?? 1 , $lang );
        $data['digits']         = intval( Setting::get_main_setting_by_code('digits')->value ?? 2 );


        if($data['from'] == 'https://erp.qawaemerp.com' ){
            $data['current_branch'] = $user->default_branch ?? 0;
        }else{
            $data['current_branch'] = $data['shift']->branch_id ?? $user->default_branch ?? 0;
        }

        $path = public_path().$data['branch_data']->branch_image;
        if(file_exists($path) && is_file($path)){
            $type = pathinfo($path, PATHINFO_EXTENSION);
            $file = file_get_contents($path);
            $data['branch_data']->branch_image  = 'data:image/' . $type . ';base64,' . base64_encode($file);
        }else{
            $data['branch_data']->branch_image  = $data['branch_data']->branch_image;
        }

        $path = public_path().$data['branch_data']->header_image;
        if(file_exists($path) && is_file($path) ){
            $type = pathinfo($path, PATHINFO_EXTENSION);
            $file = file_get_contents($path);
            $data['branch_data']->header_image  = 'data:image/' . $type . ';base64,' . base64_encode($file);
        }else{
            $data['branch_data']->header_image  = $data['branch_data']->header_image;
        }

        if( $data['current_branch'] != 0 ){
            $branch                 = Branch::get_branch($data['current_branch']);
            $data['screens']        = [];
            $data['permissions']    = User::get_user_permission( $UserId , $lang , null , null, $data['current_title'] );

            foreach ($data['permissions'] as $key => $value) {
                $data['permissions'][$key]->permission = json_decode( $value->permission );
            }

            $data['mypermissions']  = collect($data['permissions'])->groupBy('screen_code')->toArray();
        }else{
            $data['screens']        = [];
            $data['permissions']    = [];
            $data['mypermissions']  = [];
        }

        return $data;
    }


    public function get_user_profile( $UserId , $lang = null){
        $user                       = User::get_user( $UserId , $lang);
        $data['api_token']          = $user->api_token ;
        $data['full_name']          = $user->user_full_name ;
        $data['email']              = $user->email ;
        $data['mobile']             = $user->mobile ;
        $data['player_id']          = $user->player_id ?? 0 ;
        $data['image']              = $user->image_url ?? '' ;
        $data['title']              = $user->title ?? '' ;
        $data['pos']                = $user->pos ?? 0 ;
        $data['super_admin']        = $user->super_admin ?? 0;
        $data['is_nfc']             = $user->is_nfc ?? 0;

        $data['view_all_data']      = $user->view_all_data ?? 1;

        $data['user']               = $this->general_data( $UserId , $lang );
        $data['booking_count']      = DB::table('barber_bookings')
                                    ->where([
                                        ['barber_booking_active',1],
                                        ['barber_booking_date',date('Y-m-d')],
                                        ['has_invoice',0],
                                    ])->count();
        $mains                      = collect($data['user']['permissions'])->groupBy('main_id')->toArray();
        foreach ($mains as $mains_key => $mains_value) {
            $data['user']['screens'][$mains_key."w"] = array(
                'id'    => $mains_value[0]->main_id ,
                'title' => $mains_value[0]->main_title ,
                'image' => $mains_value[0]->main_image ,
                'cats' => []
            );
            $cats   = collect($mains_value)->groupBy('cat_id')->toArray();
            foreach ($cats as $cats_key => $cats_value) {
                $data['user']['screens'][$mains_key."w"]['cats'][$cats_key."w"] = array(
                    'id'    => $cats_value[0]->cat_id ?? 0 ,
                    'title' => $cats_value[0]->cat_title ?? '' ,
                    'subs' => $cats_value
                );
            }
        }

        unset($data['user']['permissions']);
        // unset($data['user']['mypermissions']);
        return $data;
    }


    function gold_converter($c_18 , $c_21 , $c_22  , $c_24 )
    {

        // $data['c_18'] = round( $c_18 + ( $c_21 * 0.875 / 0.75  ) + ( $c_24 / 0.75 ) , 3 ) ;
        // $data['c_21'] = round( ( $c_18 * 0.75 / 0.875  ) + $c_21  + ( $c_24 / 0.875 ) , 3)  ;
        // $data['c_24'] = round( ( $c_18 * 0.75 ) + ( $c_21 * 0.875 ) +  $c_24 , 3 )  ;


        $data['c_18'] = round( $c_18 + ( $c_21 * 0.875 / 0.75  ) + ( $c_22 * 0.917 / 0.75  ) + ( $c_24 / 0.75 ) , 3 ) ;
        $data['c_21'] = round( ( $c_18 * 0.75 / 0.875  ) + $c_21  + ( $c_22 * 0.917 / 0.875  )  + ( $c_24 / 0.875 ) , 3)  ;
        $data['c_22'] = round( ( $c_18 * 0.75 / 0.917  ) + ( $c_21 * 0.875 /  0.917 )  + $c_22 + ( $c_24 / 0.917 ) , 3)  ;
        $data['c_24'] = round( ( $c_18 * 0.75 ) + ( $c_21 * 0.875 ) + ( $c_22 * 0.917  )  +  $c_24 , 3 )  ;


        return $data;
    }


    function generat_vat_prices($price , $qty , $discount , $tax_id , $include_vat){

        $return = [];
        $vat_per = ( DB::table('taxes')
            ->where('tax_id', $tax_id)
            ->value('tax_percentage') ?? 0 ) / 100;

        $return['item_price']           = ($include_vat? ( $price / ( 1 + $vat_per )) : ($price ) ) ;
        $return['item_discount']        = $discount / $qty ;
        $return['total_price']          = $return['item_price'] * $qty ;
        $return['total_discount']       = $discount;
        $return['total_without_vat']    = $return['total_price'] - $discount ;
        $return['total_vat']            = $return['total_without_vat'] * $vat_per ;
        $return['total_with_vat']       = $return['total_without_vat'] + $return['total_vat'] ;
        $return['vat_per']              = $vat_per;
        $return['tax_percent_id']       = $tax_id;

        return $return;


    }
    public function home_data($UserId , $lang){

        $user                   = User::find($UserId);
        $data =[
            'api_token'       => $user->api_token ,
            'full_name'       => $user->user_full_name ,
            'email'           => $user->email ,
            'mobile'          => $user->mobile ,
            'player_id'       => $user->player_id ?? 0 ,
            'image'           => $user->image_url ?? '' ,
            'title'           => $user->title ?? '' ,
            'pos'             => $user->pos ?? 0 ,
            'super_admin'     => $user->super_admin ?? 0,
            'is_nfc'            => $user->is_nfc ?? 0,

            'current_branch'  => $user->default_branch ?? 0 ,
            'current_year'    =>  $user->default_year ?? 0 ,
            'current_title'   => $user->title_id ?? 0 ,
            'screens'         => ($this->general_data( $UserId , $lang )['permissions']),

            // 'screens'         => $this->get_screens_tree($this->general_data( $UserId , $lang )['permissions']),
        ];

        return $data;
    }
    public function profile_data($UserId , $lang){
        $user = User::find($UserId);
        $erp_url = 'https://erp.qawaemerp.com';
        $pos_url = 'https://pos.qawaemerp.com';
        $from    = $_SERVER['HTTP_ORIGIN'] ?? '';

        $settings = [
            'digits'    => intval(Setting::get_main_setting_by_code('digits')->value ?? 2),
            'currency'  => Currency::get_currency(Setting::get_main_setting_by_code('default_currency')->value ?? 1, $lang),
            'min_amount_invoice'       => intval(Setting::get_main_setting_by_code('min_amount_invoice')->value ?? 0),
            'points_count_sar_usage'   => intval(Setting::get_main_setting_by_code('points_count_sar_usage')->value ?? 0),
            'invoices_needed_for_gift' => intval(Setting::get_main_setting_by_code('invoices_needed_for_gift')->value ?? 0),
            'disscount_points_per_one' => intval(Setting::get_main_setting_by_code('disscount points per one')->value ?? 0),
            'amount_sar_invoice'       => intval(Setting::get_main_setting_by_code('amount_sar_invoice')->value ?? 0),
            'gift_points_count'        => intval(Setting::get_main_setting_by_code('gift_points_count')->value ?? 0),
        ];
        $data =[
            'settings'          => $settings,
            'booking_count'     => DB::table('barber_bookings')->where([['barber_booking_active',1],['barber_booking_date',date('Y-m-d')],['has_invoice',0],])->count(),
            'shift'             => $this->get_current_shift($UserId),
            'branchs'           => $this->get_user_branchs($UserId,$lang),
            'years'             => $this->get_user_years($UserId,$lang),
            'titles'            => $this->get_user_titles($UserId,$lang),
            'current_branch'    => $this->get_current_shift($UserId)->branch_id ?? request()->header('branchid') ?? $user->default_branch ?? 0 ,
            'current_year'      => request()->header('yearid') ?? $user->default_year ?? 0 ,
            'current_title'     => request()->header('titleid') ?? $user->title_id ?? 0 ,
        ];
        $data['branch_data']    = Branch::get_branch( $data['current_branch'] , $lang );

        $path = public_path().$data['branch_data']->branch_image;
        if(file_exists($path) && is_file($path)){
            $type = pathinfo($path, PATHINFO_EXTENSION);
            $file = file_get_contents($path);
            $data['branch_data']->branch_image  = 'data:image/' . $type . ';base64,' . base64_encode($file);
        }else{
            $data['branch_data']->branch_image  = $data['branch_data']->branch_image;
        }

        $path = public_path().$data['branch_data']->header_image;
        if(file_exists($path) && is_file($path) ){
            $type = pathinfo($path, PATHINFO_EXTENSION);
            $file = file_get_contents($path);
            $data['branch_data']->header_image  = 'data:image/' . $type . ';base64,' . base64_encode($file);
        }else{
            $data['branch_data']->header_image  = $data['branch_data']->header_image;
        }

        if($from == $erp_url){
            $data['current_branch'] = $user->default_branch ?? 0;
        }elseif($from == $pos_url){
            $data['current_branch'] = $data['shift']->branch_id ?? $user->default_branch ?? 0;
        }else{
            $data['current_branch'] = $data['shift']->branch_id ?? $user->default_branch ?? 0;
        }
        return $data;
    }

    public function get_screens_tree($data) {
        $tree = [];
        foreach ($data as $row) {
            // Build the main screen
            if (!isset($tree[$row->main_id])) {
                $tree[$row->main_id] = [
                    'main_id' => $row->main_id,
                    'main_title' => $row->main_title,
                    'main_image' => $row->main_image,
                    'cats' => [],
                ];
            }
            // Build the category under the main screen
            if (!isset($tree[$row->main_id]['cats'][$row->cat_id])) {
                $tree[$row->main_id]['cats'][$row->cat_id] = [
                    'cat_id' => $row->cat_id,
                    'cat_title' => $row->cat_title,
                    'subs' => [],
                ];
            }
            // Add the sub screen under the category
            $tree[$row->main_id]['cats'][$row->cat_id]['subs'][] = [
                'sub_id'        => $row->sub_id,
                'sub_title'     => $row->sub_title,
                'cat_id'        => $row->cat_id,
                'cat_title'     => $row->cat_title,
                'main_id'       => $row->main_id,
                'main_title'    => $row->main_title,
                'screen_code'   => $row->screen_code,
                'permission'    => $row->permission,
                'url'           => $row->url,
                'actions'       => $row->actions,
            ];
        }
        return $tree;
    }
    function convert2english($string) {
        $newNumbers = range(0, 9);
        // 1. Persian HTML decimal
        $persianDecimal = array('&#1776;', '&#1777;', '&#1778;', '&#1779;', '&#1780;', '&#1781;', '&#1782;', '&#1783;', '&#1784;', '&#1785;');
        // 2. Arabic HTML decimal
        $arabicDecimal = array('&#1632;', '&#1633;', '&#1634;', '&#1635;', '&#1636;', '&#1637;', '&#1638;', '&#1639;', '&#1640;', '&#1641;');
        // 3. Arabic Numeric
        $arabic = array('٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩');
        // 4. Persian Numeric
        $persian = array('۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹');

        $string =  str_replace($persianDecimal, $newNumbers, $string);
        $string =  str_replace($arabicDecimal, $newNumbers, $string);
        $string =  str_replace($arabic, $newNumbers, $string);
        return str_replace($persian, $newNumbers, $string);
    }
}
?>
