<?php

namespace App\Classes\Sales;
use DB;
use App\Classes\Sales\SalesGeneralHelper;

class DeliveryNoteHelper
{
    function get_next_codes($date, $year, $branch)
    {
        $data['year_ser'] = intval(DB::table('delivery_note_m')
                ->where('finance_year_id', $year)
                ->max('year_ser')) + 1;

        $data['month_ser'] = intval(DB::table('delivery_note_m')
                ->where('finance_year_id', $year)
                ->max('month_ser')) + 1;

        $data['branch_ser'] = intval(DB::table('delivery_note_m')
                ->where('branch_id', $branch)
                ->max('branch_ser')) + 1;
        
        return $data;
    }

    function can_edit_or_delete($id)
    {
        $master     = DB::table('delivery_note_m')->where('delivery_note_m_id', $id)->first();
        $is_last    = DB::table('delivery_note_m')
            ->where('proforma_invoice_id', $master->proforma_invoice_id)
            ->where('delivery_note_active' , 1 )
            ->where('delivery_note_m_id' , '>' , $id)
            ->first();

        if($master->delivery_note_status != 1 || isset($is_last->delivery_note_m_id) ){
            return false;
        }

        return true;
    }

    function prepare_details($m_id , $proforma_invoice_id , $items ,  $price_include_vat , $stock_watch = 0){

        $return = [] ;
        foreach ($items as $key => $item) {
            $row =  (array) DB::table('proforma_invoice_d')
                ->where('proforma_invoice_m_id' , $proforma_invoice_id )
                ->where('proforma_invoice_d_id' , $item['d_id'] )
                ->selectRaw('proforma_invoice_d_id , tax_percent_id , vat_per , unit_id , item_id , warehouse_id , quantity , price ,item_price , total_price ,currency_id ,foreign_currency ,equivalent_value , item_discount , total_discount , unit_type , discount , discount_per , total_without_vat , total_with_vat , total_vat , description')
                ->first();
            
            $row['total_price']         = $item['delivered_quantity'] * $row['price'];
            $row['discount']            = $row['discount'] / $row['quantity'] * $item['delivered_quantity'];
            $row['total_discount']      = $row['total_discount'] / $row['quantity'] * $item['delivered_quantity'];
            $row['total_without_vat']   = $row['total_without_vat'] / $row['quantity'] * $item['delivered_quantity'];
            $row['total_with_vat']      = $row['total_with_vat'] / $row['quantity'] * $item['delivered_quantity'];
            $row['total_vat']           = $row['total_vat'] / $row['quantity'] * $item['delivered_quantity'];
            $row['rem_qty']             = $row['quantity'] - $item['delivered_quantity'];
            $row['quantity']            = $item['delivered_quantity'];
            $row['currency_id']         = $row['currency_id'];
            $row['foreign_currency']    = $row['foreign_currency'];
            $row['equivalent_value']    = $row['equivalent_value'];


            $return[$key]                       = $row;
            $return[$key]['delivery_note_m_id'] = $m_id ;
            $return[$key]['add_user']           = auth()->user()->id;

        }
        return $return;
    }

    function update_master_values($id)
    {

        $ids = [];
        if(is_array($id)){
            $ids = $id ;
        }else{
            $ids[] = $id ;
        }

        foreach ($ids as  $row) {

            $master     = DB::table('delivery_note_m')->where('delivery_note_m_id', $row)->first();
            $details    = DB::table('delivery_note_d')->where('delivery_note_m_id', $row)->get();

            DB::table('delivery_note_m')
                ->where('delivery_note_m.delivery_note_m_id', $row)
                ->update([
                    'total_discount'             => $details->sum('total_discount') ,
                    'total_vat'                  => $details->sum('total_vat') ,
                    'total_without_vat'          => $details->sum('total_without_vat') ,
                    'total_with_vat'             => $details->sum('total_with_vat') ,
                ]);

            if($master->sales_invoice_id > 0 ){
                DB::table('delivery_note_m')
                    ->where('delivery_note_m_id', $row)
                    ->update([ 'delivery_note_status' =>  2 ] );
            }

        }


        return true;
    }

    function generate_daily_journal($id)
    {
        return true;
    }
}
