<?php

namespace App\Http\Controllers\API\EX\V1;
use App\Http\Controllers\API\EX\V1\BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\Main\Platforms;
use App\Models\POS\Coupons;

class BookingReportController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function get_create_report($lang, Request $request)
    {
        $this->return['platforms'] = Platforms::all_platforms(array('active'=>1,'lang'=>$lang));
        $this->return['coupons'] = Coupons::all_coupons(array('active'=>1,'lang'=>$lang));
        return $this->sendResponse($this->return);
    }

    public function get_platform_report($lang ,Request $request)
    {
        $query = DB::table('platforms')
                        ->leftJoin('barber_bookings','barber_bookings.platform_id','platforms.platform_id')
                        ->where('platform_id', $request['platform_id'])
                        ->groupBy('platforms.platform_id')
                        ->selectRaw('
                            platforms.platform_id as id,
                            platforms.name'.$lang.' as name,
                            COUNT(barber_bookings.barber_booking_id) as bookings_count,
                            COUNT(barber_bookings.customer_id) as customers_count
                        ');
        $data = $query->get();
        return $this->sendResponse($data);
    }
    public function get_coupon_report($lang ,Request $request)
    {
        $query = DB::table('coupons')
                        ->leftJoin('barber_bookings','barber_bookings.coupon_id','coupons.coupon_id')
                        ->join('platforms' , function ( $join){
                            $join->on(DB::raw('FIND_IN_SET(platforms.platform_id,coupons.platforms_id)', ">" ,DB::raw(0)));
                        })
                        ->where('coupons.coupon_id', $request['coupon_id'])
                        ->groupBy('platforms.platform_id')
                        ->selectRaw('
                            coupons.coupon_id as id,
                            platforms.name'.$lang.' as name,
                            COUNT(barber_bookings.barber_booking_id) as bookings_count,
                            COUNT(barber_bookings.customer_id) as customers_count
                        ');
        $data = $query->get();
        return $this->sendResponse($data);
    }



}
