<?php

namespace App\Http\Controllers\API\V1\Assets;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;
use App\Models\Main\ScreenSub;
use App\Models\Assets\Assets;


class AssetsActionsController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        $this->checkPermission('06-021','view');
        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';

        return $this->sendResponse($this->return );
    }

    public function create($lang , Request $request)
    {
        $this->checkPermission('06-021','add');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';

        return $this->sendResponse( $this->return);
    }

    public function store(Request $request)
    {
        $this->checkPermission('06-021','add');

        $input    = $request->all();
        $insert = [
        ];
        $validator = validator()->make( $insert , Assets::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $this->return['id'] = Assets::add_asset($insert);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id )
    {
        $this->checkPermission('06-021','view');

        $this->return['screen_name']     = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        return $this->sendResponse( $this->return , '' );
    }

    public function update($lang, $id , Request $request)
    {
        $this->checkPermission('06-021','edit');

        $input  = $request->all();
        $update = [

        ];

        $validator  = validator()->make( $update , Assets::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        Assets::update_asset($update ,$id );
        $this->return = Assets::get_asset($id,$lang);
        return $this->sendResponse( [] , trans('main.update_success') );
    }

    public function destroy($id)
    {
        $this->checkPermission('06-021','delete');

        Assets::hard_delete_asset($id);

        return $this->sendResponse( [] , trans('main.delete_success') );
    }


    public function toggle_active($lang,$id){
        $item = Assets::get_asset($id,$lang);
        if($item->active){

            $this->checkPermission('06-021','delete');

            Assets::delete_asset($id);
            $this->return['active'] = false;

        }else{

            $this->checkPermission('06-021','edit');

            Assets::update_asset(array('active' => 1 ) , $id);
            $this->return['active'] = true;
        }
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

}
