<?php

namespace App\Http\Controllers\API\V1\Barbers;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Barbers\BarberCustomer;
use App\Models\Main\ScreenSub;
use Illuminate\Http\Request;

class BarberCustomerController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['10-003'][0]->permission ?? [])){
            return $this->sendError('view permission needed #10-003', $this->data, 200);
        }

        $this->filter = array(
            'lang' => $lang ,
            'rows' => $request['rows'] ?? 20 ,
            'page' => $request['page'] ?? 1 ,
            'word' => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('10-003', $lang)->sub_title ?? '';
        $this->return['items']       = BarberCustomer::all_barber_customers($this->filter);

        return $this->sendResponse($this->return);
    }
}
