<?php

namespace App\Http\Controllers\API\V1\Finance;
use App\Http\Controllers\API\V1\BaseController;
use App\Classes\Finance\MultiVoucherHelper;
use App\Classes\General\Upload;
use App\Models\Main\Setting;
use App\Models\Finance\AccountTree;
use App\Models\Finance\DailyJournal;
use App\Models\Finance\CostCenter;
use App\Models\Finance\MultiVoucher;
use App\Models\Finance\Treasury;
use App\Models\Main\Bank;
use App\Models\Main\ScreenSub;
use App\Models\Purchases\PurchasesAgent;
use App\Models\Purchases\PurchasesVendor;
use App\Models\Sales\Customer;
use App\Models\Sales\SalesAgent;
use App\Models\Finance\Tax;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class MultiVoucherController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {

        $this->checkPermission('02-013','view');

        $this->filter = array(
            'lang'         => $lang ,
            'active'       => $request['active'] ?? 1 ,
            'rows'         => $request['rows'] ?? 20 ,
            'page'         => $request['page'] ?? 1 ,
            'word'         => $request['word'] ?? null ,
            'branch'       => $this->data['current_branch'] ,
            'finance_year' => $this->data['current_year']
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-013', $lang)->sub_title ?? '';
        $this->return['items']       = MultiVoucher::all_multi_vouchers($this->filter);


        // if(request()->header('clientID') == '802'){
        //     $this->return['ids'] = [];

        //     $all = MultiVoucher::all_multi_vouchers(['lang' => $lang , 'active' => 1 ]);
        //     foreach ($all as $key => $value) {

        //         $daily_journal = (new MultiVoucherHelper)->generate_journal($value->id);
        //         if(!$daily_journal[0]){
        //             DB::rollback();
        //             return response()->json( array('check' => 0 , 'data' => $daily_journal[3] ?? [] , 'msg' => 'Error in createing journal code '.$daily_journal[1] ) );
        //         }
        //         DB::table('multi_voucher_m')
        //             ->where('multi_voucher_m_id' , $value->id)
        //             ->update( ['daily_journal_m_id' => $daily_journal[2]] );

        //     }

        // }


        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        $this->checkPermission('02-013','add');

        $this->return['screen_name']       = ScreenSub::get_screen_sub_by_screen_code('02-013', $lang)->sub_title ?? '';
        $this->return['bank']              = Bank::all_banks(array('lang' => $lang, 'active' => 1 ));
        $this->return['purchases_vendors'] = PurchasesVendor::all_purchases_vendors(array('lang' => $lang, 'active' => 1));
        $this->return['customers']         = Customer::all_customers(array('lang' => $lang, 'active' => 1));
        $this->return['account_trees']     = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => 1));
        $this->return['cost_centers']      = CostCenter::active_cost_centers($lang, array('account_type' => 2, 'active' => 1));
        $this->return['treasurys']         = Treasury::all_treasury(['lang' => $lang, 'active' => 1, 'user' => auth()->user()->id]);
        $this->return['taxes']             = Tax::all_taxes(['lang' => $lang, 'active' => 1 ] );
        $this->return['currencys']         = DB::table('currencys')->selectRaw("currency_id as id , name_".$lang." as name")->get();
        $this->return['types']             = [["id" => 1 , "name" => "مقبوضات"]];



        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        $this->checkPermission('02-013','add');


        $insert = $request->only(['action_date','conversion_type_id','currency_id','description' ,'document_number','description','items']);
        $year   = array_search(date("Y", strtotime($insert['action_date'])), $this->data['years']);
        if($year == ''){
            return $this->sendError(trans("error.finance_year_not_aval"));
        }

        if(count($request['items']) == 0 ){
           return $this->sendError(trans('error.update_fails'), ['details cant be empty']);
        }


        $coll = collect($request['items']);
        $amount_diff = $coll->where('voucher_type' , 1)->sum('amount') - $coll->where('voucher_type' , 2)->sum('amount');
        if($amount_diff >= 1 || $amount_diff <= -1){
           return $this->sendError(trans('error.update_fails'), ['Debit amount not credit amount ']);
        }

        $codes = (new MultiVoucherHelper)->get_next_codes($insert['action_date'], $year, $this->data['current_branch']);

        $master_seed = [
            'branch_id'          => $this->data['current_branch'],
            'finance_year_id'    => $year,
            'year_ser'           => $codes['year_ser'],
            'month_ser'          => $codes['month_ser'],
            'branch_ser'         => $codes['branch_ser'],
            'daily_journal_m_id' => 0,
            'action_date'        => $insert['action_date'],
            'description'        => $insert['description'],
            'conversion_type_id' => $insert['conversion_type_id'] ?? 0 ,
            'currency_id'        => $insert['currency_id'],
            'add_user'           => auth()->user()->id,

        ];

        $validator = validator()->make($master_seed, MultiVoucher::$master_rules);
        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();

            $m_id = MultiVoucher::add_multi_voucher_m($master_seed);

            foreach ($request['items'] as $row )
            {
                if($row['tax_id'] > 0 ){
                    $tax    = Tax::get_tax($row['tax_id'] , 'en');
                    $amount = $row['amount'] ;
                    $amount_without_vat = $row['amount'] / ( 1 + ( $tax->tax_percentage / 100 ) );
                    $total_vat = $amount - $amount_without_vat;
                }else{
                    $amount = $row['amount'] ;
                    $amount_without_vat = $row['amount'];
                    $total_vat = 0;
                }

                $row['cost_centers'] = (is_array($row['cost_centers'])? implode(',' , $row['cost_centers'] ) : $row['cost_centers'] );
                $details_seed = [
                    'multi_voucher_m_id'  => $m_id,
                    'voucher_type'        => $row['voucher_type'] ,
                    'taxable'             => $row['taxable'] ,
                    'amount_without_vat'  => $amount_without_vat  ,
                    'total_vat'           => $total_vat ,
                    'amount'              => $amount ,
                    'cost_centers'        => $row['cost_centers'] ?? '' ,
                    'tax_id'              => $row['tax_id'] ?? 0 ,
                    'description'         => $row['description'] ,
                    'dis_type'            => $row['dis_type'] ,
                    'dis_treasury_id'     => $row['dis_treasury_id']  ?? 0,
                    'dis_bank_id'         => $row['dis_bank_id']  ?? 0,
                    'dis_customer_id'     => $row['dis_customer_id'] ?? 0,
                    'dis_supplier_id'     => $row['dis_supplier_id'] ?? 0,
                    'dis_account_tree_id' => $row['dis_account_tree_id'] ?? 0,
                    'add_user'            => auth()->user()->id,
                ];
                $validator = validator()->make($details_seed, MultiVoucher::$details_rules);
                if($validator->fails()){
                    return $this->sendError(trans('error.add_fails'), $validator->errors());
                }

                MultiVoucher::add_multi_voucher_d($details_seed);

            }

            (new MultiVoucherHelper)->generate_journal($m_id);

        



        DB::commit();
        return $this->sendResponse([ 'id' => $m_id ], trans('main.add_success'));

    }

    public function show($lang, $id)
    {
        $this->checkPermission('02-013','view');

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('02-013' , $lang)->sub_title ?? '';
        $this->return['master']             = MultiVoucher::get_multi_voucher_m($id, $lang);
        $this->return['details']            = MultiVoucher::get_multi_voucher_d($id, $lang);
        $this->return['bank']               = Bank::all_banks(array('lang' => $lang, 'active' => 1 ));
        $this->return['purchases_vendors']  = PurchasesVendor::all_purchases_vendors(array('lang' => $lang, 'active' => 1));
        $this->return['customers']          = Customer::all_customers(array('lang' => $lang, 'active' => 1));
        $this->return['account_trees']      = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => 1));
        $this->return['cost_centers']       = CostCenter::active_cost_centers($lang, array('account_type' => 2, 'active' => 1));
        $this->return['treasurys']          = Treasury::all_treasury(['lang' => $lang, 'active' => 1, 'user' => auth()->user()->id]);
        $this->return['taxes']              = Tax::all_taxes(['lang' => $lang, 'active' => 1 ] );
        $this->return['currencys']          = DB::table('currencys')->selectRaw("currency_id as id , name_".$lang." as name")->get();
        $this->return['types']              = [["id" => 1 , "name" => "مقبوضات"],["id" => 2 , "name" => "مدفوعات"]];
        $this->return['attachments']        = MultiVoucher::get_attachs($id);


        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function update($lang, $id, Request $request)
    {
        $this->checkPermission('02-013','edit');


        $update = $request->only(['action_date','conversion_type_id','currency_id','description' ,'document_number','description','items']);
        $year   = array_search(date("Y", strtotime($update['action_date'])), $this->data['years']);
        if($year == ''){
            return $this->sendError(trans("error.finance_year_not_aval"));
        }
        if(count($request['items']) == 0 ){
           return $this->sendError(trans('error.update_fails'), ['details cant be empty']);
        }
        $coll = collect($request['items']);
        $amount_diff = $coll->where('voucher_type' , 1)->sum('amount') - $coll->where('voucher_type' , 2)->sum('amount');
        if($amount_diff >= 1 || $amount_diff <= -1){
           return $this->sendError(trans('error.update_fails'), ['Debit amount not credit amount ']);
        }
        $codes = (new MultiVoucherHelper)->get_next_codes($update['action_date'], $year, $this->data['current_branch']);

        $master_seed = [
            'branch_id'          => $this->data['current_branch'],
            'finance_year_id'    => $year,
            'year_ser'           => $codes['year_ser'],
            'month_ser'          => $codes['month_ser'],
            'branch_ser'         => $codes['branch_ser'],
            'action_date'        => $update['action_date'],
            'description'        => $update['description'],
            'conversion_type_id' => $update['conversion_type_id'] ?? 0,
            'currency_id'        => $update['currency_id'],
            'add_user'           => auth()->user()->id,
        ];


        $validator = validator()->make($master_seed, MultiVoucher::$master_rules);
        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();

            MultiVoucher::update_multi_voucher_m($master_seed,$id);
            $in_active = DB::table('multi_voucher_d')
                ->whereNotIn('multi_voucher_d_id' , array_filter( collect($request['items'])->pluck('d_id')->toArray() ) )
                ->where('multi_voucher_m_id' , $id )
                // ->where('multi_voucher_d_active' , 1 )
                ->delete();

            foreach ($request['items'] as $row )
            {
                if($row['tax_id'] > 0 ){
                    $tax    = Tax::get_tax($row['tax_id'] , 'en');
                    $amount = $row['amount'] ;
                    $amount_without_vat = $row['amount'] / ( 1 + ( $tax->tax_percentage / 100 ) );
                    $total_vat = $amount - $amount_without_vat;
                }else{
                    $amount = $row['amount'] ;
                    $amount_without_vat = $row['amount'];
                    $total_vat = 0;
                }
                $row['cost_centers'] = (is_array($row['cost_centers'])? implode(',' , $row['cost_centers'] ) : $row['cost_centers'] );
                $details_seed = [
                    'multi_voucher_m_id'  => $id,
                    'voucher_type'        => $row['voucher_type'] ,
                    'amount_without_vat'  => $amount_without_vat  ,
                    'total_vat'           => $total_vat ,
                    'amount'              => $amount ,
                    'cost_centers'        => $row['cost_centers'] ?? '' ,
                    'tax_id'              => $row['tax_id'] ?? 0  ,
                    'description'         => $row['description'] ,
                    'dis_type'            => $row['dis_type'] ,
                    'dis_treasury_id'     => $row['dis_treasury_id']  ?? 0,
                    'dis_bank_id'         => $row['dis_bank_id']  ?? 0,
                    'dis_customer_id'     => $row['dis_customer_id'] ?? 0,
                    'dis_supplier_id'     => $row['dis_supplier_id'] ?? 0,
                    'dis_account_tree_id' => $row['dis_account_tree_id'] ?? 0
                ];

                $validator = validator()->make($details_seed, MultiVoucher::$details_rules);
                if($validator->fails()){
                    return $this->sendError(trans('error.add_fails'), $validator->errors());
                }

                if(isset($row['d_id']) && $row['d_id'] > 0){
                    DB::table('multi_voucher_d')->where('multi_voucher_d_id', $row['d_id'])->update($details_seed);
                }else{
                    $details_seed['add_user'] = auth()->user()->id ;
                    MultiVoucher::add_multi_voucher_d($details_seed);
                }

            }
            (new MultiVoucherHelper)->generate_journal($id);

      

        DB::commit();

        return $this->sendResponse([], trans('main.update_success'));

    }

    public function destroy($lang, $id)
    {
        $this->checkPermission('02-013','delete');


        $master = MultiVoucher::get_multi_voucher_m($id);

        if(!isset($master->multi_voucher_m_id) || $master->branch_id != $this->data['current_branch'] || !(new MultiVoucherHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.delete_fail"));
        }


        DB::beginTransaction();
            MultiVoucher::delete_multi_voucher_m($id);
            (new MultiVoucherHelper)->generate_journal($id);
        DB::commit();



        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $master = MultiVoucher::get_multi_voucher_m($id);

        if($master->multi_voucher_active){
            $this->checkPermission('02-013','delete');


            if(!(new MultiVoucherHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.delete_fails'), []);
            }

            DB::beginTransaction();
                MultiVoucher::delete_multi_voucher_m($id);
                (new MultiVoucherHelper)->generate_journal($id);
            DB::commit();


            $this->return['active'] = false;

        }else{
            $this->checkPermission('02-013','edit');


            if(!(new MultiVoucherHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.update_fails'), []);
            }

            DB::beginTransaction();
                MultiVoucher::update_multi_voucher_m(array('multi_voucher_active' => 1), $id);
                (new MultiVoucherHelper)->generate_journal($id);

                
         

            DB::commit();

            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function add_attach($lang , $id , Request $request){

        $upload = new Upload;
        $check  = $upload->uploadFile($request['file_path'] , 'multi_voucher' );
        if(!$check['check'])
            return $this->sendError( trans('error.add_fails') , $check['msg'] );


        $this->return['id'] = DB::table('multi_voucher_attachments')->insertGetId( [
            'multi_voucher_id'      => $id ,
            'file_name'             => $request['file_name'] ?? date('Y-m-d H:i:s'),
            'file_path'             => $check['url']  ,
            'file_ext'              => $check['extension']  ,
            'add_user'              => auth()->user()->id
        ]);



        return $this->sendResponse( $this->return , '' );
    }

    public function download_attach($lang , $id){

        $file = DB::table('multi_voucher_attachments')
            ->where('attachment_id' , $id)
            ->first();

        return response()->file(public_path().$file->file_path);

    }

    public function get_attachs($lang , $id){
        $this->return['data'] = MultiVoucher::get_attachs($id);
        return $this->sendResponse( $this->return , '' );

    }

    public function delete_attach($lang , $id){

        $file = DB::table('multi_voucher_attachments')
            ->where('attachment_id' , $id)
            ->first();

        DB::table('multi_voucher_attachments')
            ->where('attachment_id' , $id)
            ->delete();

        if(Storage::exists($file->file_path)){
            Storage::delete($file->file_path);
        }

        return $this->sendResponse( $this->return , '' );
    }
}
