<?php
namespace App\Http\Controllers\API\V1\Main;
use App\Http\Controllers\API\V1\BaseController;
use App\Classes\General\Upload;
use App\Models\Inventory\Warehouse;
use Illuminate\Http\Request;


use App\Models\User;
use App\Models\Main\Branch;
use App\Models\Finance\AccountTree;
use App\Models\Finance\CostCenter;
use App\Models\Main\MainSetting;
use App\Models\Main\ScreenSub;
use App\Models\Main\SalesAgent;



class BranchController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-006'][0]->permission) ){
            return $this->sendError( 'view permission needed #01-006' , $this->data , 200 );
        }

        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null ,
        );
        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-006' , $lang)->sub_title ?? '';
        $this->return['items']       = Branch::all_branchs( $this->filter );
        return $this->sendResponse( $this->return );
    }

    public function create($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-006'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-006' , [] , 200 );
        }
        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('01-006' , $lang)->sub_title ?? '';
        $this->return['account_trees']      = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['cost_centers']       = CostCenter::active_cost_centers($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['users']              = User::all_users( array('lang' => $lang , 'active' => 1 ));
        $this->return['warehouses']         = Warehouse::all_warehouses(array('active' => 1, 'lang' => $lang));

        return $this->sendResponse( $this->return  );
    }

    public function store($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-006'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-006' , [] , 200 );
        }
        $validator = validator()->make( $request->all() , Branch::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $insert                         = $request->only(['name_en', 'name_ar', 'first_cash', 'vat_register_name', 'vat_number',
                                                          'branch_image', 'bank_account_id', 'treasury_account_id',
                                                          'settlement_account', 'account_tree_id', 'cost_center_id', 'stock_type', 'users',
                                                          'header_image', 'print_header_active', 'print_footer_active', 'top_margin', 'right_margin',
                                                          'bottom_margin', 'left_margin', 'print_label_ar', 'print_label_en', 'print_footer', 'default_warehouse']);
        $insert['print_margin']         = ($insert['top_margin'] ?? '0px').' '.($insert['right_margin'] ?? '0px').' '.($insert['bottom_margin'] ?? '0px').' '.($insert['left_margin'] ?? '0px');
        $insert['users']                = ( is_array($insert['users'] ?? []) ) ? implode(',', $insert['users'] ?? [] ) : $insert['users'] ;
        $insert['add_user']             = auth()->user()->id;
        unset($insert['top_margin'] , $insert['right_margin'] , $insert['bottom_margin'] , $insert['left_margin']);
        if(isset($insert['branch_image']) && strlen($insert['branch_image']) > 100){
            $upload = new Upload;
            $check  = $upload->uploadBase64Image($request['branch_image'] , 'branch' , 300 , 300 );
            if(!$check['check'])
                return $this->sendError( trans('error.add_fails') , $check['msg'] );
            else
                $insert['branch_image'] = $check['url'];
        }

        if(isset($insert['header_image']) && strlen($insert['header_image']) > 100){
            $upload = new Upload;
            $check  = $upload->uploadBase64Image($request['header_image'] , 'branch' , 300 , 300 );
            if(!$check['check'])
                return $this->sendError( trans('error.add_fails') , $check['msg'] );
            else
                $insert['header_image'] = $check['url'];
        }
        $this->return['id'] = Branch::add_branch($insert);
        return $this->sendResponse( $this->return , trans('main.add_success') );

    }

    public function show($lang , $id , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-006'][0]->permission) ){
            return $this->sendError( 'show permission needed #01-006' , [] , 200 );
        }
        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('01-006' , $lang)->sub_title ?? '';

        $this->return['account_trees']  = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['cost_centers']   = CostCenter::active_cost_centers($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['data']           = Branch::find($id );
        $this->return['users']          = User::all_users( array('lang' => $lang , 'active' => 1 ));
        $this->return['warehouses']     = Warehouse::all_warehouses(array('active' => 1, 'lang' => $lang));
        $print_margin                   = explode(' ' , $this->return['data']->print_margin);
        $this->return['data']->top_margin = $print_margin[0] ?? '0px';
        $this->return['data']->right_margin = $print_margin[1] ?? '0px';
        $this->return['data']->bottom_margin = $print_margin[2] ?? '0px';
        $this->return['data']->left_margin = $print_margin[3] ?? '0px';

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function update($lang , $id , Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['01-006'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-006' , [] , 200 );
        }

        $update                         = $request->only(['name_en', 'name_ar', 'first_cash', 'vat_register_name', 'vat_number',
                                                          'branch_image', 'bank_account_id', 'treasury_account_id',
                                                          'settlement_account', 'account_tree_id', 'cost_center_id', 'stock_type', 'users',
                                                          'header_image', 'print_header_active', 'print_footer_active', 'top_margin', 'right_margin',
                                                          'bottom_margin', 'left_margin', 'print_label_ar', 'print_label_en', 'print_footer', 'default_warehouse']);
        
        $update['print_margin']         = $update['top_margin']." ".$update['right_margin']." ".$update['bottom_margin']." ".$update['left_margin'];
        $update['users']                = ( is_array($update['users'] ?? []) ) ? implode(',', $update['users'] ?? [] ) : $update['users'] ;

        if(isset($update['branch_image']) && strlen($update['branch_image']) > 100){
            $upload = new Upload;
            $check  = $upload->uploadBase64Image($request['branch_image'] , 'branch' , 300 , 300 );
            if(!$check['check'])
                return $this->sendError( trans('error.add_fails') , $check['msg'] );
            else
                $update['branch_image'] = $check['url'];
        }

        if(isset($update['header_image']) && strlen($update['header_image']) > 100){
            $upload = new Upload;
            $check  = $upload->uploadBase64Image($request['header_image'] , 'branch' , 300 , 300 );
            if(!$check['check'])
                return $this->sendError( trans('error.add_fails') , $check['msg'] );
            else
                $update['header_image'] = $check['url'];
        }
        unset($update['top_margin'] , $update['right_margin'] , $update['bottom_margin'] , $update['left_margin']);

        $validator = validator()->make( $update , Branch::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        Branch::update_branch($update ,  $id);
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    public function destroy($lang , $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['01-006'][0]->permission) ){
            return $this->sendError( 'delete permission needed #01-006' , [] , 200 );
        }
        Branch::delete_branch($id);
        return $this->sendResponse( [] , trans('main.delete_success') );
    }

    public function sort_post($lang , Request $request){
        if(!@in_array('3', $this->data['mypermissions']['01-006'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-006' , [] , 200 );
        }

        $sort = $request->all();
        foreach ($sort['items'] as $key => $value) {
            Branch::update_branch(array('branch_order' => $key ),  $value['id']);
        }
        return $this->sendResponse( [] , trans('main.update_success') );

    }

    public function toggle_active($lang , $id){
        $item = Branch::find($id);
        if($item->branch_active){

            if(!@in_array('4', $this->data['mypermissions']['01-006'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-006' , [] , 200 );
            }

            Branch::delete_branch($id);
            $this->return['active'] = false;

        }else{

            if(!@in_array('3', $this->data['mypermissions']['01-006'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-006' , [] , 200 );
            }

            Branch::update_branch(array('branch_active' => 1 ) , $id);
            $this->return['active'] = true;
        }
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

}



