<?php

namespace App\Http\Controllers\API\V1\Main;

use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;
use App\Models\Main\ScreenSub;
use App\Models\Main\DailyType;
use Validator;


class DailyTypeController extends BaseController
{
    protected $return = array();
    protected $filter = array();
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-005'][0]->permission) ){
            return $this->sendError( 'view permission needed #01-005' , $this->data , 200 );
        }

        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null

        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-005' , $lang)->sub_title ?? '';
        $this->return['items']       = DailyType::all_daily_types( $this->filter );
        return $this->sendResponse( $this->return );
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-005'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-005' , [] , 200 );
        }

        $insert             = $request->only(['name_en', 'name_ar']);
        $insert['add_user'] = auth()->user()->id;
        $validator          = validator()->make( $insert , DailyType::$rules );

        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $this->return['id'] = DailyType::add_daily_type($insert);
        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-005'][0]->permission) ){
            return $this->sendError( 'show permission needed #01-005' , [] , 200 );
        }
        $this->return['screen_name']          = ScreenSub::get_screen_sub_by_screen_code('01-005' , $lang)->sub_title ?? '';
        $this->return['data']                 = DailyType::get_daily_type($id);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($lang , $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['01-005'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-005' , [] , 200 );
        }

        $update    = $request->only(['name_en', 'name_ar']);
        $validator = Validator::make( $request->all() , DailyType::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        DailyType::update_daily_type($update ,  $id );
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['01-005'][0]->permission) ){
            return $this->sendError( 'delete permission needed #01-005' , [] , 200 );
        }
        DailyType::delete_daily_type($id);
        return $this->sendResponse( [] , trans('main.delete_success') );

    }

    public function sort_post($lang , Request $request){
        if(!@in_array('3', $this->data['mypermissions']['01-005'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-005' , [] , 200 );
        }

        $sort = $request->all();
        foreach ($sort['items'] as $key => $value) {
            DailyType::update_daily_type(array('daily_type_order' => $key ),  $value['id']);
        }
        return $this->sendResponse( [] , trans('main.update_success') );

    }

    public function toggle_active($lang , $id){
        $item = DailyType::find($id);
        if($item->daily_type_active){

            if(!@in_array('4', $this->data['mypermissions']['01-005'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-005' , [] , 200 );
            }

            DailyType::delete_daily_type($id);
            $this->return['active'] = false;

        }else{

            if(!@in_array('3', $this->data['mypermissions']['01-005'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-005' , [] , 200 );
            }

            DailyType::update_daily_type(array('daily_type_active' => 1 ) , $id);
            $this->return['active'] = true;
        }
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }
}
