<?php

namespace App\Http\Controllers\API\V1\Main;

use App\Classes\Finance\DailyJournalHelper;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Finance\DailyJournal;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Main\ScreenSub;
use App\Models\Main\FinanceYear;
use DB;

class FinanceYearController extends BaseController
{
    protected $return = array();
    protected $filter = array();
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($lang , Request $request)
    {
        $this->checkPermission('01-004','view');

        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null

        );
        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-004' , $lang)->sub_title ?? '';
        $this->return['items']       = FinanceYear::all_finance_years( $this->filter  );
        return $this->sendResponse( $this->return );
    }

    public function create($lang , Request $request)
    {
        $this->checkPermission('01-004','add');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('01-004' , $lang);
        $this->return['users']          = User::all_users( array('lang' => $lang , 'active' => 1 ));
        return $this->sendResponse( $this->return  );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->checkPermission('01-004','add');

        $insert             = $request->only(['name', 'users']);
        $insert['add_user'] = auth()->user()->id;
        $insert['users']    = ( is_array($insert['users'] ?? []) ) ? implode(',', $insert['users'] ?? [] ) : $insert['users'] ;
        $validator          = validator()->make( $insert , FinanceYear::$rules );

        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $this->return['id'] = FinanceYear::add_finance_year($insert);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($lang, $id)
    {
        $this->checkPermission('01-004','view');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('01-004' , $lang)->sub_title ?? '';
        $this->return['users']          = User::all_users( array('lang' => $lang , 'active' => 1 ));
        $this->return['data']           = FinanceYear::get_finance_year($id);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($lang, $id, Request $request)
    {
        $this->checkPermission('01-004','edit');

        $update             = $request->only(['name', 'users']);
        $update['users']    = ( is_array($update['users'] ?? []) ) ? implode(',', $update['users'] ?? [] ) : $update['users'] ;
        $validator          = validator()->make( $update , FinanceYear::$rules );

        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        FinanceYear::update_finance_year($update ,  $id );
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($lang, $id)
    {
        $this->checkPermission('01-004','delete');

        FinanceYear::delete_finance_year($id);
        return $this->sendResponse( [] , trans('main.delete_success') );
    }

    public function sort_post($lang , Request $request){
        $this->checkPermission('01-004','edit');

        $sort = $request->all();
        foreach ($sort['items'] as $key => $value) {
            FinanceYear::update_finance_year(array('finance_year_order' => $key ),  $value['id']);
        }
        return $this->sendResponse( [] , trans('main.update_success') );

    }

    public function toggle_active($lang , $id){
        $item = FinanceYear::find($id);
        if($item->finance_year_active){

            $this->checkPermission('01-004','delete');

            FinanceYear::delete_finance_year($id);
            $this->return['active'] = false;

        }else{

            $this->checkPermission('01-004','edit');

            FinanceYear::update_finance_year(array('finance_year_active' => 1 ) , $id);
            $this->return['active'] = true;
        }
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

}

