<?php

namespace App\Http\Controllers\API\V1\Main;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Main\Lookups;
use Illuminate\Http\Request;

class LookupsController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        $this->checkPermission('03-002','view');
        $this->return = Lookups::get_all();
        return $this->sendResponse($this->return);
    }



    public function show($lang, Request $request)
    {
        $this->checkPermission('03-002','view');
        $params = $request->all();
        $filter = [
            'lang'      => $lang,
            'lookups'   => $params['lookups'],
            'all'       => $params['all'] ?? false
        ];
        if($filter['all'] == true){
            $filter['lookups'] = Lookups::get_all();
        }
        $this->return = Lookups::get_data($filter);

        return $this->sendResponse($this->return);
    }

}
