<?php

namespace App\Http\Controllers\API\V1\Main;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;

use App\Models\Main\NetworkMachine;
use App\Models\Finance\AccountTree;
use App\Models\Main\ScreenSub;
use App\Models\Main\Branch;
use App\Models\Main\Bank;


class NetworkMachineController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-009'][0]->permission) ){
            return $this->sendError( 'view permission needed #01-009' , $this->data , 200 );
        }

        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1   ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1   ,
        );
        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-009' , $lang)->sub_title ?? '';
        $this->return['items']       = NetworkMachine::all_network_machines( $this->filter );

        return $this->sendResponse( $this->return );
    }

    public function create($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-009'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-009' , [] , 200 );
        }

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('01-009' , $lang)->sub_title ?? '';
        $this->return['account_tree']       = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['branchs']            = Branch::all_branchs( array('lang' => $lang , 'active' => 1 ) );
        $this->return['banks']              = Bank::all_banks( array('lang' => $lang , 'active' => 1 )  );

        return $this->sendResponse( $this->return );
    }

    public function store($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-009'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-009' , [] , 200 );
        }

        $insert             = $request->only(['name_en', 'name_ar', 'account_tree_id', 'branch_id', 'bank_id']);
        $insert['add_user'] = auth()->user()->id;
        $validator          = validator()->make( $insert , NetworkMachine::$rules );

        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $this->return['id'] = NetworkMachine::add_network_machine($insert);
        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-009'][0]->permission) ){
            return $this->sendError( 'show permission needed #01-009' , [] , 200 );
        }

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('01-009' , $lang)->sub_title ?? '';
        $this->return['data']               = NetworkMachine::find($id);
        $this->return['account_tree']       = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['branchs']            = Branch::all_branchs( array('lang' => $lang , 'active' => 1 ) );
        $this->return['banks']              = Bank::all_banks( array('lang' => $lang , 'active' => 1 )  );


        return $this->sendResponse( $this->return , '' );
    }

    public function update($lang , $id , Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['01-009'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-009' , [] , 200 );
        }

        $update     = $request->only(['name_en', 'name_ar', 'account_tree_id', 'branch_id', 'bank_id']);
        $validator  = validator()->make( $update , NetworkMachine::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        NetworkMachine::update_network_machine($update ,  $id );
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    public function destroy($lang , $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['01-009'][0]->permission) ){
            return $this->sendError( 'delete permission needed #01-009' , [] , 200 );
        }

        NetworkMachine::delete_network_machine($id);

        return $this->sendResponse( [] , trans('main.delete_success') );
    }

    public function sort_post($lang , Request $request){
        if(!@in_array('3', $this->data['mypermissions']['01-009'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-009' , [] , 200 );
        }

        $sort = $request->all();
        foreach ($sort['items'] as $key => $value) {
            NetworkMachine::update_network_machine(array('network_machine_order' => $key ),  $value['id']);
        }
        return $this->sendResponse( [] , trans('main.update_success') );

    }

    public function toggle_active($lang , $id){
        $item = NetworkMachine::find($id);
        if($item->network_machine_active){

            if(!@in_array('4', $this->data['mypermissions']['01-009'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-009' , [] , 200 );
            }

            NetworkMachine::delete_network_machine($id);
            $this->return['active'] = false;

        }else{

            if(!@in_array('3', $this->data['mypermissions']['01-009'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-009' , [] , 200 );
            }

            NetworkMachine::update_network_machine(array('network_machine_active' => 1 ) , $id);
            $this->return['active'] = true;
        }
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }
}
