<?php

namespace App\Http\Controllers\API\V1\Main;
use App\Http\Controllers\API\V1\BaseController;
use App\Classes\General\Upload;
use Illuminate\Http\Request;

use App\Models\Finance\AccountTree;
use App\Models\Main\Setting;
use App\Models\Main\ScreenSub;
use App\Models\Sales\Customer;
use App\Models\Finance\Tax;
use App\Models\Finance\Currency;
use App\Models\Inventory\UnitMeasurement;
use App\Models\User;

class SettingController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-010'][0]->permission) ){
            return $this->sendError( 'view permission needed #01-010' , $this->data , 200 );
        }

        $this->filter = array(
            'lang'        => $lang ,
            // 'active'      => $request['active'] ?? 1 ,
            // 'rows'        => $request['rows'] ?? null ,
            // 'page'        => $request['page'] ?? 1 ,
            'main_id'     => ScreenSub::get_screen_sub($request['sub_id'] ?? null , $lang)->main_id ?? 0 ,
            'word'        => $request['word'] ?? null
        );

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('01-010' , $lang)->sub_title ?? '';
        $this->return['settings']       = [];
        $items                          = Setting::all_settings( $this->filter )->groupBy('category_id');
        $this->return['loockups']       = [];

        foreach ($items as $key => $value) {

            foreach ($value as $i => $v) {
                if($value[$i]->type == 'select' && $value[$i]->multi == 1){
                    $value[$i]->value = json_decode($value[$i]->value ,true);
                }elseif(in_array($value[$i]->type , ['select' , 'list' , 'radiogroup' , 'checkbox' , 'switch'])){
                    $value[$i]->value = intval($value[$i]->value );
                }
            }
            $this->return['settings'][] = array(
                'id'        => $value[0]->category_id ,
                'title'     => $value[0]->category_title ,
                'settings'  => $value
            );
        }
        $this->return['loockups']['currencies'] = Currency::all_currency( array('lang' => $lang , 'active' => 1 ) );
        $this->return['loockups']['accounts']   = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['loockups']['customers']  = Customer::all_customers( array('lang' => $lang , 'active' => 1 ));
        $this->return['loockups']['taxes']      = Tax::all_taxes( array('lang' => $lang , 'active' => 1 ));
        $this->return['loockups']['users']      = User::all_users( array('lang' => $lang , 'active' => 1 ));
        $this->return['loockups']['units']      = UnitMeasurement::all_unit_measurements(array('active' => 1, 'lang' => $lang));



        foreach ($this->return['loockups']['accounts'] as $key => $value) {
            // $this->return['loockups']['accounts'][$key]->id = strval($this->return['loockups']['accounts'][$key]->id);
        }

        foreach ($this->return['loockups']['customers'] as $key => $value) {
            // $this->return['loockups']['customers'][$key]->id = strval($this->return['loockups']['customers'][$key]->id);
        }

        foreach ($this->return['loockups']['taxes'] as $key => $value) {
            // $this->return['loockups']['taxes'][$key]->id = strval($this->return['loockups']['taxes'][$key]->id);
        }

        $this->return['loockups']['list'] = array(
            array(
                'id'    => 1 ,
                'name'  => 'Yes '
            ),
            array(
                'id'    => 0 ,
                'name'  => 'No'
            )
        );

        return $this->sendResponse( $this->return );
    }

    public function update($lang , $id , Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['01-010'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-010' , [] , 200 );
        }
        $update     = [];
        $items      = $request->only('items');
        foreach ($items['items'] as $row) {
            if( $row['old_value'] != $row['new_value'] ){

                $item = Setting::get_setting($row['id'] );
                if( $item->type == 'file'  ){

                    if(isset($row['new_value']) && strlen($row['new_value']) > 100){
                        $upload = new Upload;
                        $check  = $upload->uploadBase64Image($row['new_value'] , 'setting' );
                        if(!$check['check'])
                            return $this->sendError( trans('error.add_fails') , $check['msg'] );
                        else
                            $update['value'] = $check['url'];
                    }

                }else{
                    $update['value'] = $row['new_value'];
                }

                Setting::update_setting($update['value'] , $row['id']);

            }
        }

        return $this->sendResponse( [] , trans('main.update_success') );
    }


}
