<?php

namespace App\Http\Controllers\API\V1\POS;

use App\Classes\RealTime\NotificationHelper;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Barbers\Barber;
use App\Models\Main\ScreenSub;
use App\Models\POS\BarberBooking;
use Illuminate\Http\Request;
use DB;

class BarberBookingController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function get_barber_bookings($lang, Request $request)
    {
        // if(!@in_array('1', $this->data['mypermissions']['10-004'][0]->permission ?? [])){
        //     return $this->sendError('view permission needed #10-004', $this->data, 200);
        // }

        $this->filter = array(
            'lang'      => $lang ,
            'active'    => $request['active'] ?? 1 ,
            'rows'      => $request['rows'] ?? 20 ,
            'page'      => $request['page'] ?? 1 ,
            'status'    => $request['status'] ?? null ,
            'from_date' => $request['from_date'] ?? null ,
            'to_date'   => $request['to_date'] ?? null ,
            'word'      => $request['word'] ?? null ,
            'has_invoice'=> $request['has_invoice'] ?? null 
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('10-004', $lang)->sub_title ?? '';
        $this->return['items']       = BarberBooking::all_barber_bookings($this->filter);

        return $this->sendResponse($this->return);
    }

    public function get_barber_booking($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['10-004'][0]->permission ?? [])){
            return $this->sendError('view permission needed #10-004', $this->data, 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('10-004', $lang)->sub_title ?? '';
        $this->return['data']        = BarberBooking::get_barber_booking($id, $lang);
        $this->return['barbers'] = Barber::all_barbers(array('lang'=>$lang,'active'=>1));

        $services = explode(',', $this->return['data']->services);
        $this->return['services'] = DB::table('items')
            ->leftjoin('taxes', 'items.tax_id', '=', 'taxes.tax_id')
            ->select(
                'item_id',
                'items.name_'.$lang.' as item_name',
                'sale_price as item_price',
                'image as item_image',
                DB::raw('(CASE WHEN items.default_report_unit_type = 3 THEN items.big_unit_id WHEN items.default_report_unit_type = 2 THEN items.mid_unit_id ELSE items.small_unit_id END) AS unit_id'),
                'taxes.tax_percentage as tax_percent'
            )
            ->whereIn('item_id', $services)
            ->get();

        return $this->sendResponse($this->return);
    }
}
