<?php

namespace App\Http\Controllers\API\V1\POS;

use App\Classes\General\General;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\POS\SalesInvoice;
use App\Models\Sales\Customer;
use Illuminate\Http\Request;
use App\Models\Main\Branch;
use App\Models\Sales\Shift;
use App\Models\User;
use DB;

class GeneralController extends BaseController
{
    protected $return = array();
    protected $filter = array();

//    public function get_my_profile($lang)
//    {
//        $this->return = (new General)->general_data(auth()->user()->id, $lang);
//        return $this->sendResponse($this->return);
//    }

    public function add_customer($lang, Request $request)
    {
        $input = $request->only(['name', 'phone', 'notes']);

        $count = DB::table('customers')
//            ->where('customer_type_id', 2)
            ->where('name_en', $input['name'])
            ->count();

        if($count > 0)
            return $this->sendError(trans('error.Customer Name Duplicated'));

        $seed = [
            'name_en' => $input['name'],
            'name_ar' => $input['name'],
            'phone'   => $input['phone'],
            'notes'   => $input['notes'],
        ];

        $customer = Customer::add_customer($seed);

        DB::table('customer_contacts')
            ->insert([
                'customer_id'   => $customer ,
                'name'          => $input['name'] ,
                'phone'         => $input['phone']
            ]);
        $this->return['customer'] = Customer::get_customer($customer, $lang);
        return $this->sendResponse($this->return['customer']);
    }

    public function get_home_data($lang, Request $request)
    {
        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? 20 ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
        );

        // $this->return['cash_totals']          = DB::table('sales_invoice_payments')->where('payment_type', 1)->sum('amount');
        // $this->return['bank_totals']          = DB::table('sales_invoice_payments')->where('payment_type', 2)->sum('amount');
        // $this->return['sales_invoices_count'] = DB::table('sales_invoice_m')->where('sales_invoice_active', 1)->count();
        // $this->return['sales_orders_count']   = DB::table('sales_order_m')->where('sales_order_active', 1)->count();
        // $this->return['daily_requests']       = SalesInvoice::daily_requests($this->filter);


        $this->return['cash_totals']          = 0;
        $this->return['bank_totals']          = 0;
        $this->return['sales_invoices_count'] = 0;
        $this->return['sales_orders_count']   = 0;
        $this->return['daily_requests']       = [];

        return $this->sendResponse($this->return);
    }

    public function start_shift($lang, Request $request)
    {
        $input = $request->all();

        if(!isset($this->data['shift']->shift_id)){
            $branchs    = $this->data['branchs'];
            $branch_ids = array_keys($branchs);

            if(in_array($input['branch'], $branch_ids)){
                $branch_id = $input['branch'];
            }else{
                $branch_id = $branch_ids[0];
            }

            $seed = [
                'user_id'    => auth()->guard('api')->user()->id,
                'branch_id'  => $branch_id,
                'start_cash' => $input['cash'],
                'start_date' => date("Y-m-d H:i:s")
            ];

            DB::table('shifts')->insert($seed);
            $this->data = (new General)->get_user_profile(auth()->user()->id, $lang);
            return $this->sendResponse($this->data);
        }

        return $this->sendError('Shift Already Started', $this->data, 401);
    }

    public function end_shift($lang, Request $request)
    {
        $input = $request->all();

        if(!isset($this->data['shift']->shift_id)){
            return $this->sendResponse($this->data);
        }

        $sales = DB::table('sales_invoice_payments')
            ->join('sales_invoice_m' , 'sales_invoice_payments.sales_invoice_m_id' , '=' , 'sales_invoice_m.sales_invoice_m_id')
            ->where('sales_invoice_m.shift_id' , $this->data['shift']->shift_id )
            ->selectRaw('
                ifnull( sum(case when payment_type = 1 then amount end ), 0) as total_sales_cash ,
                ifnull( sum(case when payment_type = 2 and card_type = 1  then amount end ), 0) as total_sales_visa ,
                ifnull( sum(case when payment_type = 2 and card_type = 2  then amount end ), 0) as total_sales_master,
                ifnull( sum(case when payment_type = 2 and card_type = 3  then amount end ), 0) as total_sales_mada ,
                ifnull( sum(case when payment_type = 2 and card_type = 4  then amount end ), 0) as total_sales_other
            ')
            ->first();

        $nc = DB::table('notice_creditors_d')
            ->join('notice_creditors_m' , 'notice_creditors_d.notice_creditor_m_id' , '=' , 'notice_creditors_m.notice_creditor_m_id')
            ->where('notice_creditors_m.shift_id' , $this->data['shift']->shift_id )
            ->sum('new_total_price');

        $nd = DB::table('notice_debtors_d')
            ->join('notice_debtors_m' , 'notice_debtors_d.notice_debtor_m_id' , '=' , 'notice_debtors_m.notice_debtor_m_id')
            ->where('notice_debtors_m.shift_id' , $this->data['shift']->shift_id )
            ->sum('new_total_price');

        $ec = DB::table('payment_vouchers')
            ->where('shift_id', $this->data['shift']->shift_id )
            ->sum('amount');


        $seed = [
            'total_nc'          => $nc ,
            'total_nd'          => $nd ,
            'total_expenses'    => $ec ,
            'total_cash'        => $sales->total_sales_cash + $nd - $nc - $ec ,

            'total_sales'       => collect($sales)->sum() ,
            'total_sales_cash'  => $sales->total_sales_cash ,
            'total_sales_master'=> $sales->total_sales_master ,
            'total_sales_visa'  => $sales->total_sales_visa ,
            'total_sales_mada'  => $sales->total_sales_mada ,
            'total_sales_other' => $sales->total_sales_other ,

            'end_cash'          => $input['cash'],
            'end_master'        => $input['master'],
            'end_visa'          => $input['visa'],
            'end_mada'          => $input['mada'],
            'end_other'         => $input['other'],
            'end_date'          => date("Y-m-d H:i:s")
        ];

        $seed['diff_cash']      = $seed['end_cash'] - $seed['total_cash'] - $this->data['shift']->start_cash ;
        $seed['diff_master']    = $seed['end_master'] - $seed['total_sales_master'];
        $seed['diff_visa']      = $seed['end_visa'] - $seed['total_sales_visa'];
        $seed['diff_mada']      = $seed['end_mada'] - $seed['total_sales_mada'];
        $seed['diff_other']     = $seed['end_other'] - $seed['total_sales_other'];
        $seed['total_diff']     = $seed['diff_cash'] + $seed['diff_master'] + $seed['diff_visa'] + $seed['diff_mada'] + $seed['diff_other'] ;

        DB::table('shifts')->where('shift_id', $this->data['shift']->shift_id)->update($seed);

        $this->return = (new General)->general_data(auth()->user()->id, $lang);
        $this->return['branch_data']                = Branch::get_branch($this->data['shift']->branch_id);
        $this->return['print']['shift']             = Shift::get_shift($this->data['shift']->shift_id , $lang);
        $this->return['print']['print_title']       = '';
        $this->return['print']['print_right']       = $this->return['branch_data']->print_label_ar ?? '';
        $this->return['print']['print_left']        = $this->return['branch_data']->print_label_en ?? '';
        $this->return['print']['logo']              = $this->return['branch_data']->branch_image;


        return $this->sendResponse($this->return);
    }

    public function search_customer($lang, Request $request)
    {
        $input = $request->all();
        $this->filter = array(
            'lang'   => $lang,
            'active' => $input['active'] ?? 1,
//            'type'   => $input['type'] ?? 2,
            'word'   => $input['word'] ?? null,
            'id'   => $input['id'] ?? null,
            'is_search' => true
        );
        $this->return = Customer::all_customers($this->filter);
        return $this->sendResponse($this->return);
    }
}
