<?php

namespace App\Http\Controllers\API\V1\POS;

use App\Classes\RealTime\NotificationHelper;
use App\Http\Controllers\API\V1\BaseController;
use App\Classes\Sales\NearPayHelper;
use Illuminate\Support\Facades\DB;

class NearpayController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function get_allowed_payment_devices($lang)
    {
        $this->return['devices'] = DB::table('auth_devices')->where([
            ['user_id', auth()->user()->id],
            ['status', 1]
        ])
            ->whereNotNull('fcm_token')
            ->get()->toArray();
        return $this->sendResponse($this->return);
    }
    public function nfc_payment($lang)
    {
        $input = request()->all();

        $nearpay_helper = new NearPayHelper();
        $data = [
            'invoice_data'  => json_encode($input['invoice_data']),
            'pos_token'     => $input['pos_token'],
            'device_id'     => $input['device_id'],
        ];
        //check Device
        $check =  $nearpay_helper->checkDevice($data['device_id']);
        if (isset($input['resend'])) {
            $check = true;
        }
        if (!$check) {
            return $this->sendError(trans('error.device_not_found'));
        }
        // create payment transaction
        $this->return['customer_ref_id'] =  DB::table('invoice_temp')->InsertGetId([
            'invoice_data'      => $data['invoice_data'],
            'pos_token'         => $input['pos_token']
        ]);
        $input['customer_ref_id'] = $this->return['customer_ref_id'];
        $device_token = DB::table('auth_devices')->where('device_id', $input['device_id'])->value('fcm_token');
        //send notification
        $notification =  (new NotificationHelper('qawaem-pay'))->sendNotification($input, $device_token, 'nfc_payment');
        if (!$notification) {
            DB::table('auth_devices')->where('device_id', $input['device_id'])->delete();
            return $this->sendError(trans('error.device_not_found'));
        } else {
            DB::table('auth_devices')->where('device_id', $input['device_id'])->update(
                ['status' => 2]
            );
        }
        return $this->sendResponse($this->return);
    }
    public function nfc_payment_callback($lang)
    {
        $input = request()->all();
        $temp = DB::table('invoice_temp')->where('temp_id', $input['customer_ref_id'])->first();
        DB::table('auth_devices')->where('device_id', $input['device_id'])->update(
            ['status' => 1]
        );
        DB::beginTransaction();

        if (!isset($input['nearpay_res'])) {
            $message = [
                'message' => [
                    'arabic' => 'عملية دفع مرفوضة',
                    'english' => 'Refused Payment Request'
                ]
            ];

            $this->return = ($message);
            $this->return['notification'] = (new NotificationHelper('qawaem-pos'))->sendNotification($this->return, $temp->pos_token, 'payment_failed');
            // if(!$notification){
            //     return $this->sendError(trans('error.device_not_found'));
            // }
        } elseif ($input['nearpay_res']['is_approved']) {
            $invoice = (new SalesInvoiceController)->add_sales_invoice($lang, json_decode($temp->invoice_data, true));
            $this->return['invoice_id'] =  array($invoice)[0]->original['data'];
            $this->return['message'] = $input['nearpay_res']['status_message'];
            $this->return['notification'] = (new NotificationHelper('qawaem-pos'))->sendNotification($this->return, $temp->pos_token, 'payment_success');
            // if(!$notification){
            //     return $this->sendError(trans('error.device_not_found'));
            // }
        } else {
            return $this->sendError(trans('error.error_in_payment'));
        }
        DB::table('invoice_temp')->where('temp_id', $input['customer_ref_id'])->update([
            'nearpay_res' => json_encode($input['nearpay_res']),
            'invoice_id'  => $this->return['invoice_id'] ?? null
        ]);

        DB::commit();



        return $this->sendResponse($this->return);
    }

}
