<?php
namespace App\Http\Controllers\API\V1\Purchases;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;

use App\Classes\Purchases\PurchasesVendorHelper;

use App\Models\Finance\AccountTree;
use App\Models\Purchases\PurchasesVendor;
use App\Models\Purchases\PurchasesVendorType;
use App\Models\Finance\Tax;
use App\Models\Main\ScreenSub;


use DB;
use Illuminate\Validation\Rule;

class PurchasesVendorController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['04-002'][0]->permission)){
            return $this->sendError('view permission needed #04-002', $this->data, 200);
        }

        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? null ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('04-002', $lang)->sub_title ?? '';
        $this->return['items']       = PurchasesVendor::all_purchases_vendors($this->filter);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['04-002'][0]->permission)){
            return $this->sendError('create permission needed #04-002', [], 200);
        }

        $this->return['screen_name']            = ScreenSub::get_screen_sub_by_screen_code('04-002', $lang)->sub_title ?? '';
        $this->return['account_trees']          = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => '1'));
        $this->return['purchases_vendor_types'] = PurchasesVendorType::all_purchases_vendors_types(array('active' => 1, 'lang' => $lang));
        $this->return['taxes']                  = Tax::all_taxes(array('active' => 1, 'lang' => $lang));
        $this->return['countrys']               = DB::table('countrys')->select('country_id as id', 'name_'.$lang.' as name')->get();
        $this->return['citys']                  = DB::table('citys')->select('city_id as id', 'name_'.$lang.' as name')->get();
        $this->return['currencys']              = DB::table('currencys')->select('currency_id as id', 'name_'.$lang.' as name')->get();

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['04-002'][0]->permission)){
            return $this->sendError('create permission needed #04-002', [], 200);
        }

        $insert             = $request->only(['name_en', 'name_ar', 'address', 'purchases_vendor_type_id', 'grace_period', 'credit_limit',
                                              'warning', 'country_id', 'city_id', 'account_tree_id', 'first_term_balance', 'credit_date',
                                              'balance_nature', 'currency_id', 'is_taxable', 'tax_number' , 'tax_id']);
        $insert['add_user'] = auth()->user()->id;

        $validator = validator()->make($insert, PurchasesVendor::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        $this->return['id'] = PurchasesVendor::add_purchases_vendor($insert);

        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['04-002'][0]->permission)){
            return $this->sendError('show permission needed #04-002', [], 200);
        }

        $this->return['screen_name']            = ScreenSub::get_screen_sub_by_screen_code('04-002', $lang)->sub_title ?? '';
        $this->return['data']                   = PurchasesVendor::get_purchases_vendor($id, $lang);
        $this->return['account_trees']          = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => '1'));
        $this->return['purchases_vendor_types'] = PurchasesVendorType::all_purchases_vendors_types(array('active' => 1, 'lang' => $lang));
        $this->return['taxes']                  = Tax::all_taxes(array('active' => 1, 'lang' => $lang));
        $this->return['countrys']               = DB::table('countrys')->select('country_id as id', 'name_'.$lang.' as name')->get();
        $this->return['citys']                  = DB::table('citys')->select('city_id as id', 'name_'.$lang.' as name')->get();
        $this->return['currencys']              = DB::table('currencys')->select('currency_id as id', 'name_'.$lang.' as name')->get();

        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['04-002'][0]->permission)){
            return $this->sendError('show permission needed #04-002', [], 200);
        }

        if(!(new PurchasesVendorHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.update_fail"));
        }

        $update     = $request->only(['name_en', 'name_ar', 'address', 'purchases_vendor_type_id', 'grace_period', 'credit_limit',
                                      'warning', 'country_id', 'city_id', 'account_tree_id', 'first_term_balance', 'credit_date',
                                      'balance_nature', 'currency_id', 'is_taxable', 'tax_number' , 'tax_id']);



        $update_rule = PurchasesVendor::$rules;

        $update_rule['name_en'] = $update_rule['name_en'].',name_en,'.$id.',purchases_vendor_id';
        $update_rule['name_ar'] = $update_rule['name_ar'].',name_ar,'.$id.',purchases_vendor_id';
        $update_rule['name_en'] = [
            'required',
            'string',
            Rule::unique('purchases_vendors')->ignore($id,'purchases_vendor_id'),
        ];
        $update_rule['name_ar'] = [
            'required',
            'string',
            Rule::unique('purchases_vendors')->ignore($id,'purchases_vendor_id'),
        ];
      
        $validator  = validator()->make( $update , $update_rule );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }


      

        PurchasesVendor::update_purchases_vendor($update, $id);

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['04-002'][0]->permission)){
            return $this->sendError('delete permission needed #04-002', [], 200);
        }

        if(!(new PurchasesVendorHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.delete_fail"));
        }

        PurchasesVendor::delete_purchases_vendor($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = PurchasesVendor::find($id);

        if($item->purchases_vendor_active){
            if(!@in_array('4', $this->data['mypermissions']['04-002'][0]->permission)){
                return $this->sendError('update permission needed #04-002', [], 200);
            }

            if(!(new PurchasesVendorHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.delete_fails'), []);
            }

            PurchasesVendor::delete_purchases_vendor($id);
            $this->return['active'] = false;
        }else{
            if(!@in_array('3', $this->data['mypermissions']['04-002'][0]->permission)){
                return $this->sendError('update permission needed #04-002', [], 200);
            }

            if(!(new PurchasesVendorHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.update_fails'), []);
            }

            PurchasesVendor::update_purchases_vendor(array('purchases_vendor_active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
