<?php

namespace App\Http\Controllers\API\V1\Purchases;

use App\Classes\Purchases\SupplierStatmentReportHelper;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Inventory\Category;
use App\Models\Inventory\Item;
use App\Models\Main\Branch;
use App\Models\Main\ScreenSub;
use App\Models\Purchases\PurchasesVendor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReportController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function purchases_report_get( $lang , Request $request )
    {

        $this->checkPermission('04-008' , 'view');

        $this->return['purchases_vendors']  = PurchasesVendor::all_purchases_vendors( array('lang' => $lang , 'active' => 1 ) );
        $this->return['branchs']            = Branch::all_branchs( [ 'lang' => $lang , 'active' => 1 ]);

        return $this->sendResponse( $this->return  );

    }
    public function purchases_report_post($lang , Request $request)
    {

        $this->checkPermission('04-008' , 'view');

        $report = DB::table('purchases_invoice_m')
            ->leftjoin('purchases_invoice_d' , 'purchases_invoice_m.purchases_invoice_m_id' , 'purchases_invoice_d.purchases_invoice_m_id')
            ->leftjoin('items' , 'purchases_invoice_d.item_id' , '=' , 'items.item_id')
            ->leftjoin('branchs' , 'purchases_invoice_m.branch_id' , 'branchs.branch_id' )
            ->leftjoin('purchases_vendors' , 'purchases_invoice_m.purchases_vendor_id' , '=' , 'purchases_vendors.purchases_vendor_id')
            ->leftjoin('categorys', 'items.category_id', '=', 'categorys.category_id')
            ->where('purchases_invoice_active',1)
            ->selectRaw('
                purchases_invoice_m.purchases_invoice_m_id as p_m_id ,
                0 as r_m_id ,
                purchases_vendors.name_'.$lang.' as purchases_vendor_name ,
                branchs.name_'.$lang.' as branch_name ,
                GROUP_CONCAT(DISTINCT categorys.name_'.$lang.' ORDER BY categorys.name_'.$lang.' ASC) as category_titles ,
                categorys.name_'.$lang.' as category_title ,
                purchases_invoice_m.branch_id ,
                finance_year_id ,
                year_ser ,
                month_ser ,
                branch_ser ,
                daily_journal_m_id ,
                purchases_invoice_date as action_date ,
                "purchases" as type ,
                items.category_id ,
                count(purchases_invoice_d.purchases_invoice_d_id) as count_items ,
                sum(purchases_invoice_d.quantity) as quantity ,
                sum(purchases_invoice_d.total_vat) as total_vat ,
                sum(purchases_invoice_d.total_without_vat) as total_without_vat ,
                sum(purchases_invoice_d.total_with_vat) as total_with_vat
            ')
            ->groupBy('purchases_invoice_m.purchases_invoice_m_id');

        if(isset($request['from']) && $request['from'] > date("Y-m-d" , strtotime("2000-01-01")) ){
            $report->where('purchases_invoice_date' , '>=' , $request['from'] );
        }

        if(isset($request['to']) && $request['to'] > date("Y-m-d" , strtotime("2000-01-01"))){
            $report->where('purchases_invoice_date' , '<=' , $request['to'] );
        }

        if(isset($request['purchases_vendor_id']) && $request['purchases_vendor_id'] > 0 ){
            $report->where('purchases_invoice_m.purchases_vendor_id' , $request['purchases_vendor_id'] );
        }

        if(isset($request['is_taxable']) && $request['is_taxable'] > 0 ){
            $report->where('purchases_vendors.is_taxable' , $request['is_taxable'] );
        }

        if( $request['branch_id'] > 0  ){
            $report->where('purchases_invoice_m.branch_id' , '=' , $request['branch_id'] );
        }else{
            $report->whereIn('purchases_invoice_m.branch_id' , array_keys($this->data['branchs']) );
        }
        $purchases = $report->get()->toArray();
        $returned = DB::table('return_purchases_m')
            ->leftjoin('purchases_invoice_m' , 'purchases_invoice_m.purchases_invoice_m_id' , 'return_purchases_m.purchase_invoice_m_id' )
            ->leftjoin('return_purchases_d' , 'return_purchases_m.return_purchase_m_id' , 'return_purchases_d.return_purchase_m_id')
            ->leftjoin('purchases_invoice_d' , 'return_purchases_d.purchase_invoice_d_id' , 'purchases_invoice_d.purchases_invoice_d_id' )
            ->leftjoin('items' , 'purchases_invoice_d.item_id' , '=' , 'items.item_id')
            ->leftjoin('branchs' , 'return_purchases_m.branch_id' , 'branchs.branch_id' )
            ->leftjoin('purchases_vendors' , 'purchases_invoice_m.purchases_vendor_id' , 'purchases_vendors.purchases_vendor_id' )
            ->leftjoin('categorys' , 'items.category_id' , 'categorys.category_id' )
            ->where('active',1)
            ->selectRaw('
                return_purchases_m.return_purchase_m_id as r_m_id ,
                return_purchases_m.purchase_invoice_m_id as p_m_id ,
                purchases_vendors.name_'.$lang.' as purchases_vendor_name ,
                branchs.name_'.$lang.' as branch_name ,
                GROUP_CONCAT(DISTINCT categorys.name_'.$lang.' ORDER BY categorys.name_'.$lang.' ASC) as category_titles ,
                categorys.name_'.$lang.' as category_title ,
                return_purchases_m.branch_id ,
                return_purchases_m.finance_year_id ,
                return_purchases_m.year_ser ,
                return_purchases_m.month_ser ,
                return_purchases_m.branch_ser ,
                return_purchases_m.daily_journal_m_id ,
                return_purchases_m.action_date ,
                "return_purchases" as type ,
                items.category_id ,
                sum(return_purchases_d.returned_quantity) as quantity ,

                sum(return_purchases_d.returned_vat) as total_vat ,
                sum(return_purchases_d.returned_without_vat) as total_without_vat ,
                sum(return_purchases_d.returned_with_vat) as total_with_vat
            ')
            ->groupBy('return_purchases_m.return_purchase_m_id');

        if(isset($request['from']) && $request['from'] > date("Y-m-d" , strtotime("2000-01-01")) ){
            $returned->where('action_date' , '>=' , $request['from'] );
        }

        if(isset($request['to']) && $request['to'] > date("Y-m-d" , strtotime("2000-01-01"))){
            $returned->where('action_date' , '<=' , $request['to'] );
        }

        if(isset($request['purchases_vendor_id']) && $request['purchases_vendor_id'] > 0 ){
            $returned->where('purchases_invoice_m.purchases_vendor_id' , $request['purchases_vendor_id'] );
        }

        if(isset($request['is_taxable']) && $request['is_taxable'] > 0 ){
            $returned->where('purchases_vendors.is_taxable' , $request['is_taxable'] );
        }


        if( $request['branch_id'] > 0  ){
            $returned->where('return_purchases_m.branch_id' , '=' , $request['branch_id'] );
        }else{
            $returned->whereIn('return_purchases_m.branch_id' , array_keys($this->data['branchs']) );
        }
        $return_purchases = $returned->get()->toArray();
        $this->return['report'] = array_merge($return_purchases , $purchases);
        $this->return['report'] = collect( $this->return['report'])->sortByDesc('p_m_id')->values()->all();

        $this->return['lang']             = $lang;
        $this->return['screen_name']      = ScreenSub::get_screen_sub_by_screen_code('04-005' , $lang);
        $this->return['logo']             = get_logo($this->data['current_branch']);
        $this->return['branch_data']      = Branch::get_branch($this->data['current_branch'] );


        return $this->sendResponse( $this->return );

    }
    public function purchases_details_report_get( $lang , Request $request )
    {

        $this->checkPermission('04-009' , 'view');

        $this->return['purchases_vendors']  = PurchasesVendor::all_purchases_vendors( array('lang' => $lang , 'active' => 1 ) );
        $this->return['categorys']          = Category::all_categorys( array('lang' => $lang , 'active' => 1 ) );
        $this->return['branchs']            = Branch::all_branchs( [ 'lang' => $lang , 'active' => 1 ]);
        $this->return['items']              = Item::all_items(array('active' => 1, 'lang' => $lang , 'is_search' => 1));

        return $this->sendResponse( $this->return  );

    }
    public function purchases_details_report_post($lang , Request $request)
    {

        $this->checkPermission('04-009' , 'view');

        $report = DB::table('purchases_invoice_m')
            ->leftjoin('purchases_invoice_d' , 'purchases_invoice_m.purchases_invoice_m_id' , 'purchases_invoice_d.purchases_invoice_m_id')
            ->leftjoin('items' , 'purchases_invoice_d.item_id' , '=' , 'items.item_id')
            ->leftjoin('branchs' , 'purchases_invoice_m.branch_id' , 'branchs.branch_id' )
            ->leftjoin('purchases_vendors' , 'purchases_invoice_m.purchases_vendor_id' , '=' , 'purchases_vendors.purchases_vendor_id')
            ->leftjoin('categorys', 'items.category_id', '=', 'categorys.category_id')
            ->where('purchases_invoice_active',1)
            ->selectRaw('
                purchases_invoice_m.purchases_invoice_m_id as p_m_id ,
                0 as r_m_id ,
                purchases_vendors.name_'.$lang.' as purchases_vendor_name ,
                branchs.name_'.$lang.' as branch_name ,
                GROUP_CONCAT(DISTINCT categorys.name_'.$lang.' ORDER BY categorys.name_'.$lang.' ASC) as category_titles ,
                categorys.name_'.$lang.' as category_title ,
                purchases_invoice_m.branch_id ,
                finance_year_id ,
                year_ser ,
                month_ser ,
                branch_ser ,
                daily_journal_m_id ,
                purchases_invoice_date as action_date ,
                "purchases" as type ,
                items.category_id ,
                items.name_'.$lang.' as item_name ,
                count(purchases_invoice_d.purchases_invoice_d_id) as count_items ,
                sum(purchases_invoice_d.quantity) as quantity ,
                sum(purchases_invoice_d.total_vat) as total_vat ,
                sum(purchases_invoice_d.total_without_vat) as total_without_vat ,
                sum(purchases_invoice_d.total_with_vat) as total_with_vat
            ')
            ->groupBy('purchases_invoice_d.purchases_invoice_d_id');

        if(isset($request['from']) && $request['from'] > date("Y-m-d" , strtotime("2000-01-01")) ){
            $report->where('purchases_invoice_date' , '>=' , $request['from'] );
        }

        if(isset($request['to']) && $request['to'] > date("Y-m-d" , strtotime("2000-01-01"))){
            $report->where('purchases_invoice_date' , '<=' , $request['to'] );
        }

        if(isset($request['purchases_vendor_id']) && $request['purchases_vendor_id'] > 0 ){
            $report->where('purchases_invoice_m.purchases_vendor_id' , $request['purchases_vendor_id'] );
        }

        if(isset($request['is_taxable']) && $request['is_taxable'] > 0 ){
            $report->where('purchases_vendors.is_taxable' , $request['is_taxable'] );
        }
        if(isset($request['category_id']) && $request['category_id'] > 0 ){
            $report->where('items.category_id' , $request['category_id'] );
        }

        if(isset($request['item_id']) && $request['item_id'] > 0 ){
            $report->where('purchases_invoice_d.item_id' , $request['item_id'] );
        }
        if( $request['branch_id'] > 0  ){
            $report->where('purchases_invoice_m.branch_id' , '=' , $request['branch_id'] );
        }else{
            $report->whereIn('purchases_invoice_m.branch_id' , array_keys($this->data['branchs']) );
        }
        $purchases = $report->get()->toArray();

        $returned = DB::table('return_purchases_m')
            ->leftjoin('purchases_invoice_m' , 'purchases_invoice_m.purchases_invoice_m_id' , 'return_purchases_m.purchase_invoice_m_id' )
            ->leftjoin('return_purchases_d' , 'return_purchases_m.return_purchase_m_id' , 'return_purchases_d.return_purchase_m_id')
            ->leftjoin('purchases_invoice_d' , 'return_purchases_d.purchase_invoice_d_id' , 'purchases_invoice_d.purchases_invoice_d_id' )
            ->leftjoin('items' , 'purchases_invoice_d.item_id' , '=' , 'items.item_id')
            ->leftjoin('branchs' , 'return_purchases_m.branch_id' , 'branchs.branch_id' )
            ->leftjoin('purchases_vendors' , 'purchases_invoice_m.purchases_vendor_id' , 'purchases_vendors.purchases_vendor_id' )
            ->leftjoin('categorys' , 'items.category_id' , 'categorys.category_id' )
            ->where('active',1)
            ->selectRaw('
                return_purchases_m.return_purchase_m_id as r_m_id ,
                return_purchases_m.purchase_invoice_m_id as p_m_id ,
                purchases_vendors.name_'.$lang.' as purchases_vendor_name ,
                branchs.name_'.$lang.' as branch_name ,
                GROUP_CONCAT(DISTINCT categorys.name_'.$lang.' ORDER BY categorys.name_'.$lang.' ASC) as category_titles ,
                categorys.name_'.$lang.' as category_title ,
                return_purchases_m.branch_id ,
                return_purchases_m.finance_year_id ,
                return_purchases_m.year_ser ,
                return_purchases_m.month_ser ,
                return_purchases_m.branch_ser ,
                return_purchases_m.daily_journal_m_id ,
                return_purchases_m.action_date ,
                "return_purchases" as type ,
                items.category_id ,
                                items.name_'.$lang.' as item_name ,

                sum(return_purchases_d.returned_quantity) as quantity ,

                sum(return_purchases_d.returned_vat) as total_vat ,
                sum(return_purchases_d.returned_without_vat) as total_without_vat ,
                sum(return_purchases_d.returned_with_vat) as total_with_vat
            ')
            ->groupBy('return_purchases_d.return_purchase_d_id');

        if(isset($request['from']) && $request['from'] > date("Y-m-d" , strtotime("2000-01-01")) ){
            $returned->where('action_date' , '>=' , $request['from'] );
        }

        if(isset($request['to']) && $request['to'] > date("Y-m-d" , strtotime("2000-01-01"))){
            $returned->where('action_date' , '<=' , $request['to'] );
        }

        if(isset($request['purchases_vendor_id']) && $request['purchases_vendor_id'] > 0 ){
            $returned->where('purchases_invoice_m.purchases_vendor_id' , $request['purchases_vendor_id'] );
        }

        if(isset($request['is_taxable']) && $request['is_taxable'] > 0 ){
            $returned->where('purchases_vendors.is_taxable' , $request['is_taxable'] );
        }
        if(isset($request['category_id']) && $request['category_id'] > 0 ){
            $returned->where('items.category_id' , $request['category_id'] );
        }

        if(isset($request['item_id']) && $request['item_id'] > 0 ){
            $returned->where('purchases_invoice_d.item_id' , $request['item_id'] );
        }

        if( $request['branch_id'] > 0  ){
            $returned->where('return_purchases_m.branch_id' , '=' , $request['branch_id'] );
        }else{
            $returned->whereIn('return_purchases_m.branch_id' , array_keys($this->data['branchs']) );
        }
        $return_purchases = $returned->get()->toArray();
        $this->return['report'] = array_merge($return_purchases , $purchases);
        $this->return['report'] = collect( $this->return['report'])->sortByDesc('p_m_id')->values()->all();

        $this->return['lang']             = $lang;
        $this->return['screen_name']      = ScreenSub::get_screen_sub_by_screen_code('04-005' , $lang);
        $this->return['logo']             = get_logo($this->data['current_branch']);
        $this->return['branch_data']      = Branch::get_branch($this->data['current_branch'] );


        return $this->sendResponse( $this->return );

    }

    public function supplier_balances_report_post($lang, Request $request)
    {
        $this->checkPermission('04-007', 'view');
        app()->setLocale($lang);
        $this->return['from']                = $request['from_date'] ?? date("Y-m-01");
        $this->return['to']                  = $request['to_date'] ?? date("Y-m-t");
        $this->return['branch_id']           = $request['branch_id'] ?? null;
        $this->return['report']     = [];
        $suppliers = PurchasesVendor::all_purchases_vendors(['active' => 1, 'lang' => $lang, 'branch_id' => $this->return['branch_id']]);
        
        foreach ($suppliers as $key => $value) {

            $first   = SupplierStatmentReportHelper::get_statment($value->id, $lang, array('total' => true, 'before' => $this->return['from']));
            $all     = SupplierStatmentReportHelper::get_statment($value->id, $lang, array('total' => true, 'from' => $this->return['from'], 'to' => $this->return['to']));
           
            $this->return['report'][] = [
                'id'            => $value->id,
                'name'          => $value->name,
                'first'         => $first->total_amount,
                'debit'         => $all->debit_amount,
                'credit'        => $all->credit_amount,
            ];
        }

        return $this->sendResponse($this->return);
    }
}
