<?php
namespace App\Http\Controllers\API\V1\Purchases;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;

use App\Classes\ItemStock;
use App\Classes\Purchases\ReturnPurchasesHelper;

use App\Models\Main\ScreenSub;
use App\Models\Main\Setting;

use App\Models\Purchases\ReturnPurchases;

use App\Models\Finance\DailyJournal;
use App\Models\Purchases\PurchasesInvoice;
use Illuminate\Support\Facades\DB;


class ReturnPurchasesController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        $this->checkPermission('04-007','view');

        $this->filter = array(
            'lang'         => $lang ,
            'active'       => $request['active'] ?? 1 ,
            'rows'         => $request['rows'] ?? 20 ,
            'page'         => $request['page'] ?? 1 ,
            'word'         => $request['word'] ?? null ,
            'branch'       => $this->data['current_branch'] ,
            'finance_year' => $this->data['current_year']
        );

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('04-007', $lang)->sub_title ?? '';
        $this->return['items'] = ReturnPurchases::all_return_purchases($this->filter);


        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        $this->checkPermission('04-007','add');

        $this->return['screen_name']             = ScreenSub::get_screen_sub_by_screen_code('04-007' , $lang)->sub_title ?? '';
        $this->return['master']                  = PurchasesInvoice::get_purchases_invoice_m($request['id'], $lang);
        $this->return['details']                 = PurchasesInvoice::get_purchases_invoice_d($request['id'], $lang);

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        $this->checkPermission('04-007','add');
        app()->setLocale($lang);
        $insert = $request->all();

        $year   = array_search(date("Y", strtotime($insert['action_date'])), $this->data['years']);

        if($year == ''){
            return $this->sendError(trans("error.finance_year_not_aval"));
        }

        $codes = (new ReturnPurchasesHelper)->get_next_codes($insert['action_date'], $year, $this->data['current_branch']);
        $master  =  DB::table('purchases_invoice_m')->where('purchases_invoice_m_id',$insert['purchase_invoice_m_id'])->first();

        $master_seed =[
            'purchase_invoice_m_id'         => $insert['purchase_invoice_m_id'],
            'branch_id'                     => $this->data['current_branch'],
            'finance_year_id'               => $year,
            'year_ser'                      => $codes['year_ser'],
            'month_ser'                     => $codes['month_ser'],
            'branch_ser'                    => $codes['branch_ser'],
            'daily_journal_m_id'            => 0,
            'action_date'                   => $insert['action_date'],
            'description'                   => $insert['description'],
            'add_user'                      => auth()->user()->id
        ];

        $validator = validator()->make($master_seed, ReturnPurchases::$master_rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();

        $m_id = ReturnPurchases::add_return_purchase_m($master_seed);
        $source = ItemStock::Sales_source;

        if (isset($insert['items']) && is_array($insert['items'])){
            foreach ($insert['items'] as $item){
                $detail = DB::table('purchases_invoice_d')->where('purchases_invoice_d_id',$item['d_id'])->first();
                $price_without_vat =($detail->total_without_vat / $detail->quantity) + ($detail->total_discount / $detail->quantity);
                
                $details_seed = array(
                    'return_purchase_m_id'   => $m_id,
                    'purchase_invoice_d_id'  => $item['d_id'],
                    'warehouse_id'           => $detail->warehouse_id ?? 0,
                    'item_id'                => $detail->item_id,
                    'returned_quantity'      => $item['returned_quantity'] ?? 0,
                    'returned_price'         => $price_without_vat ,
                    'returned_vat'           => ($detail->current_total_vat / $detail->current_quantity) * $item['returned_quantity'] ,
                    'returned_without_vat'   => $price_without_vat * $item['returned_quantity'] ,
                    'returned_with_vat'      => ($price_without_vat * $item['returned_quantity']) + (($detail->current_total_vat / $detail->current_quantity) * $item['returned_quantity']),
                    'remaining_quantity'     => $detail->current_quantity - $item['returned_quantity'] ,
                    'remaining_price'        => $detail->current_total_price - ($price_without_vat * $item['returned_quantity']) ,
                );
                
                $validator = validator()->make($details_seed, ReturnPurchases::$details_rules);

                if($validator->fails())
                {
                    return $this->sendError(trans('error.add_fails'), $validator->errors());
                }

                if($details_seed['returned_quantity'] > $detail->current_quantity){
                    return $this->sendError(trans('error.remaining_quantity_error'));
                }
                $d_id = ReturnPurchases::add_return_purchase_d($details_seed);
                // update purchase detail
                DB::table('purchases_invoice_d')->where('purchases_invoice_d_id',$item['d_id'])->update(array(
                    'current_price'                 => $price_without_vat - $details_seed['returned_price'],
                    'current_total_price'           => $detail->current_total_price - $details_seed['returned_without_vat'],
                    'current_total_vat'             => $detail->current_total_vat - $details_seed['returned_vat'],
                    'current_total_with_vat'        => $detail->current_total_with_vat - $details_seed['returned_with_vat'],
                    'current_total_without_vat'     => $detail->current_total_without_vat - $details_seed['returned_without_vat'],
                    'current_quantity'              => $detail->current_quantity - $details_seed['returned_quantity'],
                ));
                $warehouse_id = $detail->warehouse_id;
                $source = ItemStock::Return_Purchases_source; // + stock
                $qty = $item['returned_quantity'];
                (new ItemStock)->update_item_stock($this->data['current_branch'], $detail->item_id, $warehouse_id, $source, $m_id, $d_id, $qty, 0 , $detail->unit_id,$detail->unit_type, 0);
            }

        }

            //update purchase invoice master
            $all_details = DB::table('return_purchases_d')->where('return_purchase_m_id',$m_id)->get();

            DB::table('purchases_invoice_m')->where('purchases_invoice_m_id',$insert['purchase_invoice_m_id'])->update(array(
                'current_total_vat'             => $master->current_total_vat         - collect($all_details)->sum('returned_vat'),
                'current_total_with_vat'        => $master->current_total_with_vat    - collect($all_details)->sum('returned_with_vat'),
                'current_total_without_vat'     => $master->current_total_without_vat - collect($all_details)->sum('returned_without_vat'),
            ));
            DB::table('return_purchases_m')->where('return_purchase_m_id',$m_id)->update(array(
                'returned_price'    => collect($all_details)->sum('returned_with_vat'),
                'returned_quantity' =>  collect($all_details)->sum('returned_quantity'),
            ));
           (new ReturnPurchasesHelper)->generate_daily_journal($m_id);
            // if(!$daily_journal[0]){
            //     DB::rollback();
            //     return response()->json( array('check' => 0 , 'data' => $daily_journal[3] ?? [] , 'msg' => 'Error in createing journal code '.$daily_journal[1] ) );
            // }
            // DB::table('return_purchases_m')
            //     ->where('return_purchase_m_id' , $m_id)
            //     ->update( ['daily_journal_m_id' => $daily_journal[2]] );

        DB::commit();
        return $this->sendResponse($m_id, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        $this->checkPermission('04-007','view');

        $this->return['screen_name']             = ScreenSub::get_screen_sub_by_screen_code('04-007', $lang)->sub_title ?? '';
        $this->return['master']                  = ReturnPurchases::get_return_purchase_m($id, $lang);
        $this->return['details']                 = ReturnPurchases::get_return_purchases_d($id, $lang);

        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function update($lang, $id, Request $request)
    {
        $this->checkPermission('04-007','edit');


        $update = $request->only(['purchases_invoice_date', 'purchases_invoice_type_id', 'purchases_invoice_detail', 'purchases_vendor_id', 'purchases_agent_id', 'purchases_vendor_invoice_no', 'currency_id', 'purchases_invoice_description']);

        $m_id = $id ;

        DB::beginTransaction();

            ReturnPurchases::update_purchases_invoice_m($update, $id);
            $old        = ReturnPurchases::get_purchases_invoice_d($id , $lang);
            $new_ids    = collect($request['items'])->pluck('d_id')->toArray();
            $source = ItemStock::Return_Purchases_source; // + stock

            foreach ($old as $row){
                if( !in_array( $row->d_id , $new_ids ) ){
                    ReturnPurchases::delete_purchases_invoice_d($row->d_id );
                    (new ItemStock)->update_item_stock($this->data['current_branch'], $row->item_id, $row->warehouse_id, $source, $m_id, $row->d_id, ( $row->quantity * -1 ) , 0 , $row->unit_id, $row->unit_type ?? 0 , 0);
                }
            }

            foreach ($request['items'] as $item){


                $tax_percentage = DB::table('taxes')->where('tax_id', $item['tax_percent_id'])->value('tax_percentage');
                if (isset($item['unit_id']) && !is_null($item['unit_id'])){
                    $selectedItem = DB::table('items')->where('item_id', $item['item_id'])->first();
                    if ($item['unit_id'] == $selectedItem->big_unit_id){
                        $item['unit_type'] = 3;
                    }elseif ($item['unit_id'] == $selectedItem->mid_unit_id){
                        $item['unit_type'] = 2;
                    }elseif ($item['unit_id'] == $selectedItem->small_unit_id){
                        $item['unit_type'] = 1;
                    }
                }

                $details_seed = array(
                    'purchases_invoice_m_id' => $m_id,
                    'warehouse_id'           => $item['warehouse_id'],
                    'item_id'                => $item['item_id'],
                    'unit_id'                => $item['unit_id'],
                    'unit_type'              => $item['unit_type'] ?? 0,
                    'quantity'               => $item['quantity'] ?? 0,
                    'price'                  => $item['price'] ?? 0,
                    'total_price'            => $item['total_price_without_vat'] ?? 0 ,
                    'tax_percent_id'         => $item['tax_percent_id'] ?? 0,
                    'total_vat'              => $item['total_vat'] ,
                    'total_without_vat'      => $item['total_without_vat'] ,
                    'total_with_vat'         => $item['total_with_vat'] ,
                    'add_user'               => auth()->user()->id
                );

                $is_taxable = DB::table('purchases_vendors')
                    ->where('purchases_vendor_id',$update['purchases_vendor_id'])
                    ->value('is_taxable');
                    if($is_taxable == 0){
                        $details_seed['total_vat'] = 0;
                        $details_seed['total_with_vat'] = ($item['price'] * $item['quantity']);
                    }
                $validator = validator()->make($details_seed, ReturnPurchases::$details_rules);

                if($validator->fails())
                {
                    return $this->sendError(trans('error.add_fails'), $validator->errors());
                }



                if(!isset($item['d_id']) || $item['d_id'] == 0 ){
                    $d_id = ReturnPurchases::add_purchases_invoice_d($details_seed);
                    (new ItemStock)->update_item_stock($this->data['current_branch'], $item['item_id'], $item['warehouse_id'], $source, $m_id, $d_id, $item['quantity'], 0 , $item['unit_id'],$item['unit_type'], 0);

                }else{
                    unset($details_seed['add_user']);
                    ReturnPurchases::update_purchases_invoice_d($details_seed , $item['d_id'] );

                }

            }

            (new ReturnPurchasesHelper)->generate_daily_journal($m_id);

        DB::commit();



        return $this->sendResponse($id, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        $this->checkPermission('04-007','delete');


        $master = ReturnPurchases::get_return_purchase_m($id);

        if(!isset($master->purchases_invoice_m_id) || $master->branch_id != $this->data['current_branch'] || !(new ReturnPurchasesHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.delete_fail"));
        }

        DB::beginTransaction();
            ReturnPurchases::delete_return_purchase_m($id);
            (new ReturnPurchasesHelper)->generate_daily_journal($id);
        DB::commit();


        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = ReturnPurchases::find($id);

        if($item->active){
            $this->checkPermission('04-007','delete');


            if(!(new ReturnPurchasesHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.delete_fails'), []);
            }



            DB::beginTransaction();
                ReturnPurchases::delete_return_purchase_m($id);
                (new ReturnPurchasesHelper)->generate_daily_journal($id);
            DB::commit();


            $this->return['active'] = false;
        }else{
            $this->checkPermission('04-007','edit');


            if(!(new ReturnPurchasesHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.update_fails'), []);
            }

            DB::beginTransaction();
                ReturnPurchases::update_return_purchase_m(array('active' => 1), $id);
                (new ReturnPurchasesHelper)->generate_daily_journal($id);

            DB::commit();



            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }


}
