<?php

namespace App\Http\Controllers\API\V1\Sales;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Sales\Shift;
use Illuminate\Http\Request;
use App\Models\Main\ScreenSub;

use App\Models\User;
use App\Models\Main\Branch;

class ShiftController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-020'][0]->permission ?? [] )){
            return $this->sendError('view permission needed #06-020', $this->data, 200);
        }

        $this->filter = array(
            'lang'   => $lang ,
            'from'   => $request['from'] ?? null ,
            'to'     => $request['to'] ?? null ,
            'user'   => $request['user_id'] ?? null ,
            'branch' => $request['branch_id'] ?? null ,
            'from'   => $request['from_date'] ?? null ,
            'to'     => $request['to_date'] ?? null ,
            'rows'   => $request['rows'] ?? null ,
            'page'   => $request['page'] ?? 1 ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-020', $lang)->sub_title ?? '';
        $this->return['items']       = Shift::all_shifts($this->filter);
        $this->return['users']       = User::all_users( array('lang' => $lang , 'active' => 1 ));
        $this->return['branchs']     = Branch::all_branchs( array('lang' => $lang , 'active' => 1 , 'user' => auth()->user()->id ));

        return $this->sendResponse($this->return);
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-020'][0]->permission ?? [] )){
            return $this->sendError('show permission needed #06-020', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-020', $lang)->sub_title ?? '';
        $this->return['data']        = Shift::get_shift($id, $lang);

        $this->return['branch_data']                = Branch::get_branch($this->return['data']->branch_id);
        $this->return['print']['print_title']       = '';
        $this->return['print']['print_right']       = $this->return['branch_data']->print_label_ar ?? '';
        $this->return['print']['print_left']        = $this->return['branch_data']->print_label_en ?? '';
        $this->return['print']['logo']              = $this->return['branch_data']->branch_image;

        
        return $this->sendResponse($this->return);
    }

}
