<?php

namespace App\Http\Controllers\API\Website\Frontend\Booking;

use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;
use App\Classes\General\SMS;
use App\Classes\RealTime\NotificationHelper;
use App\Http\Controllers\API\Website\Frontend\GeneralController;
use App\Models\Main\Branch;
use App\Models\Main\Setting;
use App\Models\POS\BarberBooking as Booking;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Factory;

use function Laravel\Prompts\select;

class BookingsController extends BaseController
{
    protected $return = array();
    protected $filter = array();
    protected $days   = ["Mon" => "الاثنين", "Tue" => "الثلاثاء", "Wed" => "الاربعاء", "Thu" => "الخميس", "Fri" => "الجمعه", "Sat" => "السبت", "Sun" => "الاحد"];
    protected $time   = ['PM' => 'مساء', 'AM' => 'صباحا'];

    public function create_booking($lang, Request $request)
    {
        $this->return['categorys']  = DB::table('categorys')
            ->where('category_active', 1)
            ->where('category_type', 0)
            ->selectRaw('category_id as id ,service_type ,name_' . $lang . ' as name')->get();

        $this->return['services']  = DB::table('items')
            ->leftjoin('taxes', 'items.tax_id', '=', 'taxes.tax_id')
            ->leftjoin('categorys', 'items.category_id', '=', 'categorys.category_id')
            ->where('item_active', 1)
            ->where('pos_item', 1)
            ->selectRaw('
                item_id as id ,
                items.name_' . $lang . ' as name ,
                image ,
                description ,
                items.category_id ,
                categorys.service_type ,
                taxes.tax_percentage as tax_percent ,
                time_blocks ,
                if(price_include_vat = 1 , sale_price , sale_price * ( 1 + ( taxes.tax_percentage / 100 ) )  ) as price_with_vat ,
                if(price_include_vat = 1 , (sale_price - (sale_price / ( 1 + ( taxes.tax_percentage / 100 ) ) ) ) , ( sale_price * ( taxes.tax_percentage / 100 ) )  ) as price_vat ,
                if(price_include_vat = 1 , (sale_price / ( 1 + ( taxes.tax_percentage / 100 ) ) ) , sale_price ) as price_without_vat,
                item_active as service_active
            ')->get();

        $this->return['branchs']   = Branch::all_branchs(array('active' => 1, 'lang' => $lang));
        $this->return['barbers']   = DB::table('barber_m')
            ->where('barber_active', 1)
            ->selectRaw('barber_m_id as id , name_' . $lang . ' as name ,categories, image , now() as first_aval_date')
            ->get();

        $this->return['points_settings'] = DB::table('settings')
            ->whereIn('setting_code', ['amount_sar_invoice', 'points_count_sar_usage', 'invoices_needed_for_gift', 'gift_points_count', 'min_amount_invoice',])
            ->pluck('value', 'setting_code');

        return $this->sendResponse($this->return);
    }



    public function make_booking($lang, Request $request)
    {
        try {
            app()->setLocale($lang);
            $insert = $request->only('services', 'branch_id', 'booking_date', 'start_time', 'coupon_code', 'barber_id', 'points', 'notes');
            $times = collect((new GeneralController)->get_available_times($insert['booking_date'], $insert['barber_id'], $insert['services'], $lang))->pluck('time_id')->toArray();

            // check if request come from Front End
            $customer = auth('customer')->user();
            $customer_id = $customer->customer_id;
            $customer_mobile = $customer->phone;



            $validator = validator()->make($insert, Booking::$rules);

            if ($validator->fails()) {
                return $this->sendError(trans('error.Error In Validation'), $validator->errors());
            }



          $services = DB::table('items')
              ->leftjoin('taxes', 'items.tax_id', '=', 'taxes.tax_id')
              ->leftJoin('categorys', 'items.category_id', '=', 'categorys.category_id')
              ->whereIn('item_id', $insert['services'])
              ->selectRaw('

                  item_id as id ,
                  items.name_' . $lang . ' as name ,
                  image ,
                  description ,
                  categorys.category_id ,
                  categorys.service_type ,
                  taxes.tax_percentage as tax_percent ,
                  time_blocks ,
                  if(price_include_vat = 1 , sale_price , sale_price * ( 1 + ( taxes.tax_percentage / 100 ) )  ) as price_with_vat ,
                  if(price_include_vat = 1 , (sale_price - (sale_price / ( 1 + ( taxes.tax_percentage / 100 ) ) ) ) , ( sale_price * ( taxes.tax_percentage / 100 ) )  ) as price_vat ,
                  if(price_include_vat = 1 , (sale_price / ( 1 + ( taxes.tax_percentage / 100 ) ) ) , sale_price ) as price_without_vat,
                  item_active as service_active
              ')->get();


            $insert['total_with_vat']    = collect($services)->sum('price_with_vat');
            $insert['total_without_vat'] = collect($services)->sum('price_without_vat');
            $insert['total_vat']         = collect($services)->sum('price_vat');
            $insert['needed_blocks']     = collect($services)->sum('time_blocks');

        $total_with_vat     = collect($services)->sum('price_with_vat');
        $total_without_vat  = collect($services)->sum('price_without_vat');
        $total_vat          = collect($services)->sum('price_vat');
        $needed_blocks      = collect($services)->sum('time_blocks');
        $service_types = collect($services)->pluck('service_type')->unique();
        
        // check if all services are from same type
        if($service_types->count() > 1){
            return $this->sendError(trans('error.you_cant_choise_services_from_different_types'));
        }



            if ($insert['needed_blocks'] < 1) {
                return $this->sendError(trans('error.Error In Time'), [$services]);
            }

            $needed_blocks      = ceil($insert['needed_blocks'] / 5);

            $time_blocks_ids    = DB::table('b_times')
                ->where('time_id', '>=', $insert['start_time'])
                ->take($needed_blocks + 1)
                ->pluck('time_id')
                ->toArray();

            $insert['end_time']        = end($time_blocks_ids);

            if (count($time_blocks_ids) > 1) {
                unset($time_blocks_ids[count($time_blocks_ids) - 1]);
            }

            if ($time_blocks_ids[0] != 185) {
                foreach ($time_blocks_ids as $t) {
                    if (!in_array($t, $times)) {
                        return $this->sendError(trans('error.Error In Time'), $times);
                    }
                }
            }

            $insert['services']        = (is_array($insert['services'] ?? '')) ? implode(',', $insert['services']) : $insert['services'];
            $insert['time_blocks_ids'] = implode(',', $time_blocks_ids);

            $branch_id   = Branch::get_branch($insert['branch_id'], $lang)->id;
            $services_ids = $request['services'];


            // check if customer has another booking in same day
            $counter = DB::table('barber_bookings')
                ->where('barber_booking_date', $insert['booking_date'])
                ->where('barber_customer_id', $customer_id)
                ->where('barber_booking_active', 1)
                ->count();

            if ($counter > 1) {
                return $this->sendError(trans('error.customer_has_booking'), []);
            }

            //check if Coupon and Points provided
            if ($request->filled('coupon_code') && $request->filled('points')) {
                return $this->sendError(trans('error.Coupon and Points can not be used together'), []);
            }

            // check if coupon is provided
            if ($request->filled('coupon_code')) {

                $coupon = DB::table('coupons')
                    ->where('coupon_code', $request['coupon_code'])
                    ->whereRaw("FIND_IN_SET(1,platforms_id)")
                    ->where('start_date', '<=',  date("Y-m-d"))
                    ->where('end_date', '>=',  date("Y-m-d"))
                    ->first();

                // Check if coupon exists
                if (!$coupon) {
                    return $this->sendError(trans('error.Coupon Not Found'));
                }

                // Check if coupon is valid for customer
                $counter = DB::table('barber_bookings')
                    ->where('barber_bookings.barber_customer_id', $customer_id)
                    ->where('coupon_code', $request['coupon_code'])
                    ->count();

                if ($counter >= $coupon->allowed_count) {
                    return $this->sendError(trans('error.Coupon used before'));
                }

                // If Isset Coupon Get Coupon Discount Value and Calc Total Without Vat
                if ($coupon->coupon_type == 1) {
                    $insert['coupon_discount'] = $coupon->discount;
                } else {
                    $discount_per = ($coupon->discount / 100);
                    $insert['coupon_discount'] = ($insert['total_without_vat'] * $discount_per);
                }
            }

            // check if points provided
            if ($request->filled('points')) {

                // check if minimum amount invoice is valid to use points
                $min_amount_invoice = Setting::get_main_setting_by_code('min_amount_invoice')->value ?? 0;
                if ($insert['total_without_vat'] < $min_amount_invoice) {
                    return $this->sendError(trans('error.minimum amount invoice to use points is') . $min_amount_invoice, []);
                }

                // check if customer has enough points to use
                $customer_points = DB::table('customers')->where('customer_id', $customer_id)->first()->wallet_points ?? 0;
                if ($request->points > $customer_points) {
                    return $this->sendError(trans('error.You do not have enough points to use'), []);
                }

                // check min points 
                if ($request->points < 10) {
                    return $this->sendError(trans('error.minimum points to use is') . 10, []);
                }

                // check max points
                if ($request->points > 100) {
                    return $this->sendError(trans('error.maximum points to use is') . 100, []);
                }

                // check if points is multible of 5
                if ($request->points % 5 !== 0) {
                    return $this->sendError(trans('error.points must be multiple of 5'), []);
                }

                // 1- get how many points equal to 1 SAR
                $points_count_sar_usage = Setting::get_main_setting_by_code('points_count_sar_usage')->value ?? 0;

                if ($points_count_sar_usage == 0) {
                    return $this->sendError('error.points_count_sar_usage can not be 0.', []);
                }

                // 2- calculate points discount
                $insert['points_discount'] = $request->points /  $points_count_sar_usage;
            }

            // Ensure defaults if discounts coupon or points not set
            $insert['coupon_discount'] = $insert['coupon_discount'] ?? 0;
            $insert['points_discount'] = $insert['points_discount'] ?? 0;

            // توزيع الخصم على مستوى الخدمات
            $discount_total = $insert['coupon_discount'] + $insert['points_discount'];
            $new_total_vat = 0;
            $new_total_with_vat = 0;
            $insert['total_after_discounts'] = $insert['total_without_vat'] - $discount_total;

            if ($discount_total > 0 && $insert['total_without_vat'] > 0) {
                foreach ($services as $service) {
                    // نسبة الخدمة من الإجمالي
                    $service_share = $service->price_without_vat / $insert['total_without_vat'];

                    // الخصم الخاص بالخدمة
                    $service_discount = $discount_total * $service_share;
                    // السعر الجديد بدون الضريبة بعد الخصم
                    $new_price_without_vat = $service->price_without_vat - $service_discount;

                    // الضريبة الجديدة = السعر بعد الخصم × نسبة الضريبة
                    $new_vat = $new_price_without_vat * ($service->tax_percent / 100);

                    $new_total_vat += $new_vat;
                    $new_total_with_vat += $new_price_without_vat + $new_vat;
                }

                $insert['total_vat'] = $new_total_vat;
                $insert['total_price'] = $new_total_with_vat;
            } else {
                // في حالة مفيش خصم خالص
                $insert['total_price'] = $insert['total_after_discounts'] + $insert['total_vat'];
            }
            $insert['total_price'] = $insert['total_after_discounts'] + $insert['total_vat'];


            //------------------- gain new points based on total without vat before discounts  -----------------------------
            // 1- get how much SAR equals 1 point
            $amount_sar_invoice = Setting::get_main_setting_by_code('amount_sar_invoice')->value ?? 0;

            // 2- Calculate new points based on total_without_vat
            $insert['new_points'] = (int) round(($insert['total_without_vat']) / $amount_sar_invoice);
            $insert['service_id']         = implode(',', $services_ids);

            $erp_id = DB::table('barber_bookings')->insertGetId([
                'barber_id'                => $insert['barber_id'],
                'barber_customer_id'       => $customer_id,
                'services'                 => $insert['service_id'],
                'time_blocks_ids'          => $insert['time_blocks_ids'],
                'needed_blocks'            => $needed_blocks,
                'branch_id'                => $branch_id,
                'barber_booking_date'      => $insert['booking_date'],
                'start_time'               => $insert['start_time'],
                'end_time'                 => $insert['end_time'],
                'coupon_code'              => $insert['coupon_code'] ?? 0,
                'coupon_discount'          => $insert['coupon_discount'] ?? 0, // خصم الكوبون
                'points_discount'          => $insert['points_discount'] ?? 0, // خصم البوينت
                'total_price'              => $insert['total_price'], // السعر ش ض والخصم
                'total_vat'                => $insert['total_vat'], // الضريبة
                'total_without_vat'        => $insert['total_without_vat'], // السعر قبل الضريبة
                'total_with_vat'           => $insert['total_with_vat'], // السعر شامل الضريبة
                'add_user'                 => $customer_id,
                'new_points'               => $insert['new_points'] ?? 0,
                'used_points'              => $insert['points'] ?? 0,
            ]);
            // update notes for the customer
            DB::table('customers')->where('customer_id', $customer_id)->update(['notes' => $insert['notes'] ?? null]);

            // send notification to the customer
            $this->return['erp_data'] = DB::table('barber_bookings')->where('barber_booking_id', $erp_id)->first();
            $barber_name = DB::table('barber_m')->where('barber_m_id', $insert['barber_id'])->first()->name_ar ?? '';
            $time_title = DB::table('b_times')->where('time_id', $insert['start_time'])->first()->time_title ?? '';
            $day_title  = $this->days[date("D", strtotime($insert['booking_date']))];
            $message = "ضيفنا العزيز نود تأكيد موعدكم  يوم " . $day_title . " الموافق " . $insert['booking_date'] . " الساعه " . date("h:i", strtotime($time_title)) . " " . $this->time[date("A", strtotime($time_title))] . " مع " . $barber_name . " في فرع الرياض https://maps.app.goo.gl/wJ4RvLjnFdHCFbV3A?g_st=iw";
            $this->return['content'] = (new SMS)->send("966" . $customer_mobile, $message);
            DB::table('notifications')->insertGetId(array(
                'title'         => 'New Booking',
                'description'   => $message,
                'date'          => date('Y-m-d H:i')
            ));

            return $this->sendResponse($this->return, $message);
        } catch (\Throwable $e) {
            return $this->sendError($e->getMessage(), []);
        }
    }

    public function claim_gift(Request $request)
    {
        try {
            $invoices_needed_for_gift = Setting::get_main_setting_by_code('invoices_needed_for_gift')->value ?? 0;


            $gift_points_count = Setting::get_main_setting_by_code('gift_points_count')->value ?? 0;

            //get invoices needed for gift
            $invoices_needed_for_gift = Setting::get_main_setting_by_code('invoices_needed_for_gift')->value ?? 0;

            // get total invoices for customer
            $gift_total_invoices = DB::table('customers')->where('customer_id', auth('customer')->user()->customer_id)->first()->gift_total_invoices ?? 0;

            // check if customer has enough invoices
            if ($gift_total_invoices < $invoices_needed_for_gift) {
                return $this->sendError(trans('error.To get the gift the minimum invoices must be') . $invoices_needed_for_gift, []);
            }

            // increment wallet points for customer
            DB::table('customers')->where('customer_id', auth('customer')->user()->customer_id)->increment('wallet_points', $gift_points_count);

            // reset gift total invoices for customer
            DB::table('customers')->where('customer_id', auth('customer')->user()->customer_id)->update(['gift_total_invoices' => 0]);

            // store data in return 
            $this->return['gift_points_count'] = $gift_points_count;

            return $this->sendResponse($this->return, trans('main.operation completed successfully'));
        } catch (\Throwable $e) {
            return $this->sendError($e->getMessage(), []);
        }
    }

    public function get_customer_wallet_points()
    {
        // get wallet points
        $wallet_points = DB::table('customers')->where('customer_id', auth('customer')->user()->customer_id)->first()->wallet_points ?? 0;

        // get total invoices for customer
        $gift_total_invoices = DB::table('customers')->where('customer_id', auth('customer')->user()->customer_id)->first()->gift_total_invoices ?? 0;

        // get how many invoices needed to got a gift
        $invoices_needed_for_gift = Setting::get_main_setting_by_code('invoices_needed_for_gift')->value ?? 0;

        return $this->sendResponse($this->return, [
            'wallet_points' => $wallet_points,
            'gift_total_invoices' => $gift_total_invoices,
            'invoices_needed_for_gift' => $invoices_needed_for_gift
        ]);
    }

    public function update_booking($lang, Request $request, $booking_id)
    {
        try {
            app()->setLocale($lang);
            $insert = $request->only('services', 'branch_id', 'booking_date', 'start_time', 'coupon_code', 'barber_id', 'points', 'customer_mobile', 'notes');

            // check if booking exists
            $booking = DB::table('barber_bookings')->where('barber_booking_id', $booking_id)->first();
            if (!$booking) {
                return $this->sendError(trans('error.Booking id Not Found'), []);
            }

            // check if request come from Front End
            $customer = auth('customer')->user();
            $customer_id = $customer->customer_id;


//             // Available times
//             $times = collect((new GeneralController)->get_available_times($insert['booking_date'], $insert['barber_id'], $insert['services'], $lang))
//                 ->pluck('time_id')->toArray();

//             $validator = validator()->make($insert, Booking::$rules);
//             if ($validator->fails()) {
//                 return $this->sendError(trans('error.Error In Validation'), $validator->errors());
//             }

//             // Services + pricing
//             $services = DB::table('items')
//                 ->leftjoin('taxes', 'items.tax_id', '=', 'taxes.tax_id')
//                 ->whereIn('item_id', $insert['services'])
//                 ->selectRaw('
//                 item_id as id,
//                 items.name_' . $lang . ' as name,
//                 image,
//                 description,
//                 category_id,
//                 taxes.tax_percentage as tax_percent,
//                 time_blocks,
//                 if(price_include_vat = 1, sale_price, sale_price * (1 + (taxes.tax_percentage / 100))) as price_with_vat,
//                 if(price_include_vat = 1, (sale_price - (sale_price / (1 + (taxes.tax_percentage / 100)))), (sale_price * (taxes.tax_percentage / 100))) as price_vat,
//                 if(price_include_vat = 1, (sale_price / (1 + (taxes.tax_percentage / 100))), sale_price) as price_without_vat,
//                 item_active as service_active
//             ')->get();

//             $insert['total_with_vat']    = collect($services)->sum('price_with_vat');
//             $insert['total_without_vat'] = collect($services)->sum('price_without_vat');
//             $insert['total_vat']         = collect($services)->sum('price_vat');
//             $insert['needed_blocks']     = collect($services)->sum('time_blocks');

//             if ($insert['needed_blocks'] < 1) {
//                 return $this->sendError(trans('error.Error In Time'), [$services]);
//             }

        $services = DB::table('items')
            ->leftjoin('taxes', 'items.tax_id', '=', 'taxes.tax_id')
            ->leftJoin('categorys', 'items.category_id', '=', 'categorys.category_id')
            ->whereIn('item_id', $update['services'])
            ->selectRaw('
                item_id as id ,
                items.name_'.$lang.' as name ,
                image ,
                description ,
                categorys.category_id ,
                categorys.service_type ,
                taxes.tax_percentage as tax_percent ,
                time_blocks ,
                if(price_include_vat = 1 , sale_price , sale_price * ( 1 + ( taxes.tax_percentage / 100 ) )  ) as price_with_vat ,
                if(price_include_vat = 1 , (sale_price - (sale_price / ( 1 + ( taxes.tax_percentage / 100 ) ) ) ) , ( sale_price * ( taxes.tax_percentage / 100 ) )  ) as price_vat ,
                if(price_include_vat = 1 , (sale_price / ( 1 + ( taxes.tax_percentage / 100 ) ) ) , sale_price ) as price_without_vat,
                item_active as service_active
            ')->get();

//         $total_with_vat     = collect($services)->sum('price_with_vat');
//         $total_without_vat  = collect($services)->sum('price_without_vat');
//         $total_vat          = collect($services)->sum('price_vat');
//         $needed_blocks      = collect($services)->sum('time_blocks');
          
          
            $insert['total_with_vat']    = collect($services)->sum('price_with_vat');
            $insert['total_without_vat'] = collect($services)->sum('price_without_vat');
            $insert['total_vat']         = collect($services)->sum('price_vat');
            $insert['needed_blocks']     = collect($services)->sum('time_blocks');

            if ($insert['needed_blocks'] < 1) {
                return $this->sendError(trans('error.Error In Time'), [$services]);
            }
          
          
        $service_types = collect($services)->pluck('service_type')->unique();
        
        // check if all services are from same type
        if($service_types->count() > 1){
            return $this->sendError(trans('error.you_cant_choise_services_from_different_types'));
        }
        
        if($needed_blocks < 1 ){
            return $this->sendError(trans('error.Error In Time'), [$services] );
        }

        $needed_blocks      = ceil( $needed_blocks / 5 );
        $time_blocks_ids    = DB::table('b_times')
            ->where('time_id' , '>=', $update['start_time'])
            ->take($needed_blocks+1)
            ->pluck('time_id')
            ->toArray();


            $needed_blocks = ceil($insert['needed_blocks'] / 5);
            $time_blocks_ids = DB::table('b_times')
                ->where('time_id', '>=', $insert['start_time'])
                ->take($needed_blocks + 1)
                ->pluck('time_id')
                ->toArray();

            $insert['end_time'] = end($time_blocks_ids);
            if (count($time_blocks_ids) > 1) {
                unset($time_blocks_ids[count($time_blocks_ids) - 1]);
            }

            // check if date or time changed
            $currentDate = Carbon::parse($insert['booking_date'])->toDateString();
            $oldDate     = Carbon::parse($booking->barber_booking_date)->toDateString();

            // check if date or time is changed 
            $dateChanged = $currentDate !== $oldDate;
            $timeChanged = (int) $insert['start_time'] !== (int) $booking->start_time;

            $hasChanged  = $dateChanged || $timeChanged;

            // now check times only if changed
            if ($hasChanged && $time_blocks_ids[0] != 185) {
                foreach ($time_blocks_ids as $t) {
                    if (!in_array($t, $times)) {
                        return $this->sendError(trans('error.Error In Time'), $times);
                    }
                }
            }

            $insert['services']        = is_array($insert['services']) ? implode(',', $insert['services']) : $insert['services'];
            $insert['time_blocks_ids'] = implode(',', $time_blocks_ids);

            $branch_id   = Branch::get_branch($insert['branch_id'], $lang)->id;

            //check if Coupon and Points provided
            if ($request->filled('coupon_code') && $request->filled('points')) {
                return $this->sendError(trans('error.Coupon and Points can not be used together'), []);
            }

            // Coupon
            if ($request->filled('coupon_code')) {
                $coupon = DB::table('coupons')
                    ->where('coupon_code', $request['coupon_code'])
                    ->whereRaw("FIND_IN_SET(1,platforms_id)")
                    ->where('start_date', '<=', date("Y-m-d"))
                    ->where('end_date', '>=', date("Y-m-d"))
                    ->first();

                if (!$coupon) {
                    return $this->sendError(trans('error.Coupon Not Found'));
                }

                $counter = DB::table('barber_bookings')
                    ->where('barber_customer_id', $customer_id)
                    ->where('coupon_code', $request['coupon_code'])
                    ->where('barber_booking_id', '!=', $booking_id)
                    ->count();

                if ($counter >= $coupon->allowed_count) {
                    return $this->sendError(trans('error.Coupon used before'));
                }

                $insert['coupon_discount'] = $coupon->coupon_type == 1 ? $coupon->discount : ($insert['total_without_vat'] * ($coupon->discount / 100));
            }

            // Points
            if ($request->filled('points')) {
                // check if minimum amount invoice is valid to use points
                $min_amount_invoice = Setting::get_main_setting_by_code('min_amount_invoice')->value ?? 0;
                if ($insert['total_without_vat'] < $min_amount_invoice) {
                    return $this->sendError(trans('error.minimum amount invoice to use points is') . $min_amount_invoice, []);
                }

                // check if customer has enough points to use
                $customer_points = DB::table('customers')->where('customer_id', $customer_id)->first()->wallet_points ?? 0;
                if ($request->points > $customer_points) {
                    return $this->sendError(trans('error.You do not have enough points to use'), []);
                }

                // check min points 
                if ($request->points < 10) {
                    return $this->sendError(trans('error.minimum points to use is') . 10, []);
                }

                // check max points
                if ($request->points > 100) {
                    return $this->sendError(trans('error.maximum points to use is') . 100, []);
                }

                // check if points is multible of 5
                if ($request->points % 5 !== 0) {
                    return $this->sendError(trans('error.points must be multiple of 5'), []);
                }

                // 1- get how many points equal to 1 SAR
                $points_count_sar_usage = Setting::get_main_setting_by_code('points_count_sar_usage')->value ?? 0;
                if ($points_count_sar_usage == 0) {
                    return $this->sendError('error.points_count_sar_usage can not be 0.', []);
                }

                $insert['points_discount'] = $request->points /  $points_count_sar_usage;
            }

            // Ensure defaults if discounts coupon or points not set
            $insert['coupon_discount'] = $insert['coupon_discount'] ?? 0;
            $insert['points_discount'] = $insert['points_discount'] ?? 0;

            // توزيع الخصم على مستوى الخدمات
            $discount_total = $insert['coupon_discount'] + $insert['points_discount'];
            $new_total_vat = 0;
            $new_total_with_vat = 0;
            $insert['total_after_discounts'] = $insert['total_without_vat'] - $discount_total;


            if ($discount_total > 0 && $insert['total_without_vat'] > 0) {
                foreach ($services as $service) {
                    // نسبة المنتج من الإجمالي
                    $service_share = $service->price_without_vat / $insert['total_without_vat'];

                    // الخصم الخاص بالمنتج
                    $service_discount = $discount_total * $service_share;
                    // السعر الجديد بدون الضريبة بعد الخصم
                    $new_price_without_vat = $service->price_without_vat - $service_discount;

                    // الضريبة الجديدة = السعر بعد الخصم × نسبة الضريبة
                    $new_vat = $new_price_without_vat * ($service->tax_percent / 100);

                    $new_total_vat += $new_vat;
                    $new_total_with_vat += $new_price_without_vat + $new_vat;
                }

                $insert['total_vat'] = $new_total_vat;
                $insert['total_price'] = $new_total_with_vat;
            } else {
                // في حالة مفيش خصم خالص
                $insert['total_price'] = $insert['total_after_discounts'] + $insert['total_vat'];
            }
            $insert['total_price'] = $insert['total_after_discounts'] + $insert['total_vat'];


            // New points (based on total_without_vat before discounts)
            $amount_sar_invoice = Setting::get_main_setting_by_code('amount_sar_invoice')->value ?? 1;
            $insert['new_points'] = (int) round(($insert['total_without_vat']) / $amount_sar_invoice);

            //-------------------- Update Booking -------------------------
            DB::table('barber_bookings')->where('barber_booking_id', $booking_id)->update([
                'barber_id'                => $insert['barber_id'],
                'barber_customer_id'       => $customer_id,
                'services'                 => $insert['services'],
                'time_blocks_ids'          => $insert['time_blocks_ids'],
                'needed_blocks'            => $needed_blocks,
                'branch_id'                => $branch_id,
                'barber_booking_date'      => $insert['booking_date'],
                'start_time'               => $insert['start_time'],
                'end_time'                 => $insert['end_time'],
                'coupon_code'              => $insert['coupon_code'] ?? null,
                'coupon_discount'          => $insert['coupon_discount'],
                'points_discount'          => $insert['points_discount'],
                'total_price'              => $insert['total_price'],
                'total_vat'                => $insert['total_vat'],
                'total_without_vat'        => $insert['total_without_vat'],
                'total_with_vat'           => $insert['total_with_vat'],
                'new_points'               => $insert['new_points'],
                'used_points'              => $insert['points'] ?? 0,
            ]);

            // update notes for the customer
            DB::table('customers')->where('customer_id', $customer_id)->update(['notes' => $insert['notes'] ?? null]);

            $updatedBooking = DB::table('barber_bookings')->where('barber_booking_id', $booking_id)->first();
            $this->return['erp_data'] = $updatedBooking;

            return $this->sendResponse($this->return, trans('success.Booking updated successfully'));
        } catch (\Throwable $e) {
            return $this->sendError($e->getMessage(), []);
        }
    }


    public function get_coupon_data($lang, $coupon_code)
    {
        // get coupon data
        app()->setLocale($lang);
        $coupon = DB::table('coupons')
            ->where('coupon_code', $coupon_code)
            ->select('coupon_id', 'coupon_code', 'coupon_type as discount_type', 'discount', 'services', 'allowed_count', 'start_date', 'end_date', 'platforms_id')
            ->first();

        if (!$coupon) {
            return $this->sendError(trans('error.Coupon Not Found'));
        }

        // check platform
        if (!in_array(1, explode(',', $coupon->platforms_id))) {
            return $this->sendError(trans('error.Coupon Not Valid For This Platform'));
        }

        // check start date
        if ($coupon->start_date > date("Y-m-d")) {
            return $this->sendError(trans('error.Coupon Not Started Yet'));
        }

        // check end date
        if ($coupon->end_date < date("Y-m-d")) {
            return $this->sendError(trans('error.Coupon Expired'));
        }


        // check if coupon is used
        if (auth('customer')->check()) {

            $counter = DB::table('barber_bookings')
                ->where('barber_bookings.barber_customer_id', auth('customer')->user()->customer_id)
                ->where('coupon_code', $coupon_code)
                ->count();

            if ($counter >= $coupon->allowed_count) {
                return $this->sendError(trans('error.Coupon used before'));
            }
        }

        $coupon->services = array_filter(explode(',', $coupon->services));


        return $this->sendResponse($coupon);
    }


    public function get_available_dates($lang, Request $request)
    {
        $insert         = $request->only('services', 'month', 'barber_id');
        $last_date      = date("Y-m-t", strtotime($insert['month']));
        $current_date   = date("Y-m-d", strtotime($insert['month']));
        $aval_date      = [];
        while ($last_date >= $current_date) {

            $times = (new GeneralController)->get_available_times($current_date, $insert['barber_id'], $insert['services'], $lang);
            if (count($times) > 0)
                $aval_date[] = $current_date;

            $current_date = date("Y-m-d", strtotime("+1 days " . $current_date));
        }

        return $this->sendResponse($aval_date);
    }
    public function get_available_times($lang, Request $request)
    {
        $insert         = $request->only('services', 'booking_date', 'barber_id');
        $times = (new GeneralController)->get_available_times(date("Y-m-d", strtotime($insert['booking_date'])), $insert['barber_id'], $insert['services'], $lang, true);

        if (count($times) < 1) {
            return $this->sendError(trans('main.not_val_times'), []);
        }

        return $this->sendResponse($times);
    }

    public function get_my_bookings($lang, Request $request)
    {
        $this->return['bookings'] = DB::table('barber_bookings')
            ->leftjoin("items", DB::raw("FIND_IN_SET(items.item_id,barber_bookings.services)"), ">", DB::raw("'0'"))
            ->leftjoin('barber_m', 'barber_bookings.barber_id', '=', 'barber_m.barber_m_id')
            ->leftjoin('b_times', 'barber_bookings.start_time', '=', 'b_times.time_id')
            ->leftjoin('b_branchs', 'barber_bookings.branch_id', '=', 'b_branchs.branch_id')
            ->where('barber_bookings.barber_customer_id', auth('customer')->user()->customer_id)
            ->selectRaw('
                barber_bookings.barber_booking_id as id ,
                barber_bookings.barber_booking_date as booking_date ,
                barber_bookings.branch_id ,
                barber_bookings.activity_status,
                barber_bookings.barber_booking_status,
                barber_m.name_' . $lang . ' as barber_name,
                GROUP_CONCAT(items.name_' . $lang . ') as services_names ,
                b_branchs.name_' . $lang . ' as branch_name ,
                b_times.time_title as booking_time ,
                barber_bookings.total_with_vat,
                barber_bookings.total_without_vat
            ')->orderBy('barber_bookings.barber_booking_id', 'desc')
            ->groupBy('barber_bookings.barber_booking_id')
            ->get();

        return $this->sendResponse($this->return);
    }

    public function get_booking_details($lang, $id, Request $request)
    {

        $query = DB::table('barber_bookings')
            ->leftjoin("items", DB::raw("FIND_IN_SET(items.item_id,barber_bookings.services)"), ">", DB::raw("'0'"))
            ->leftjoin('taxes', 'items.tax_id', '=', 'taxes.tax_id')
            ->leftjoin('barber_m', 'barber_bookings.barber_id', '=', 'barber_m.barber_m_id')
            ->leftjoin('customers', 'barber_bookings.barber_customer_id', '=', 'customers.customer_id')
            ->leftjoin('b_times', 'barber_bookings.start_time', '=', 'b_times.time_id')
            ->leftjoin('branchs', 'barber_bookings.branch_id', '=', 'branchs.branch_id')
            ->groupBy('barber_bookings.barber_booking_id')
            ->where('barber_booking_id', $id);

        if ($lang != null) {
            $query->selectRaw('
                barber_booking_id as id ,
                GROUP_CONCAT(distinct items.name_' . $lang . ') as services_names ,
                GROUP_CONCAT(
                    CAST(
                        IF(items.price_include_vat = 1, ROUND(items.sale_price), ROUND(items.sale_price * (1 + (taxes.tax_percentage / 100)))) AS SIGNED
                    )
                ) as services_prices,
                barber_bookings.needed_blocks ,
                barber_bookings.time_blocks_ids ,
                barber_bookings.services ,
                barber_bookings.barber_id ,
                barber_m.name_' . $lang . ' as barber_name ,
                barber_bookings.barber_booking_date as booking_date ,
                b_times.time_title as booking_time ,
                branchs.name_' . $lang . ' as branch_name ,
                barber_bookings.barber_customer_id as user_id ,
                barber_m.image as barber_image ,
                customers.name_' . $lang . ' as booking_user_name ,
                customers.phone as barber_customer_mobile ,
                customers.notes as barber_customer_notes ,
                barber_bookings.start_time as start_time ,
                barber_bookings.end_time as end_time ,
                barber_bookings.has_invoice ,
                barber_bookings.total_vat ,
                barber_bookings.total_without_vat ,
                barber_bookings.total_with_vat ,
                barber_bookings.barber_booking_status as booking_status ,
                barber_bookings.add_date
            ');
        }

        // booking_id as id ,'.
        //         self::$main_table.'.user_id ,

        //         b_branchs.name_'.$lang.' as branch_name ,'.

        //         self::$main_table.'.has_invoice ,'.
        //         self::$main_table.'.b_invoice_id ,'.
        //         self::$main_table.'.booking_status ,'.
        //         self::$main_table.'.booking_active ,'.
        //         self::$main_table.'.add_date ,'.
        //         self::$main_table.'.add_user

        $this->return['bookings'] = $query->first();

        if (!isset($this->return['bookings']->id) || $this->return['bookings']->user_id != auth('customer')->user()->customer_id) {
            return $this->sendError('Error in booking id', []);
        }

        return $this->sendResponse($this->return);
    }

    public function reject_booking($lang, $id)
    {

        $item = DB::table('barber_bookings')
            ->leftJoin('b_times', 'barber_bookings.start_time', '=', 'b_times.time_id')
            ->selectRaw('barber_booking_id, barber_booking_status, activity_status, new_points, used_points,
            CONCAT(barber_booking_date, " ", time_title) AS start_date, barber_booking_date AS booking_date, start_time,barber_customer_id')
            ->where('barber_booking_id', $id)
            ->first();

        if (!$item) {
            return $this->sendError(trans('error.Booking Not Found'), []);
        }

        if ($item->barber_booking_status == 4) {
            return $this->sendError(trans('error.This Booking Has Invoice created'), []);
        }

        if ($item->activity_status != 0) {
            return $this->sendError(trans('error.Booking Already Accepted'), []);
        }

        if (strtotime($item->start_date) <= strtotime('+2 hours')) {
            return $this->sendError(trans('error.booking_timeout'), []);
        }

        // Ensure the booking belongs to the authenticated customer
        if ($item->barber_customer_id != auth('customer')->user()->customer_id) {
            return $this->sendError(trans('error.Unauthorized'), []);
        }

        // Delete the booking
        DB::table('barber_bookings')
            ->where('barber_booking_id', $id)
            ->delete();

        $time_title = DB::table('b_times')->where('time_id', $item->start_time)->first()->time_title ?? '';
        $day_title  = $this->days[date("D", strtotime($item->booking_date))];

        $message = "ضيفنا العزيز نود تأكيد الغاء موعدكم يوم  الاحد الموافق " . $item->booking_date . " الساعة " . date("h:i:s", strtotime($time_title)) . " " . $this->time[date("A", strtotime($time_title))] . " في فرع الرياض";

        $this->return['content'] = (new SMS)->send("966" . auth('customer')->user()->mobile, $message);
        DB::table('notifications')->insertGetId(array(
            'title'         => 'New Booking',
            'description'   => $message,
            'date'          => date('Y-m-d H:i')
        ));
        return $this->sendResponse($this->return, $message);
    }
}
