<?php

namespace App\Models\Assets;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Assets extends Model
{
    protected $primaryKey = 'asset_m_id';

    public static $main_table = 'assets_m';

    public static $rules = array(
        'name_en' => 'required|string|min:3|unique:assets_m',
        'name_ar' => 'required|string|min:3|unique:assets_m',
        'purchase_date' => 'required|date',
        // 'last_month_depreciation' => 'required|date|after:purchase_date',
    );

    public static function all_assets_m($params = null)
    {
        $query =  DB::table(self::$main_table)
            ->leftjoin('daily_journal_m' , self::$main_table.'.daily_journal_m_id' , '=' , 'daily_journal_m.daily_journal_m_id')
            ->leftJoin('assets_purchases','assets_purchases.asset_m_id','assets_m.asset_m_id')
            ->leftJoin('assets_develop','assets_develop.asset_m_id','assets_m.asset_m_id')
            ->leftJoin('assets_dep_calc_d','assets_dep_calc_d.asset_m_id','assets_m.asset_m_id')
            ->leftJoin('locations','locations.id','assets_m.location_id')
            ->leftJoin('cost_center','cost_center.cost_center_id','assets_m.cost_center_id')
            ->leftJoin('assets_categories','assets_categories.asset_category_id','assets_m.asset_category_id')
            ->groupBy('assets_m.asset_m_id')
            ->orderBy('assets_m.asset_m_id','desc');

        if($params['lang'] != null){
            $query->selectRaw('
                assets_m.asset_m_id as id ,
                assets_m.finance_year_id ,
                assets_m.branch_id,
                assets_m.year_ser ,
                assets_m.month_ser ,
                assets_m.branch_ser ,
                assets_m.daily_journal_m_id ,
                daily_journal_m.year_ser as journal_code ,
                assets_m.name_'.$params['lang'].' as name ,
                assets_m.name_en ,
                assets_m.name_ar ,
                assets_m.asset_category_id ,
                assets_categories.name_'.$params['lang'].' as category_name,
                assets_categories.annual_depr_perc,
                assets_m.asset_code ,
                assets_m.total_vat,
                assets_m.total_value_with_vat,
                assets_m.total_value_without_vat,

                assets_m.opening_value,
                assets_m.annual_depreciation,
                assets_m.daily_depreciation,
                assets_m.dev_value,
                assets_m.depr_value,
                assets_m.remain_value,


                assets_m.last_month_depreciation,
                assets_m.location_id ,
                locations.name_'.$params['lang'].' as location_name,
                assets_m.cost_center_id ,
                cost_center.name_'.$params['lang'].' as cost_center_name,
                assets_m.destruction_calculate ,
                assets_m.stop_dealing ,
                assets_m.previous_years ,
                assets_m.purchase_date ,
                assets_m.depreciation_type ,
                assets_m.depreciation_method ,

                assets_m.total_depr_acc_id ,
                assets_m.profit_loss_acc_id ,
                assets_m.dev_spare_acc_id ,
                assets_m.rev_spare_acc_id ,
                assets_m.exp_depr_acc_id ,
                assets_m.asset_acc_id ,
                SUM(assets_develop.value_added) as dev_asset,
                NULL as first_depr_date,
                assets_m.status ,
                assets_m.add_user ,
                assets_m.add_date ,
                assets_m.active
            ');
        }

        if(isset($params['active']))
            $query->where('assets_m.active' , $params['active']);

        if(isset($params['category']))
            $query->where('assets_m.asset_category_id' , $params['category']);

        if(isset($params['ids']) && is_array($params['ids']) && count($params['ids']) > 0)
            $query->whereIn('assets_m.asset_m_id' , $params['ids']);

        if(isset($params['destruction_calculate']))
            $query->where('assets_m.destruction_calculate' , $params['destruction_calculate']);

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('assets_m.name_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('assets_m.name_en' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_assets_m($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
        ->leftJoin('locations','locations.id','assets_m.location_id')
        ->leftJoin('assets_develop','assets_develop.asset_m_id','assets_m.asset_m_id')
        ->leftJoin('assets_dep_calc_d','assets_dep_calc_d.asset_m_id','assets_m.asset_m_id')
        ->leftJoin('cost_center','cost_center.cost_center_id','assets_m.cost_center_id')
        ->leftJoin('assets_categories','assets_categories.asset_category_id','assets_m.asset_category_id')
        ->leftJoin('assets_purchases','assets_purchases.asset_m_id','assets_m.asset_m_id')
        ->where('assets_m.asset_m_id' , $id)
        ->groupBy('assets_m.asset_m_id');

        if($lang != null){
            $query->selectRaw('
                assets_m.asset_m_id as id ,
                assets_m.finance_year_id ,
                assets_m.branch_id ,
                assets_m.year_ser ,
                assets_m.month_ser ,
                assets_m.branch_ser ,
                assets_m.daily_journal_m_id ,
                assets_m.name_'.$lang.' as name ,
                assets_m.name_en ,
                assets_m.name_ar ,
                assets_m.description,
                assets_categories.annual_depr_perc ,
                assets_categories.depr_months ,
                assets_m.asset_category_id ,
                assets_categories.name_'.$lang.' as category_name,
                assets_m.asset_code ,
                assets_m.total_vat,
                assets_m.total_value_with_vat,
                assets_m.total_value_without_vat,
                assets_m.annual_depreciation,
                assets_m.daily_depreciation,
                assets_m.opening_value,
                assets_m.dev_value,
                assets_m.depr_value,
                assets_m.remain_value,
                assets_m.last_month_depreciation,

                assets_m.location_id ,
                locations.name_'.$lang.' as location_name,
                assets_m.cost_center_id ,
                cost_center.name_'.$lang.' as cost_center_name,
                assets_m.destruction_calculate ,
                assets_m.stop_dealing ,
                assets_m.previous_years ,
                assets_m.purchase_date ,
                assets_m.depreciation_type ,
                assets_m.depreciation_method ,
                assets_m.asset_acc_id ,
                assets_m.total_depr_acc_id ,
                assets_m.profit_loss_acc_id ,
                assets_m.dev_spare_acc_id ,
                assets_m.rev_spare_acc_id ,
                assets_m.exp_depr_acc_id ,


                assets_m.status ,
                SUM(assets_develop.value_added) as dev_asset,
                NULL as first_depr_date,
                assets_m.add_user ,
                assets_m.add_date ,
                assets_m.active
            ');
        }

        $data = $query->first();
        return $data;

    }
    public static function get_assets_payments($m_id,$lang){
        $query =  DB::table('assets_purchases')
            ->leftJoin('taxes','taxes.tax_id','assets_purchases.tax_id')
            ->where('asset_m_id' , $m_id);

        if($lang != null){
            $query->selectRaw('
                assets_purchases.asset_purchase_id as id ,
                assets_purchases.asset_m_id,
                assets_purchases.description ,
                assets_purchases.vat,
                assets_purchases.value_with_vat,
                assets_purchases.value_without_vat,
                assets_purchases.payment_method ,
                assets_purchases.payment_method_id ,
                assets_purchases.tax_id,
                taxes.name_'.$lang.' as tax_name
            ');
        }

        $data = $query->get();
        return $data;
    }
    public static function get_assets_attachments($m_id,$lang){
        $query =  DB::table('assets_attachments')
            ->where('asset_m_id' , $m_id);

        if($lang != null){
            $query->selectRaw('
                assets_attachments.attachment_id as id ,
                assets_attachments.asset_m_id ,
                assets_attachments.file_name ,
                assets_attachments.file_url as file_path ,
                assets_attachments.add_user ,
                assets_attachments.add_date
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function add_assets_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }
    public static function add_assets_d($seed)
    {
        return DB::table('assets_purchases')->insertGetId($seed);
    }
    public static function add_assets_attachments($seed)
    {
        return DB::table('assets_attachments')->insertGetId($seed);
    }
    public static function delete_attachments($id)
    {
        return DB::table('assets_attachments')->where('attachment_id',$id)->delete();

    }
    public static function update_assets_m($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('asset_m_id' , $id )->update($seed);
    }

    public static function delete_assets_m($id)
    {
        return DB::table(self::$main_table)->where('asset_m_id' , $id )->update( array('active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id ));
    }




}
