<?php

namespace App\Models\Assets;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class AssetsCategories extends Model
{
    protected $primaryKey = 'asset_category_id';

    public static $main_table = 'assets_categories';

    public static $rules = array(
        'name_en' => 'required|string|min:3|unique:assets_categories',
        'name_ar' => 'required|string|min:3|unique:assets_categories',
    );

    public static function all_assets_category($params = null)
    {
        $query =  DB::table(self::$main_table);

        if($params['lang'] != null){
            $query->selectRaw('
                asset_category_id as id  ,
                name_'.$params['lang'].' as name ,
                name_ar ,
                name_en,
                annual_depr_perc,
                depr_months,
                asset_acc_id ,
                total_depr_acc_id,
                exp_depr_acc_id,
                profit_loss_acc_id,
                dev_spare_acc_id,
                rev_spare_acc_id,
                add_user,
                add_date,
                active
            ');
        }

        if(isset($params['active']))
            $query->where('active' , $params['active']);

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('name_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('name_en' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_assets_category($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->where('asset_category_id' , $id);

        if($lang != null){
            $query->selectRaw('
                asset_category_id as id  ,
                name_'.$lang.' as name ,
                name_ar ,
                name_en,
                annual_depr_perc,
                depr_months,
                asset_acc_id ,
                total_depr_acc_id,
                exp_depr_acc_id,
                profit_loss_acc_id,
                dev_spare_acc_id,
                rev_spare_acc_id,
                add_user,
                add_date,
                active
            ');
        }

        $data = $query->first();
        return $data;

    }

    public static function add_assets_category($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_assets_category($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('asset_category_id' , $id )->update($seed);
    }

    public static function delete_assets_category($id)
    {
        return DB::table(self::$main_table)->where('asset_category_id' , $id )->update( array('active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id ));
    }




}
