<?php

namespace App\Models\Barbers;

use Illuminate\Database\Eloquent\Model;
use DB;

class BarberCustomer extends Model
{
    protected $primaryKey     = 'customer_id';
    public static $main_table = 'customers';
    public $table             = 'customers';

//    public static $rules = array(
//        'name'   => 'required|string',
//        'mobile' => 'required|string',
//    );

    public static function all_barber_customers($params = null)
    {
        $query = DB::table(self::$main_table)
            ->where('customer_type_id', 2)
            ->orderBy(self::$main_table.'.customer_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                customer_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.phone as mobile ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar', 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }
}
