<?php

namespace App\Models\Elevators;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ElevatorPayments extends Model
{
    protected $primaryKey     = 'id';
    public static $main_table = 'elevators_payments';
    public $table             = 'elevators_payments';

    public static $master_rules = array(
        'name_en'       => 'required|string',
        'name_ar'       => 'required|string',
        'installments'  => 'required|string',

    );

    public static function all_payments($params = null)
    {
        $query = DB::table(self::$main_table)
            ->orderBy(self::$main_table.'.id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.installments ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,'.
                self::$main_table.'.active
            ');
        }

        if(isset($params['active']))
            $query->where('active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }
        foreach($data as $item){
            $item->installments = json_decode($item->installments);

        }
        return $data;
    }

    public static function get_payment($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('id', $id);

        if($lang != null){
            $query->selectRaw('
                id ,'.
                self::$main_table.'.name_'.$lang.' as name ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.installments ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.active
            ');
        }

        $data = $query->first();
        $data->installments = json_decode($data->installments);
        return $data;
    }


    public static function get_payment_lookup($lang = null)
    {
        $query = DB::table('elevators_payments')
        ->where('active' , 1 )
        ->orderBy('id', 'desc');

        if($lang != null){
            $query->selectRaw('id as id ,name_ar,name_en, name_'.$lang.' as name ');
        }

        $data = $query->get();

        return $data;
    }

    public static function add_payment($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_payment($seed, $id)
    {
        return DB::table(self::$main_table)->where('id', $id)->update($seed);
    }

    public static function delete_payment($id)
    {
        return DB::table(self::$main_table)->where('id', $id)->update(array('active' => '0'));
    }

}
