<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use DB;

class ChequeIncoming extends Model
{
    protected $primaryKey       = 'cheque_incoming_id';
    public static $main_table   = 'cheque_incomings';
    public $table               = 'cheque_incomings';

    public static $rules = array(
        'cheque_number'         => 'required|numeric' ,
        'customer_id'           => 'required|numeric' ,
        'voucher_id'            => 'required|numeric' ,
        'due_date'              => 'required|date',
        'bank_id'               => 'required|numeric' ,
        'deposit_date'          => 'required|date',
        'amount'                => 'required|numeric|min:1',
    );

    public static function all_cheque_incoming( $params = null)
    {
        $query =  DB::table(self::$main_table)
                    ->leftjoin('cheque_status', self::$main_table.'.cheque_status_id', '=', 'cheque_status.cheque_status_id')
                    ->leftjoin('customers' , self::$main_table.'.customer_id' , '=' , 'customers.customer_id')
                    ->leftjoin('suppliers' , self::$main_table.'.supplier_id' , '=' , 'suppliers.supplier_id')
                    ->leftjoin('banks' , self::$main_table.'.bank_id' , '=' , 'banks.bank_id');

        if($params['lang'] != null){
            $query->selectRaw('
                cheque_incoming_id as id  ,
                cheque_number ,
                voucher_id ,
                due_date ,
                deposit_date ,
                cheque_status_name_'.$params['lang'].' as status_name ,
                banks.bank_id as bank_id  ,
                banks.name_'.$params['lang'].' as bank_name ,
                customers.customer_id as customer_id  ,
                customers.name_'.$params['lang'].' as customer_name ,
                suppliers.supplier_id as supplier_id  ,
                suppliers.name_'.$params['lang'].' as supplier_name ,
                amount,'.
                self::$main_table.'.cheque_status_id as cheque_status_id,'.
                self::$main_table.'.add_date as add_date
            ');
        }

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.customer_id' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.supplier_id' , 'LIKE' , "%{$params['word']}%");
            });

        }

        if(isset($params['branch'])){
            $query->where(self::$main_table.'.branch_id' , $params['branch']);
        }

        if(isset($params['finance_year'])){
            $query->where(self::$main_table.'.finance_year_id' , $params['finance_year']);
        }
        
        if(isset($params['status']) && strlen($params['status']) >  0){
            $query->where(self::$main_table.'.cheque_status_id' , 'LIKE' , "%{$params['status']}%");
        }

        if(isset($params['from_date']) && isset($params['to_date'])  ){
            $query->whereBetween(self::$main_table.'.add_date', [$params['from_date'],$params['to_date']]);
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }


        return $data;
    }

    public static function get_cheque_incoming($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->where('cheque_incoming_id' , $id);

        if($lang != null){
            $query->selectRaw('
                cheque_incoming_id as id  ,
                cheque_number ,
                customer_id ,
                voucher_id ,
                due_date ,
                bank_id ,
                deposit_date ,
                cheque_status ,
                amount
            ');
        }

        $data = $query->first();
        return $data;

    }

    public static function add_cheque_incoming($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_cheque_incoming($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('cheque_incoming_id' , $id )->update($seed);
    }



}
