<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class CostCenter extends Model
{

    protected $primaryKey = 'cost_center_id';
    public static $main_table = 'cost_center';
    public $table = 'cost_center';

    public static $rules = array(
        'name_en' => 'required|string|min:3|unique:cost_center',
        'name_ar' => 'required|string|min:3|unique:cost_center',
        'cost_center_code' => 'required|string|unique:cost_center',

    );

    public static function active_cost_centers($lang = null , $params = null)
    {
        $query =  DB::table(self::$main_table);

        if($lang != null){
            $query->selectRaw('
            cost_center_id as id  ,
            parent_id ,
            cost_center_code ,
            name_'.$lang.' as name ,
            name_ar ,
            name_en ,
            account_type ,
            if(account_type = "1" , "folder" , "item") as type ,
            if(account_type = "1" , true , false ) as hasChild ,
            protection ,
            active ,
            main_account ,
            level_chars
            ');
        }

        if(isset($params['account_type']))
             $query->where('account_type' , $params['account_type']);

        if(isset($params['parent']))
            $query->where('parent_id' , $params['parent']);


        if(isset($params['active']))
            $query->where('active' , $params['active']);

        if(isset($params['ids']) && is_array($params['ids']) )
            $query->whereIn('cost_center_id' , $params['ids']);

        if(isset($params['start_with']))
            $query->where('cost_center_code' , 'like' , $params['start_with']."%");



        $data = $query->get();
    return $data;
    }

    public static function get_cost_center($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->where('cost_center_id' , $id);

        if($lang != null){
            $query->selectRaw('
                cost_center_id as id  ,
                parent_id ,
                cost_center_code ,
                name_'.$lang.' as name ,
                name_ar ,
                name_en ,
                account_type ,
                if(account_type = "1" , "folder" , "item") as type ,
                if(account_type = "1" , true , false ) as hasChild ,
                protection ,
                active ,
                main_account ,
                level_chars
            ');
        }

        $data = $query->first();
        return $data;

    }

    public static function add_cost_center($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_cost_center($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('cost_center_id' , $id )->update($seed);
    }

    public static function delete_cost_center($id)
    {
        return DB::table(self::$main_table)->where('cost_center_id' , $id )->update( array('active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }

}
