<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use DB;

class FinancialPeriod extends Model
{
    protected $primaryKey           = 'financial_period_id';
    public static $main_table       = 'financial_periods';
    // public $table                   = 'financial_periods';

    public static $rules = array(
        'finance_year_id'   => 'required|numeric',
        'months'            => 'required|array',
        'months.*'          => 'numeric',
    );

    public static function all_financial_periods($params = null)
    {
        $query =  DB::table(self::$main_table)
            ->leftjoin('finance_years' , self::$main_table.'.finance_year_id' , '=' , 'finance_years.finance_year_id')
            ->leftjoin('daily_journal_m' , 'daily_journal_m.daily_journal_m_id' , '=' , 'finance_years.daily_journal_id')
            ->orderBy(self::$main_table.'.financial_period_id' , 'desc');

        if(isset($params['lang'])){
            $query->selectRaw('
                financial_period_id as fp_id  ,
                months ,
                financial_period_active ,
                finance_years.finance_year_id ,
                finance_years.daily_journal_id ,
                daily_journal_m.year_ser as journal_code ,
                finance_years.name as finance_year_name ,'.
                self::$main_table.'.add_date
            ');
        }

        if(isset($params['active']))
            $query->where('financial_period_active' , $params['active'] );

        if(isset($params['finance_year'])){
            $query->where(self::$main_table.'.finance_year_id' , $params['finance_year']);
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_financial_period($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->join('finance_years' , self::$main_table.'.finance_year_id' , '=' , 'finance_years.finance_year_id')
            ->where('financial_period_id' , $id);

        if($lang != null){
            $query->selectRaw('
                financial_period_id as fp_id  ,
                months ,
                financial_period_active ,
                finance_years.finance_year_id ,
                finance_years.name as finance_year_name ,'.
                self::$main_table.'.add_date
            ');
        }

        $data = $query->first();
        return $data;

    }

    public static function add_financial_period($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_financial_period($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('financial_period_id' , $id )->update($seed);
    }

    public static function delete_financial_period($id)
    {
        return DB::table(self::$main_table)->where('financial_period_id' , $id )->update( array('financial_period_active' => 0 , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )  );
    }
}