<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use DB;

class Tax extends Model
{
    protected $primaryKey     = 'tax_id';
    public static $main_table = 'taxes';
    public $table             = 'taxes';

    public static $rules = array(
        'name_en'        => 'required|string|unique:taxes',
        'name_ar'        => 'required|string|unique:taxes',
        'tax_type_id'    => 'required|numeric|min:1',
        'account_tree_id' => 'required|numeric|min:1',
        'tax_percentage' => 'required|numeric',
    );

    public static function all_taxes($params = null)
    {
        $query = DB::table(self::$main_table . ' as taxes')
            ->leftJoin('tax_types as taxTypes', 'taxTypes.tax_type_id', '=', 'taxes.tax_type_id')
            ->orderBy('taxes.tax_id', 'asc');

        if (isset($params['lang'])) {
            $query->selectRaw('
            taxes.tax_id as id,
            taxes.name_' . $params['lang'] . ' as name,
            taxes.name_ar,
            taxes.name_en,
            taxes.tax_type_id,
            taxTypes.tax_neutral,
            taxes.details,
            taxes.tax_percentage,
            taxes.tax_status,
            taxes.tax_active,
            taxes.add_date,
            taxes.add_user
        ');
        }

        if (isset($params['active'])) {
            $query->where('taxes.tax_active', $params['active']);
        }

        if (isset($params['type'])) {
            $query->where('taxTypes.tax_neutral', $params['type']);
        }

        if (isset($params['word']) && strlen($params['word']) > 0) {
            $query->where(function ($stmt) use ($params) {
                $stmt->where('taxes.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere('taxes.name_ar', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }


        return $data;
    }

    public static function get_tax($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('tax_id', $id);

        if ($lang != null)
            $query->selectRaw('
                tax_id as id ,' .
                self::$main_table . '.name_' . $lang . ' as name ,' .
                self::$main_table . '.name_ar ,' .
                self::$main_table . '.name_en ,
                tax_type_id ,
                account_tree_id ,
                details ,
                tax_percentage ,' .
                self::$main_table . '.tax_status,' .
                self::$main_table . '.tax_active,' .
                self::$main_table . '.add_date,' .
                self::$main_table . '.add_user
            ');

        $data = $query->first();
        return $data;
    }

    public static function add_tax($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_tax($seed, $id)
    {
        return DB::table(self::$main_table)->where('tax_id', $id)->update($seed);
    }

    public static function delete_tax($id)
    {
        return DB::table(self::$main_table)->where('tax_id', $id)->update(array('tax_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
