<?php

namespace App\Models\Inventory;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Item extends Model
{
    protected $primaryKey     = 'item_id';
    public static $main_table = 'items';
    public $table             = 'items';

    public static $rules = array(
        'name_en'                  => 'required|string|unique:items' ,
        'name_ar'                  => 'required|string|unique:items' ,
        // 'item_number'              => 'required|string|unique:items' ,
        'category_id'              => 'required|numeric' ,
        'item_type_id'             => 'required|numeric' ,
        'big_unit_id'              => 'required|numeric' ,
        'big_unit_coefficient'     => 'required|numeric' ,
        'mid_unit_id'              => 'required|numeric' ,
        'mid_unit_coefficient'     => 'required|numeric' ,
        'small_unit_id'            => 'required|numeric' ,
        'small_unit_coefficient'   => 'required|numeric' ,
        'default_report_unit_type' => 'required|numeric' ,
        'sale_price'               => 'required|numeric' ,
        'min_sale_price'           => 'required|numeric' ,
        'purchases_revenue_id'     => 'required|numeric' ,
        'purchases_return_id'      => 'required|numeric' ,
        'purchases_discount_id'    => 'required|numeric' ,
        'sales_revenue_id'         => 'required|numeric' ,
        'sales_return_id'          => 'required|numeric' ,
        'sales_discount_id'        => 'required|numeric' ,
        'tax_id'                   => 'required|numeric' ,
    );

    public static function all_items($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('stocks', 'stocks.item_id', '=', 'items.item_id')
            ->leftjoin('categorys', self::$main_table.'.category_id', '=', 'categorys.category_id')
            ->leftjoin('item_types', self::$main_table.'.item_type_id', '=', 'item_types.item_type_id')
            ->leftjoin('taxes', self::$main_table.'.tax_id', '=', 'taxes.tax_id')
            ->orderBy(self::$main_table.'.category_id')
            ->orderBy(self::$main_table.'.item_id')
            ->groupBy('items.item_id');
        

        if(isset($params['lang'])){
            $query->selectRaw('
                items.item_id as id ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.location ,'.
                self::$main_table.'.item_number ,'.
                self::$main_table.'.description ,
                item_width_height ,
                if(is_service , 10000000 ,  IFNULL(stocks.stock, 0)  )as stock , '.
                self::$main_table.'.category_id ,
                categorys.name_'.$params['lang'].' as category_name ,'.
                self::$main_table.'.item_type_id ,
                item_types.name_'.$params['lang'].' as item_type_name ,'.
                self::$main_table.'.big_unit_id,'.
                self::$main_table.'.big_unit_coefficient,'.
                self::$main_table.'.mid_unit_id,'.
                self::$main_table.'.mid_unit_coefficient,'.
                self::$main_table.'.small_unit_id,'.
                self::$main_table.'.small_unit_coefficient,'.
                self::$main_table.'.default_report_unit_type,'.
                self::$main_table.'.image,'.
                self::$main_table.'.price_include_vat,'.
                self::$main_table.'.sale_price,
                ROUND(if(price_include_vat = 1 , sale_price , sale_price * ( 1 + ( taxes.tax_percentage / 100 ) )  ) , 2 ) as price_with_vat ,
                ROUND(if(price_include_vat = 1 , (sale_price - (sale_price / ( 1 + ( taxes.tax_percentage / 100 ) ) ) ) , ( sale_price * ( taxes.tax_percentage / 100 ) )  ) , 2 ) as price_vat ,
                ROUND(if(price_include_vat = 1 , (sale_price / ( 1 + ( taxes.tax_percentage / 100 ) ) ) , sale_price ) , 2 ) as price_without_vat ,'.
                self::$main_table.'.min_sale_price,'.
                self::$main_table.'.time_blocks,'.
                self::$main_table.'.purchases_revenue_id,'.
                self::$main_table.'.purchases_return_id,'.
                self::$main_table.'.purchases_discount_id,'.
                self::$main_table.'.sales_revenue_id,'.
                self::$main_table.'.sales_return_id,'.
                self::$main_table.'.sales_discount_id,'.
                self::$main_table.'.is_service,'.
                self::$main_table.'.tax_id,
                taxes.tax_percentage as tax_percent ,'.
                self::$main_table.'.item_status,'.
                self::$main_table.'.item_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');
            if(isset($params['is_search'])){
                $query->selectRaw('ifnull(concat(item_number ," - " , items.name_'.$params['lang'].' ) , items.name_'.$params['lang'].') as name');
            }else{
                $query->selectRaw('items.name_'.$params['lang'].' as name');
            }
        }


        if(isset($params['active']))
            $query->where(self::$main_table.'.item_active', $params['active']);

        if(isset($params['is_service']))
            $query->where(self::$main_table.'.is_service', $params['is_service']);

        if(isset($params['stock_items_ids']))
            $query->whereIn(self::$main_table.'.item_id', $params['stock_items_ids']);

        if(isset($params['category_id']))
            $query->where(self::$main_table.'.category_id', $params['category_id']);

        if(isset($params['pos_item']))
            $query->where(self::$main_table.'.pos_item', $params['pos_item']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.item_id', 'LIKE' , "%{$params['word']}%")
                    ->orWhere('categorys.name_en', 'LIKE' , "%{$params['word']}%")
                    ->orWhere('categorys.name_ar', 'LIKE' , "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.item_number','LIKE', "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.location','LIKE', "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_en', 'LIKE' , "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar', 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_item($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('categorys', self::$main_table.'.category_id', '=', 'categorys.category_id')
            ->leftjoin('item_types', self::$main_table.'.item_type_id', '=', 'item_types.item_type_id')
            ->leftjoin('taxes', self::$main_table.'.tax_id', '=', 'taxes.tax_id')
            ->where('item_id', $id);

        if($lang != null)
            $query->selectRaw('
                item_id as id ,'.
                self::$main_table.'.name_'.$lang.' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.location ,'.
                self::$main_table.'.item_number ,'.
                self::$main_table.'.description ,
                item_width_height , '.
                self::$main_table.'.category_id ,
                categorys.name_'.$lang.' as category_name ,'.
                self::$main_table.'.item_type_id ,
                item_types.name_'.$lang.' as item_type_name ,'.
                self::$main_table.'.big_unit_id,'.
                self::$main_table.'.big_unit_coefficient,'.
                self::$main_table.'.mid_unit_id,'.
                self::$main_table.'.mid_unit_coefficient,'.
                self::$main_table.'.small_unit_id,'.
                self::$main_table.'.small_unit_coefficient,'.
                self::$main_table.'.default_report_unit_type,'.
                self::$main_table.'.image,'.
                self::$main_table.'.price_include_vat,'.
                self::$main_table.'.sale_price,
                ('.self::$main_table.'.sale_price * ( 1 + ( taxes.tax_percentage / 100 ) ) ) as price_with_vat , '.
                self::$main_table.'.min_sale_price,'.
                self::$main_table.'.time_blocks,'.
                self::$main_table.'.pos_item,'.
                self::$main_table.'.purchases_revenue_id,'.
                self::$main_table.'.purchases_return_id,'.
                self::$main_table.'.purchases_discount_id,'.
                self::$main_table.'.sales_revenue_id,'.
                self::$main_table.'.sales_return_id,'.
                self::$main_table.'.sales_discount_id,'.
                self::$main_table.'.is_service,'.
                self::$main_table.'.tax_id,
                taxes.tax_percentage as tax_percent ,'.
                self::$main_table.'.item_status,'.
                self::$main_table.'.item_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        $data = $query->first();
        return $data;
    }

    public static function get_items_by_category($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('categorys', self::$main_table.'.category_id', '=', 'categorys.category_id')
            ->leftjoin('item_types', self::$main_table.'.item_type_id', '=', 'item_types.item_type_id')
            ->leftjoin('taxes', self::$main_table.'.tax_id', '=', 'taxes.tax_id')
            ->where(self::$main_table.'.category_id', $params['category_id']);

        if(isset($params['lang']))
            $query->selectRaw('
                item_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.location ,'.
                self::$main_table.'.item_number ,'.
                self::$main_table.'.category_id ,
                categorys.name_'.$params['lang'].' as category_name ,'.
                self::$main_table.'.item_type_id ,
                item_types.name_'.$params['lang'].' as item_type_name ,'.
                self::$main_table.'.big_unit_id,'.
                self::$main_table.'.big_unit_coefficient,'.
                self::$main_table.'.mid_unit_id,'.
                self::$main_table.'.mid_unit_coefficient,'.
                self::$main_table.'.small_unit_id,'.
                self::$main_table.'.small_unit_coefficient,'.
                self::$main_table.'.default_report_unit_type,'.
                self::$main_table.'.image,'.
                self::$main_table.'.sale_price,'.
                self::$main_table.'.min_sale_price,'.
                self::$main_table.'.time_blocks,'.
                self::$main_table.'.purchases_revenue_id,'.
                self::$main_table.'.purchases_return_id,'.
                self::$main_table.'.purchases_discount_id,'.
                self::$main_table.'.sales_revenue_id,'.
                self::$main_table.'.sales_return_id,'.
                self::$main_table.'.sales_discount_id,'.
                self::$main_table.'.is_service,'.
                self::$main_table.'.tax_id,
                taxes.tax_percentage as tax_percent ,'.
                self::$main_table.'.item_status,'.
                self::$main_table.'.item_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function add_item($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_item($seed, $id)
    {
        return DB::table(self::$main_table)->where('item_id', $id)->update($seed);
    }

    public static function delete_item($id)
    {
        return DB::table(self::$main_table)->where('item_id', $id)->update(array('item_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
