<?php

namespace App\Models\Inventory;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class UnitMeasurement extends Model
{
    protected $primaryKey     = 'unit_measurement_id';
    public static $main_table = 'unit_measurements';
    public $table             = 'unit_measurements';

    public static $rules = array(
        'name_en'         => 'required|string|unique:unit_measurements',
        'name_ar'         => 'required|string|unique:unit_measurements'
    );

    public static function all_unit_measurements($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('account_tree', self::$main_table.'.account_tree_id', '=', 'account_tree.account_tree_id')
            ->orderBy(self::$main_table.'.unit_measurement_id', 'desc');

        if(isset($params['lang']))
            $query->selectRaw('
                unit_measurement_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.account_tree_id ,
                account_tree.name_'.$params['lang'].' as account_name ,'.
                self::$main_table.'.unit_measurement_status,'.
                self::$main_table.'.unit_measurement_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        if(isset($params['active']))
            $query->where('unit_measurement_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en', 'LIKE' , "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar', 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_unit_measurement($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('account_tree', self::$main_table.'.account_tree_id', '=', 'account_tree.account_tree_id')
            ->where('unit_measurement_id' , $id);

        if($lang != null)
            $query->selectRaw('
                unit_measurement_id as id ,'.
                self::$main_table.'.name_'.$lang.' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.account_tree_id ,
                account_tree.name_'.$lang.' as account_name ,'.
                self::$main_table.'.unit_measurement_status,'.
                self::$main_table.'.unit_measurement_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        $data = $query->first();
        return $data;
    }

    public static function add_unit_measurement($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_unit_measurement($seed, $id)
    {
        return DB::table(self::$main_table)->where('unit_measurement_id', $id)->update($seed);
    }

    public static function delete_unit_measurement($id)
    {
        return DB::table(self::$main_table)->where('unit_measurement_id', $id)->update(array('unit_measurement_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
