<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class Branch extends Model
{

    protected $primaryKey = 'branch_id';

    public static $main_table = 'branchs';
    protected  $table = 'branchs';


    public static $rules = array(
        'name_en' => 'required|string|min:3',
        'name_ar' => 'required|string|min:3',
        'first_cash' => 'required',
        'vat_register_name' => 'required',
        'vat_number' => 'required|numeric',
        'cost_center_id' => 'required|numeric',
        'account_tree_id' => 'required|numeric',
        'bank_account_id' => 'required|numeric',
        'treasury_account_id' => 'required|numeric',
        'settlement_account' => 'required',
        'print_header_active' => 'required|numeric',
        'print_footer_active' => 'required|numeric',
    );

    public static function all_branchs($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('warehouses' , self::$main_table.'.default_warehouse' , '=' , 'warehouses.warehouse_id');

        if(isset($params['lang'])){
            $query->selectRaw('branch_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,
                vat_number ,
                users ,
                cost_center_id ,
                default_warehouse ,
                warehouses.name_'.$params['lang'].' as warehouse_name ,'.
                self::$main_table.'.account_tree_id ,
                bank_account_id ,
                treasury_account_id ,
                settlement_account ,
                first_cash ,'.
                self::$main_table.'.add_date,
                vat_register_name,
                stock_type'
            );

        }


        if(isset($params['active']))
            $query->where('branch_active' , $params['active'] );

        if(isset($params['user']) && strlen($params['user']) >  0)
            $query->whereRaw("find_in_set(".$params['user']." , users)");

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en' , 'LIKE' , "%{$params['word']}%")
                ->orWhere(self::$main_table.'.name_ar' , 'LIKE' , "%{$params['word']}%");
            });

        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_branch($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('warehouses' , self::$main_table.'.default_warehouse' , '=' , 'warehouses.warehouse_id')
            ->where('branch_id' , $id);

        if($lang != null){
            $query->selectRaw('
            branch_id as id ,'.
            self::$main_table.'.name_'.$lang.' as name ,
            print_label_ar ,
            print_label_en  ,
            print_footer ,
            vat_number ,
            users ,
            cost_center_id ,
            default_warehouse ,
            warehouses.name_'.$lang.' as warehouse_name ,'.
            self::$main_table.'.account_tree_id ,
            bank_account_id ,
            treasury_account_id ,
            settlement_account ,
            first_cash ,'.
            self::$main_table.'.add_date ,
            stock_type ,
            branchs.crn ,
            print_margin  ,
            print_header_active ,
            print_footer_active ,
            invoice_title_active ,
            branch_image,
            header_image,
            vat_register_name
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function add_branch($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_branch($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('branch_id' , $id )->update($seed);
    }

    public static function delete_branch($id)
    {
        return DB::table(self::$main_table)->where('branch_id' , $id )->update( array('branch_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }
}
