<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class DailyType extends Model
{

    protected $primaryKey = 'daily_type_id';

    public static $main_table = 'daily_types';


    public static $rules = array(
        'name_en' => 'required|string|min:3',
        'name_ar' => 'required|string|min:3',
    );


    public static function all_daily_types($params = null)
    {
        $query =  DB::table(self::$main_table);


        if(isset($params['lang'])){
            $query->selectRaw('daily_type_id as id , name_'.$params['lang'].' as name ');
        }
        

        if(isset($params['active']))
            $query->where('daily_type_active' , $params['active'] );
        

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('name_en' , 'LIKE' , "%{$params['word']}%")
                ->orWhere('name_ar' , 'LIKE' , "%{$params['word']}%");
            });
            
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }
        
        return $data;
    }

    public static function get_daily_type($id)
    {
        return DB::table(self::$main_table)
            ->where('daily_type_id' , $id) 
            ->first();
    }

    public static function add_daily_type($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_daily_type($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('daily_type_id' , $id )->update($seed);
    }

    public static function delete_daily_type($id)
    {
        return DB::table(self::$main_table)->where('daily_type_id' , $id )->update( array('daily_type_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id ) );
    }
}