<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class Delegate extends Model
{

    protected $primaryKey = 'delegate_id';

    public static $main_table = 'delegates';

    public static $rules = array(
        'name_en'      => 'required|string' ,
        'name_ar'      => 'required|string' ,
        'mobile'       => 'required|string' ,
        'branchs'      => 'required'
    );

    public static function all_delegates($params = null)
    {
        $query =  DB::table(self::$main_table);

        if( isset($params['lang']) )
            $query->selectRaw('delegate_id as id ,
            name_'.$params['lang'].' as name ,
            mobile ,
            if(customer_id > 0 , true , false) as related_customer ,
            if(supplier_id > 0 , true , false) as related_supplier ,
            customer_id ,
            supplier_id ,
            branchs ,
            add_date ,
            add_user ,
            delegate_active ,
            delegate_order ,
            disable_date ,
            disable_user
            ');

        if(isset($params['active']))
            $query->where('delegate_active' , $params['active'] );

        if(isset($params['word']) && strlen($params['word']) >  0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('name_ar' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_delegate($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('delegate_id' , $id);

        if($lang != null){
            $query->selectRaw('delegate_id as id ,
            name_'.$lang.' as name ,
            mobile ,
            if(customer_id > 0 , true , false) as related_customer ,
            if(supplier_id > 0 , true , false) as related_supplier ,
            customer_id ,
            supplier_id ,
            branchs ,
            add_date ,
            add_user ,
            delegate_active ,
            delegate_order ,
            disable_date ,
            disable_user
            ');
        }

        $data = $query->first();

        return $data;
    }

    public static function add_delegate($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_delegate($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('delegate_id' , $id )->update($seed);
    }

    public static function delete_delegate($id)
    {
        return DB::table(self::$main_table)->where('delegate_id' , $id )->update(array('delegate_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id));
    }
}
