<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class FinanceYear extends Model
{

    protected $primaryKey = 'finance_year_id';
    public static $main_table = 'finance_years';
    public static $rules = array(
        'name' => 'required|string|min:3',
    );

    public static function all_finance_years($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('daily_journal_m' , self::$main_table.'.daily_journal_id' , '=' , 'daily_journal_m.daily_journal_m_id')
            ->selectRaw('
                finance_years.finance_year_id as id ,
                finance_years.name ,
                finance_years.daily_journal_id ,
                daily_journal_m.year_ser as journal_code ,
                finance_years.users ,
                finance_years.add_date
                ');
        

        if(isset($params['active']))
            $query->where('finance_year_active' , $params['active'] );
        

        if(isset($params['word']) && strlen($params['word']) >  0)
            $query->where('name' , 'LIKE' , "%{$params['word']}%" );

        if(isset($params['user']) && strlen($params['user']) >  0)
            $query->whereRaw("find_in_set(".$params['user']." , users)");

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;

    }

    public static function get_finance_year($id)
    {
        return DB::table(self::$main_table)
            ->where('finance_year_id' , $id) 
            ->selectRaw('finance_year_id as id , name , users , add_date')
            ->first();
    }

    public static function add_finance_year($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_finance_year($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('finance_year_id' , $id )->update($seed);
    }

    public static function delete_finance_year($id)
    {
        return DB::table(self::$main_table)->where('finance_year_id' , $id )->update( array('finance_year_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }
}