<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class Lookups extends Model
{


    public static function get_all($params = null)
    {
        $data = [];

        // Get all tables in the database
        $tables = DB::select('SHOW TABLES');
        $databaseName = DB::connection()->getDatabaseName();
        $tableColumn = "Tables_in_{$databaseName}";

        foreach ($tables as $table) {
            $tableName = $table->$tableColumn;

            // Check if the table has 'name_ar' and 'name_en' columns
            if (Schema::hasColumn($tableName, 'name_ar') && Schema::hasColumn($tableName, 'name_en')) {
                $data[] = [
                    'lookup'  => $tableName,
                ];
            }
        }

        return $data;
    }
    public static function get_data($params = null)
    {
        $data = [];
        $databaseName = DB::connection()->getDatabaseName();

        if (isset($params['lookups']) && is_array($params['lookups'])) {
            foreach ($params['lookups'] as $lookup) {
                $tableName = $lookup['lookup'];
                $primaryKeyColumn = DB::select("SHOW KEYS FROM {$tableName} WHERE Key_name = 'PRIMARY'");

                $activeColumns = DB::table('information_schema.columns')
                    ->where('table_schema', $databaseName)->where('table_name', $tableName)->where('column_name', 'LIKE', '%active%')
                    ->value('column_name');

                $primaryKey = $primaryKeyColumn[0]->Column_name;
                if (isset($lookup['all_data']) && $lookup['all_data'] == 'true') {
                    $query = DB::table($tableName)
                        ->selectRaw('*,name_' . $params['lang'] . ' as name,' . $primaryKey . ' as id');
                } elseif($tableName == 'account_tree') {
                    $query = DB::table($tableName)
                        ->selectRaw('name_' . $params['lang'] . ' as name,' . $primaryKey . ' as id , account_type');
                } else {
                    $query = DB::table($tableName)
                        ->selectRaw('name_' . $params['lang'] . ' as name,' . $primaryKey . ' as id');
                }


                if(isset($lookup['id']) && $lookup['id'] > 0){
                    $query->where($primaryKey , $lookup['id']);
                }

                if(isset($activeColumns) && strlen($activeColumns) > 0){
                    $query->where($activeColumns, 1);
                }

                $data[$tableName] = $query->get();
            }
        }

        return $data;
    }
}
