<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class Setting extends Model
{

    protected $primaryKey = 'setting_id';
    public static $main_table = 'settings';

    public static $rules = array(

    );

    public static function all_settings($params = null)
    {
        $query =  DB::table(self::$main_table)
            ->join('setting_categorys' , self::$main_table.'.setting_category_id' , '=' , 'setting_categorys.setting_category_id')
            ->orderBy('setting_order')
            ->where('setting_active' , 1);

        if( isset($params['lang']) )
            $query->selectRaw('setting_id as id , setting_categorys.setting_category_id as category_id , setting_category_title_'.$params['lang'].' as category_title, setting_label_'.$params['lang'].' as label  , type , value , lookups_id , cols , offsets , spaces , divider , required , multi , disabled');

        if( isset($params['main_id']) )
            $query->where('screen_main_id', $params['main_id']);

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('setting_label_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('setting_label_en' , 'LIKE' , "%{$params['word']}%");
            });

        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_setting($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('setting_id' , $id);

        if($lang != null){
            $query->selectRaw('setting_id as id , setting_categorys.setting_category_id as category_id , setting_category_title_'.$lang.' as category_title, setting_label_'.$lang.' as label  , type , value , lookups_id , cols , offsets , spaces , divider , required , multi , disabled');
        }

        $data = $query->first();

        return $data;
    }



    public static function get_main_setting_by_code($code , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('setting_code' , $code);

        if($lang != null){
            $query->selectRaw('setting_id as id , setting_categorys.setting_category_id as category_id , setting_category_title_'.$lang.' as category_title, setting_label_'.$lang.' as label  , type , value , lookups_id , cols , required , multi , disabled');
        }

        $data = $query->first();

        return $data;
    }
    public static function get_code_settings($code , $lang = 'ar')
    {
        $data = DB::table(self::$main_table)
            ->where('setting_active' , 1)
            ->where('setting_code' , 'like' , $code.'%')
            ->selectRaw('value , setting_label_'.$lang.' as label')
            ->get();


        return $data;
    }



    public static function add_setting($seed)
    {
        // return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_setting($value ,  $id)
    {
        return DB::table(self::$main_table)->where('setting_id' , $id )->update( array('value' => $value ) );
    }

    public static function delete_setting($id)
    {
        // return DB::table(self::$main_table)->where('setting_id' , $id )->update( array('setting_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id));
    }

    public static function get_gold_price($in_date)
    {
        return DB::table('gold_price')
            ->where('add_date' , '<=' , date("Y-m-d H:i:s" , strtotime($in_date)))
            ->orderBy('id' , 'desc')
            ->selectRaw('add_date , ounce_price , round(24_price , 4) as 24_price , round(22_price , 4) as 22_price , round(21_price , 4) as 21_price , round(18_price , 4) as 18_price , round(24_price , 4) as price_24 , round(22_price , 4) as price_22 , round(21_price , 4) as price_21 , round(18_price , 4) as price_18 , ounce_price_sar as ounce')
            ->first();
    }


}
