<?php

namespace App\Models\POS;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class BarberBooking extends Model
{
    protected $primaryKey     = 'barber_booking_id';
    public static $main_table = 'barber_bookings';
    public $table             = 'barber_bookings';
    public static $rules = array(
        'branch_id'    => 'required|numeric',
        'booking_date' => 'required|date',
        'start_time'   => 'required|numeric',
    );
    public static function all_barber_bookings($params = null)
    {
        $query = DB::table(self::$main_table)
            ->select(DB::raw("GROUP_CONCAT(distinct items.name_ar) as services_names"))
            ->leftjoin("items",\DB::raw("FIND_IN_SET(items.item_id,barber_bookings.services)"),">",\DB::raw("'0'"))
            ->leftjoin('barber_m', self::$main_table.'.barber_id', '=', 'barber_m.barber_m_id')
            ->leftjoin('customers', self::$main_table.'.barber_customer_id', '=', 'customers.customer_id')
            ->leftjoin('b_times as f', self::$main_table.'.start_time', '=', 'f.time_id')
            ->leftjoin('b_times as t', self::$main_table.'.end_time', '=', 't.time_id')
            ->orderBy(self::$main_table.'.barber_booking_date', 'desc')
            ->orderBy(self::$main_table.'.start_time')
            ->groupBy(self::$main_table.'.barber_booking_id');

        if($params['lang'] != null){
            $query->selectRaw('
                barber_booking_id as id ,'.
                self::$main_table.'.barber_id ,
                barber_m.name_'.$params['lang'].' as barber_name ,
                customers.name_'.$params['lang'].' as barber_customer_name ,
                customers.phone as barber_customer_mobile ,
                customers.notes as barber_customer_notes ,
                barber_booking_date ,
                barber_bookings.has_invoice ,
                TIME_FORMAT(f.time_title, "%h:%i %p") as start_time ,
                TIME_FORMAT(t.time_title, "%h:%i %p") as end_time ,'.
                self::$main_table.'.start_time as booking_start_time ,'.
                self::$main_table.'.end_time as booking_end_time ,'.
                self::$main_table.'.total_without_vat ,'.
                self::$main_table.'.total_vat ,'.
                self::$main_table.'.total_with_vat ,'.
                self::$main_table.'.barber_booking_status ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        if(isset($params['active_date']))
            $query->where(self::$main_table.'.barber_booking_date', $params['active_date']);

        if(isset($params['from_date'])){
            $query->where(self::$main_table.'.barber_booking_date', '>=', $params['from_date'].' 00:00:00');
        }

        if(isset($params['to_date'])){
            $query->where(self::$main_table.'.barber_booking_date', '<=', $params['to_date'].' 23:59:59');
        }

        if(isset($params['status'])){
            $query->where(self::$main_table.'.barber_booking_status', $params['status']);
        }

        if(isset($params['has_invoice'])){
            $query->where(self::$main_table.'.has_invoice', $params['has_invoice']);
        }

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('customers.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.phone', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_barber_booking($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->select(DB::raw("GROUP_CONCAT(distinct items.name_ar) as services_names"))
            ->leftjoin("items",\DB::raw("FIND_IN_SET(items.item_id,barber_bookings.services)"),">",\DB::raw("'0'"))
            ->leftjoin('barber_m', self::$main_table.'.barber_id', '=', 'barber_m.barber_m_id')
            ->leftjoin('customers', self::$main_table.'.barber_customer_id', '=', 'customers.customer_id')
            ->where('barber_booking_id', $id);

        if($lang != null){
            $query->selectRaw('
                barber_booking_id as id ,'.
                self::$main_table.'.services ,'.
                self::$main_table.'.barber_id ,
                barber_bookings.has_invoice ,
                barber_m.name_'.$lang.' as barber_name ,
                barber_m.image as barber_image ,
                customers.customer_id as barber_customer_id ,
                customers.name_'.$lang.' as barber_customer_name ,
                customers.phone as barber_customer_mobile ,
                customers.notes as barber_customer_notes ,'.
                self::$main_table.'.start_time as booking_start_time ,'.
                self::$main_table.'.end_time as booking_end_time ,'.
                self::$main_table.'.total_vat ,'.
                self::$main_table.'.total_without_vat ,'.
                self::$main_table.'.total_with_vat ,'.
                self::$main_table.'.barber_booking_status ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        $data = $query->first();
        return $data;
    }
}
