<?php

namespace App\Models\Purchases;

use Illuminate\Database\Eloquent\Model;
use DB;

class PurchasesAgent extends Model
{
    protected $primaryKey     = 'purchases_agent_id';
    public static $main_table = 'purchases_agents';
    public $table             = 'purchases_agents';

    public static $rules = array(
        'name_en' => 'required|string|unique:purchases_agents',
        'name_ar' => 'required|string|unique:purchases_agents',
    );

    public static function all_purchases_agents($params = null)
    {
        $query = DB::table(self::$main_table)
            ->orderBy(self::$main_table.'.purchases_agent_id', 'desc');

        if(isset($params['lang']))
            $query->selectRaw('
                purchases_agent_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.purchases_agent_status,'.
                self::$main_table.'.purchases_agent_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        if(isset($params['active']))
            $query->where('purchases_agent_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_purchases_agent($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('purchases_agent_id', $id);

        $query->selectRaw('
            purchases_agent_id as id ,'.
            self::$main_table.'.name_'.$lang.' as name ,'.
            self::$main_table.'.name_ar ,'.
            self::$main_table.'.name_en ,'.
            self::$main_table.'.purchases_agent_status,'.
            self::$main_table.'.purchases_agent_active,'.
            self::$main_table.'.add_date,'.
            self::$main_table.'.add_user
        ');

        $data = $query->first();
        return $data;
    }

    public static function add_purchases_agent($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_purchases_agent($seed, $id)
    {
        return DB::table(self::$main_table)->where('purchases_agent_id', $id)->update($seed);
    }

    public static function delete_purchases_agent($id)
    {
        return DB::table(self::$main_table)->where('purchases_agent_id', $id)->update(array('purchases_agent_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
