<?php

namespace App\Models\Purchases;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ReturnPurchases extends Model
{
    protected $primaryKey     = 'return_purchase_m_id';
    public static $main_table = 'return_purchases_m';
    public $table             = 'return_purchases_m';

    public static $master_rules = array(

    );

    public static $details_rules = array(
        'remaining_quantity' => 'required|numeric|min:0',
    );

    public static function all_return_purchases($params = null)
    {
        $query = DB::table(self::$main_table)
        ->leftJoin('purchases_invoice_m', 'return_purchases_m.purchase_invoice_m_id','purchases_invoice_m.purchases_invoice_m_id')
        ->leftJoin('purchases_vendors','purchases_invoice_m.purchases_vendor_id','purchases_vendors.purchases_vendor_id')
        ->leftjoin('daily_journal_m', 'return_purchases_m.daily_journal_m_id', 'daily_journal_m.daily_journal_m_id')

        ->orderBy(self::$main_table.'.return_purchase_m_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                return_purchases_m.return_purchase_m_id as m_id ,
                return_purchases_m.purchase_invoice_m_id ,
                purchases_invoice_m.purchases_vendor_id,
                purchases_vendors.name_'.$params['lang'].' as vendor_name,
                return_purchases_m.action_date ,
                return_purchases_m.branch_id ,
                return_purchases_m.finance_year_id ,
                return_purchases_m.daily_journal_m_id ,
                daily_journal_m.year_ser as journal_code ,
                return_purchases_m.returned_price ,
                return_purchases_m.returned_quantity,
                return_purchases_m.active,
                return_purchases_m.add_user ,
                return_purchases_m.add_date
            ');
        }

        if(isset($params['active']))
            $query->where('active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->Where('return_purchases_m.return_purchase_m_id', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_return_purchase_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
        ->leftJoin('purchases_invoice_m', 'return_purchases_m.purchase_invoice_m_id','purchases_invoice_m.purchases_invoice_m_id')
        ->leftJoin('purchases_vendors','purchases_invoice_m.purchases_vendor_id','purchases_vendors.purchases_vendor_id')
        ->leftjoin('daily_journal_m', 'return_purchases_m.daily_journal_m_id', 'daily_journal_m.daily_journal_m_id')
            ->where('return_purchase_m_id', $id);

            if($lang != null){
                $query->selectRaw('
                    return_purchases_m.return_purchase_m_id as m_id ,
                    return_purchases_m.purchase_invoice_m_id as m_id ,
                    purchases_invoice_m.purchases_vendor_id ,
                    purchases_vendors.account_tree_id as vendor_account_tree_id ,
                    purchases_vendors.name_'.$lang.' as vendor_name ,
                    return_purchases_m.description ,
                    return_purchases_m.action_date ,
                    return_purchases_m.branch_id ,
                    return_purchases_m.finance_year_id ,
                    return_purchases_m.daily_journal_m_id ,
                    return_purchases_m.active,
                    return_purchases_m.returned_price ,
                    return_purchases_m.returned_quantity,
                    return_purchases_m.add_user ,
                    return_purchases_m.add_date
                ');
            }

        $data = $query->first();
        return $data;
    }

    public static function get_return_purchases_d($id, $lang = null)
    {
        $query = DB::table('return_purchases_d')
            ->leftJoin('purchases_invoice_d', 'return_purchases_d.purchase_invoice_d_id','purchases_invoice_d.purchases_invoice_d_id')
            ->leftjoin('taxes' , 'purchases_invoice_d.tax_percent_id' , '=' , 'taxes.tax_id')
            ->leftjoin('warehouses' , 'return_purchases_d.warehouse_id' , 'warehouses.warehouse_id')
            ->leftjoin('items' , 'return_purchases_d.item_id' , 'items.item_id')
            // ->leftjoin('unit_measurements' , 'return_purchases_d.unit_id' , 'unit_measurements.unit_measurement_id')
            ->where('return_purchase_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                return_purchases_d.return_purchase_m_id  as m_id ,
                return_purchases_d.return_purchase_d_id  as d_id ,
                return_purchases_d.purchase_invoice_d_id ,
                return_purchases_d.warehouse_id ,
                warehouses.name_'.$lang.' as warehouse_name ,
                return_purchases_d.item_id ,
                items.name_'.$lang.' as item_name ,

                purchases_invoice_d.tax_percent_id ,
                taxes.name_'.$lang.' as tax_percent ,
                taxes.tax_percentage ,
                taxes.account_tree_id as tax_account_tree_id ,

                return_purchases_d.returned_quantity ,
                return_purchases_d.returned_price ,
                return_purchases_d.returned_vat ,
                return_purchases_d.returned_without_vat ,
                return_purchases_d.returned_with_vat ,
                return_purchases_d.remaining_quantity ,
                return_purchases_d.remaining_price

            ');
        }

        $data = $query->get();
        return $data;
    }



    public static function add_return_purchase_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_return_purchase_d($seed)
    {
        return DB::table('return_purchases_d')->insertGetId($seed);
    }

    public static function update_return_purchase_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('return_purchase_m_id', $id)->update($seed);
    }

    public static function update_return_purchase_d($seed, $id)
    {
        return DB::table('return_purchases_d')->where('return_purchase_d_id', $id)->update($seed);
    }

    public static function delete_return_purchase_m($id)
    {
        return DB::table(self::$main_table)->where('return_purchase_m_id', $id)->update(array('active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_return_purchase_d($id)
    {
        return DB::table('return_purchases_d')->where('return_purchase_d_id', $id)->delete();
    }
}
