<?php

namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;

use DB;

class Customer extends Authenticatable
{
    protected $primaryKey     = 'customer_id';
    public static $main_table = 'customers';
    public $table             = 'customers';

    public static $rules = array(
        'name_en'                  => 'required|string|unique:customers',
        'name_ar'                  => 'required|string|unique:customers',
        // 'first_term_balance'          => 'required|numeric' ,
        // 'balance_nature'              => 'required' ,

        //        'address'                     => 'required|string' ,
        //        'sales_area_id'               => 'required|numeric' ,
        //        'commercial_registeration_no' => 'required|numeric' ,
        //        'vat_register_number'         => 'required|numeric' ,
        //        'default_currency_id'         => 'required|numeric' ,
        //        'customer_behaviour_type'     => 'required|numeric' ,
        //        'sales_agent_id'              => 'required|numeric' ,
        //        'maximum_term_value'          => 'required|numeric' ,
        //        'term_period'                 => 'required|numeric' ,
        //        'customer_type_id'            => 'required|numeric' ,
        //        'account_tree_id'             => 'required|numeric' ,
        //        'phone'                       => 'required|string' ,
    );

    public static function all_customers($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('account_tree', self::$main_table . '.account_tree_id', '=', 'account_tree.account_tree_id')

            ->leftjoin('sales_areas', self::$main_table . '.sales_area_id', '=', 'sales_areas.sales_area_id')
            ->leftjoin('sales_agents', self::$main_table . '.sales_agent_id', '=', 'sales_agents.sales_agent_id')
            ->leftjoin('customer_types', self::$main_table . '.customer_type_id', '=', 'customer_types.customer_type_id')
            ->leftjoin('currencys', self::$main_table . '.default_currency_id', '=', 'currencys.currency_id')
            ->leftjoin('customer_contacts', self::$main_table . '.customer_id', '=', 'customer_contacts.customer_id')
            ->groupBy(self::$main_table . '.customer_id')
            ->orderBy(self::$main_table . '.customer_id', 'desc');

        if (isset($params['lang'])) {
            $query->selectRaw(
                self::$main_table . '.customer_id as id ,' .
                    self::$main_table . '.name_ar ,' .
                    self::$main_table . '.name_en ,' .
                    self::$main_table . '.account_tree_id ,
                account_tree.name_' . $params['lang'] . ' as account_name ,
                customer_invoice_type ,
                commercial_registeration_no ,
                check_balance ,


                vat_register_number ,' .
                    self::$main_table . '.address ,' .
                    self::$main_table . '.phone ,' .
                    self::$main_table . '.job_title ,' .
                    self::$main_table . '.sales_area_id ,
                first_term_balance ,
                balance_nature ,
                sales_areas.name_' . $params['lang'] . ' as sales_area_name ,
                default_currency_id ,
                currencys.name_' . $params['lang'] . ' as default_currency_name ,
                customer_behaviour_type ,
                maximum_term_value ,
                term_period,' .
                    self::$main_table . '.sales_agent_id ,
                sales_agents.name_' . $params['lang'] . ' as sales_agent_name ,' .
                    self::$main_table . '.customer_type_id ,
                customer_types.name_' . $params['lang'] . ' as customer_type_name ,' .
                    self::$main_table . '.notes,' .
                    self::$main_table . '.customer_status,' .
                    self::$main_table . '.customer_active,' .
                    self::$main_table . '.add_date,' .
                    self::$main_table . '.add_user
            '
            );
            if (isset($params['is_search'])) {
                // $query->selectRaw('ifnull( concat(customers.name_'.$params['lang'].', " - " , customer_types.name_'.$params['lang'].' ) , customers.name_'.$params['lang'].') as name');
                $query->selectRaw('ifnull( concat(customers.name_' . $params['lang'] . ', " - " , customers.customer_id ) , customers.name_' . $params['lang'] . ') as name');
            } else {
                $query->selectRaw(self::$main_table . '.name_' . $params['lang'] . ' as name');
            }
        }


        if (isset($params['active']))
            $query->where(self::$main_table . '.customer_active', $params['active']);

        if (isset($params['type']))
            $query->where(self::$main_table . '.customer_type_id', $params['type']);

        if (isset($params['word']) && strlen($params['word']) > 0) {
            $query->where(function ($stmt) use ($params) {
                $word = $params['word'];
                $stmt->where(function ($q) use ($word) {
                    $q->where(self::$main_table . '.name_en', 'LIKE', "%{$word}%")
                        ->orWhere(self::$main_table . '.name_ar', 'LIKE', "%{$word}%")
                        ->orWhere(self::$main_table . '.phone', 'LIKE', "%{$word}%")
                        ->orWhere(self::$main_table . '.name_en', $word)
                        ->orWhere(self::$main_table . '.name_ar', $word)
                        ->orWhere(self::$main_table . '.phone', $word)

                        ->orWhere('customer_contacts.phone', $word);
                });

            });
        }

        if (isset($params['id']) && strlen($params['id']) > 0) {
            $query->where(function ($stmt) use ($params) {
                $stmt->where(self::$main_table . '.customer_id', $params['id'])
                    ->orWhere('customer_contacts.customer_id', $params['id']);
            });
        }

        if (isset($params['rows'])) {
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        } else {
            $data = $query->get();
        }

        return $data;
    }

    public static function get_customer($id, $lang = null)
    {
        $query = DB::table(self::$main_table)

            ->leftjoin('account_tree', self::$main_table . '.account_tree_id', '=', 'account_tree.account_tree_id')
            ->leftjoin('sales_areas', self::$main_table . '.sales_area_id', '=', 'sales_areas.sales_area_id')
            ->leftjoin('sales_agents', self::$main_table . '.sales_agent_id', '=', 'sales_agents.sales_agent_id')
            ->leftjoin('customer_types', self::$main_table . '.customer_type_id', '=', 'customer_types.customer_type_id')
            ->leftjoin('currencys', self::$main_table . '.default_currency_id', '=', 'currencys.currency_id')
            ->where('customers.customer_id', $id);

        $query->selectRaw('
            customers.customer_id as id ,' .
            self::$main_table . '.name_' . $lang . ' as name ,' .
            self::$main_table . '.name_ar ,' .
            self::$main_table . '.name_en ,' .
            self::$main_table . '.account_tree_id ,
            account_tree.name_' . $lang . ' as account_name ,
            customer_invoice_type ,
            commercial_registeration_no ,
            check_balance ,

            vat_register_number ,' .
            self::$main_table . '.address ,' .
            self::$main_table . '.phone ,' .
            self::$main_table . '.job_title ,' .
            self::$main_table . '.sales_area_id ,
            first_term_balance ,
            balance_nature ,
            sales_areas.name_' . $lang . ' as sales_area_name ,
            default_currency_id ,
            currencys.name_' . $lang . ' as default_currency_name ,
            currencys.big_sign_' . $lang . ' as big_sign ,
            currencys.small_sign_' . $lang . ' as small_sign ,
            big_sign_en as currency_code ,
            customer_behaviour_type ,
            maximum_term_value ,
            term_period,' .
            self::$main_table . '.sales_agent_id ,
            sales_agents.name_' . $lang . ' as sales_agent_name ,' .
            self::$main_table . '.customer_type_id ,
            customer_types.name_' . $lang . ' as customer_type_name ,' .
            self::$main_table . '.notes,' .
            self::$main_table . '.customer_status,' .
            self::$main_table . '.customer_active,' .
            self::$main_table . '.add_date,' .
            self::$main_table . '.wallet_points,' .
            self::$main_table . '.gift_total_invoices,' .
            self::$main_table . '.add_user
        ');

        $data = $query->first();
        return $data;
    }

    public static function get_customer_attachments($id)
    {
        return DB::table('customer_attachments')
            ->where('customer_id', $id)
            ->where('customer_attachment_active', 1)
            ->selectRaw('
                customer_attachment_id  as id ,
                customer_id ,
                file_name ,
                file_path ,
                file_extension ,
                add_date ,
                add_user
        ')->get();
    }

    public static function get_customer_contacts($id)
    {
        return DB::table('customer_contacts')
            ->select('customer_contact_id as id', 'customer_id', 'name', 'phone')
            ->where('customer_id', $id)
            ->get();
    }

    public static function add_customer($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_customer($seed, $id)
    {
        return DB::table(self::$main_table)->where('customer_id', $id)->update($seed);
    }

    public static function delete_customer($id)
    {
        return DB::table(self::$main_table)->where('customer_id', $id)->update(array('customer_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_customer_attachment($id)
    {
        return DB::table('customer_attachments')->where('customer_attachment_id', $id)->update(array('customer_attachment_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}