<?php

namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use DB;

class CustomerType extends Model
{
    protected $primaryKey     = 'customer_type_id';
    public static $main_table = 'customer_types';
    public $table             = 'customer_types';

    public static $rules = array(
        'name_en'       => 'required|string|unique:customer_types',
        'name_ar'       => 'required|string|unique:customer_types',
        'discount_rate' => 'required|numeric',
    );

    public static function all_customer_types($params = null)
    {
        $query = DB::table(self::$main_table)
            ->orderBy(self::$main_table.'.customer_type_id', 'desc');

        if(isset($params['lang']))
            $query->selectRaw('
                customer_type_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.discount_rate,'.
                self::$main_table.'.customer_type_status,'.
                self::$main_table.'.customer_type_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        if(isset($params['active']))
            $query->where('customer_type_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('name_en', 'LIKE' , "%{$params['word']}%")
                    ->orWhere('name_ar', 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_customer_type($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('customer_type_id', $id);

        $query->selectRaw('
            customer_type_id as id ,'.
            self::$main_table.'.name_'.$lang.' as name ,'.
            self::$main_table.'.name_ar ,'.
            self::$main_table.'.name_en ,'.
            self::$main_table.'.discount_rate,'.
            self::$main_table.'.customer_type_status,'.
            self::$main_table.'.customer_type_active,'.
            self::$main_table.'.add_date,'.
            self::$main_table.'.add_user
        ');

        $data = $query->first();
        return $data;
    }

    public static function add_customer_type($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_customer_type($seed, $id)
    {
        return DB::table(self::$main_table)->where('customer_type_id', $id)->update($seed);
    }

    public static function delete_customer_type($id)
    {
        return DB::table(self::$main_table)->where('customer_type_id', $id)->update(array('customer_type_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
