<?php

namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ProformaInvoice extends Model
{
    protected $primaryKey     = 'proforma_invoice_m_id';
    public static $main_table = 'proforma_invoice_m';
    public $table             = 'proforma_invoice_m';

    public static $master_rules = array(
//        'quotation_id'                 => 'required|numeric',
        'purchase_order_id'            => 'required',
        'proforma_invoice_date'        => 'required|date',
//        'proforma_invoice_description' => 'required',
        'customer_id'                  => 'required|numeric',
        'sales_agent_id'               => 'required|numeric',
    );

    public static $details_rules = array(
        'item_id'        => 'required|numeric',
        'warehouse_id'   => 'required|numeric',
        'unit_id'        => 'required|numeric',
        'quantity'       => 'required|numeric',
        'price'          => 'required',
        'tax_percent_id' => 'required|numeric',
    );

    public static function all_proforma_invoices($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('customers' , self::$main_table.'.customer_id' , '=' , 'customers.customer_id')
            ->leftjoin('sales_agents' , self::$main_table.'.sales_agent_id' , '=' , 'sales_agents.sales_agent_id')
            ->orderBy(self::$main_table.'.proforma_invoice_m_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                proforma_invoice_m_id as m_id ,
                quotation_id ,
                purchase_order_id ,
                proforma_invoice_date ,
                proforma_invoice_description ,'.
                self::$main_table.'.customer_id ,
                customers.name_'.$params['lang'].' as customer_name ,'.
                self::$main_table.'.sales_agent_id ,
                sales_agents.name_'.$params['lang'].' as sales_agent_name ,
                concat(proforma_invoice_m_id , " - " , customers.name_'.$params['lang'].' , " - " ,  total_with_vat ) as full_string ,
                branch_id ,
                finance_year_id ,
                invoice_discount ,
                if(invoice_discount = "1", true, false ) as has_discount ,
                discount_type ,
                discount ,
                proforma_invoice_status ,
                proforma_invoice_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                total_discount ,
                total_price_after_discount
            ');
        }

        if(isset($params['active']))
            $query->where('proforma_invoice_active', $params['active']);

        if(isset($params['status']))
            $query->where('proforma_invoice_status', $params['status']);

        if(isset($params['from']))
            $query->where('proforma_invoice_date', '>=' , $params['from']);

        if(isset($params['to']))
            $query->where('proforma_invoice_date', '<='  , $params['to']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('proforma_invoice_description', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('proforma_invoice_m_id', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere('sales_agents.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('sales_agents.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.quotation_id', 'LIKE', "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.purchase_order_id', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_proforma_invoice_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('customers' , self::$main_table.'.customer_id' , '=' , 'customers.customer_id')
            ->leftjoin('sales_agents' , self::$main_table.'.sales_agent_id' , '=' , 'sales_agents.sales_agent_id');
            if(is_array($id)){
                $query->whereIn('proforma_invoice_m_id' , $id);
            }else{
                $query->where('proforma_invoice_m_id' , $id);
            }


        if($lang != null){
            $query->selectRaw('
                proforma_invoice_m_id as m_id ,
                quotation_id ,
                purchase_order_id ,
                proforma_invoice_date ,
                proforma_invoice_description ,'.
                self::$main_table.'.customer_id ,
                customers.name_'.$lang.' as customer_name ,'.
                self::$main_table.'.sales_agent_id ,
                sales_agents.name_'.$lang.' as sales_agent_name ,
                branch_id ,
                finance_year_id ,
                extra_inputs ,
                invoice_discount ,
                if(invoice_discount = "1", true, false ) as has_discount ,
                discount_type ,
                discount ,
                proforma_invoice_status ,
                proforma_invoice_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                total_discount ,
                total_price_after_discount
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_proforma_invoice_d($id, $lang = null)
    {
        $query = DB::table('proforma_invoice_d')
            ->leftjoin('items' , 'proforma_invoice_d.item_id' , '=' , 'items.item_id')
            ->leftjoin('warehouses' , 'proforma_invoice_d.warehouse_id' , '=' , 'warehouses.warehouse_id')
            ->leftjoin('unit_measurements' , 'proforma_invoice_d.unit_id' , '=' , 'unit_measurements.unit_measurement_id')
            ->leftjoin('taxes' , 'proforma_invoice_d.tax_percent_id' , '=' , 'taxes.tax_id')
            ->where('proforma_invoice_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                proforma_invoice_m_id as m_id ,
                proforma_invoice_d_id as d_id ,
                proforma_invoice_d.item_id ,
                items.name_'.$lang.' as item_name ,
                items.image as item_image ,
                items.price_include_vat as price_include_vat ,
                items.item_width_height ,
                items.category_id ,
                proforma_invoice_d.warehouse_id ,
                warehouses.name_'.$lang.' as warehouse_name ,
                proforma_invoice_d.unit_id ,
                unit_measurements.name_'.$lang.' as unit_name ,
                extra_inputs ,

                width ,
                height ,

                area_width ,
                area_height ,
                area_quantity ,
                quantity ,
                proforma_invoice_d.description ,
                proforma_invoice_d.price ,
                proforma_invoice_d.item_price ,
                proforma_invoice_d.total_price ,
                proforma_invoice_d.currency_id ,
                proforma_invoice_d.foreign_currency ,
                proforma_invoice_d.equivalent_value ,

                proforma_invoice_d.item_discount ,
                proforma_invoice_d.total_discount ,

                discount ,
                discount_per ,
                tax_percent_id ,
                taxes.tax_percentage as tax_percent ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                proforma_invoice_d.delivered_quantity ,
                proforma_invoice_d.remaining_quantity
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function get_proforma_invoice_files($id)
    {
        return DB::table('proforma_invoice_files')
            ->where('proforma_invoice_m_id', $id)
            ->get();
    }

    public static function add_proforma_invoice_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_proforma_invoice_d($seed)
    {
        return DB::table('proforma_invoice_d')->insertGetId($seed);
    }

    public static function update_proforma_invoice_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('proforma_invoice_m_id', $id)->update($seed);
    }

    public static function delete_proforma_invoice_m($id)
    {
        return DB::table(self::$main_table)->where('proforma_invoice_m_id', $id)->update(array('proforma_invoice_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_proforma_invoice_d($id)
    {
        return DB::table('proforma_invoice_d')->where('proforma_invoice_m_id', $id)->delete();
    }
}
