<?php

namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use DB;

class Shift extends Model
{
    protected $primaryKey     = 'shift_id';
    public static $main_table = 'shifts';
    public $table             = 'shifts';

    public static $rules = array(
        'name_en'       => 'required|string',
        'name_ar'       => 'required|string',
        'discount_rate' => 'required|numeric',
    );

    public static function all_shifts($params = null)
    {
        $query = DB::table(self::$main_table)
            ->orderBy('shift_id' , 'desc');

        if(isset($params['lang'])){

            $query
                ->join('users' , 'shifts.user_id' , '=' , 'users.id')
                ->join('branchs' , 'shifts.branch_id' , '=' , 'branchs.branch_id')
                ->selectRaw('
                    shift_id as id , 
                    shifts.user_id , 
                    users.user_full_name ,
                    shifts.branch_id ,
                    branchs.name_'.$params['lang'].' as branch_name ,
                    start_cash ,
                    total_nc ,
                    total_nd ,
                    total_expenses ,
                    total_cash ,
                    total_sales,
                    total_sales_cash ,
                    total_sales_master ,
                    total_sales_visa ,
                    total_sales_mada ,
                    total_sales_other ,
                    end_cash ,
                    end_master ,
                    end_visa ,
                    end_mada ,
                    end_other ,
                    diff_cash ,
                    diff_master ,
                    diff_visa ,
                    diff_mada ,
                    diff_other ,
                    total_diff ,
                    start_date ,
                    end_date 
                ');
        }






        if(isset($params['from']))
            $query->where('start_date', '>=' , $params['from']." 00:00:00");

        if(isset($params['to']))
            $query->where('end_date', '<=' , $params['to']." 23:59:59");

        if(isset($params['user']))
            $query->where('shifts.user_id', $params['user']);

        if(isset($params['branch']))
            $query->where('shifts.branch_id', $params['branch']);

  
        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_shift($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('shift_id', $id);

        if(isset($lang)){

            $query
                ->join('users' , 'shifts.user_id' , '=' , 'users.id')
                ->join('branchs' , 'shifts.branch_id' , '=' , 'branchs.branch_id')
                ->selectRaw('
                    shift_id as id , 
                    shifts.user_id , 
                    users.user_full_name ,
                    shifts.branch_id ,
                    branchs.name_'.$lang.' as branch_name ,
                    start_cash ,
                    total_nc ,
                    total_nd ,
                    total_expenses ,
                    total_cash ,
                    total_sales ,
                    total_sales_cash ,
                    total_sales_master ,
                    total_sales_visa ,
                    total_sales_mada ,
                    total_sales_other ,
                    end_cash ,
                    end_master ,
                    end_visa ,
                    end_mada ,
                    end_other ,
                    diff_cash ,
                    diff_master ,
                    diff_visa ,
                    diff_mada ,
                    diff_other ,
                    total_diff ,
                    start_date ,
                    end_date 
                ');
        }

        $data = $query->first();
        return $data;
    }

    public static function add_shift($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_shift($seed, $id)
    {
        return DB::table(self::$main_table)->where('shift_id', $id)->update($seed);
    }

    public static function delete_shift($id)
    {
        return DB::table(self::$main_table)->where('shift_id', $id)->update(array('shift_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
