<?php

namespace App\Classes\Finance;
use DB;



class CostCenterHelper {

	function get_next_cost_center($id){


	    if($id != 0 ){
	    	$parent 	= DB::table('cost_center')->where('cost_center_id' , $id )->first();
		}else{
			$parent = (object) array(
				'account_type' 	=> 1 , 
				'cost_center_code' 	=> '' , 
				'level_chars'	=> 1 ,
				'account_nature'=> 1
			);
		}



	    if($parent->account_type != '1'){
	        return array('check' => 0 , 'msg' => "Can't add on this account" ) ;
	    }
	    $max 			= intval($parent->level_chars);
	    $childrens 		= DB::table('cost_center')->where('parent_id' , $id )->orderBy('cost_center_id' , 'desc')->first();
	    $new_code 		= intval( substr($childrens->cost_center_code ?? '0' , strlen($parent->cost_center_code)) ) + 1 ;
	    if(strlen($new_code) > $max ){
	        return array('check' => 0 , 'msg' => "Can't add more" ) ;
	    }
	    $new_code 		= $parent->cost_center_code.$new_code;
	    return array('check' => 1 , 'new_code' => $new_code , 'account_nature' => $parent->account_nature ?? 0 ) ;

	}


	function can_edit_or_delete($id)
	{
		
	    $account 	= DB::table('cost_center')->where('cost_center_id' , $id )->first();

        if( $account->account_type == 1 ){

            $children = DB::table('cost_center')->where('parent_id' , $id )->orderBy('cost_center_id' , 'desc')->count();
            if($children > 0){
                return false;
            }

        }else{

			$check = DB::table('daily_journal_d')->where('cost_center_id' , $id)->count();
            if($check > 0)
				return false;
           
        }

		return true;
	}

}