<?php

namespace App\Classes;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class ItemStock
{
    protected $return = array();
    protected $filter = array();

    // actions sources
    public const Sales_source = 'sa';                // Sales
    public const purchases_source = 'pu';            // Purchases
    public const transfer_from_source = 'tf';        // Transfer From
    public const transfer_to_source = 'tt';          // Transfer To
    public const Return_Purchases_source = 'rp';     // Purchases Return
    public const notice_debitor_source = 'nd';       // Notice Debitor
    public const notice_creditor_source = 'nc';      // Notice Creditor
    public const First_Stocktaking_source = 'fst';   // First Stocktaking
    public const Stocktaking_source = 'st';          // Stocktaking
    public const Delivery_Note_source = 'dn';       // Delivery Order (for sales)
    public const Purchases_Note_source        = 'pn';      // Receiving Order (for purchases) 

    public const Incoming_source              = 'in';   // Incoming  +
    public const Outcoming_source             = 'out';  // Outcoming  - 
    public const Stock_Difference_source      = 'sd';   // Stock Difference  +
    public const Gift_Samples_source          = 'gs';   // Gift & Samples  -
    public const Damage_source                = 'dm';   // Damage  - 
    public const Warehouse_transaction_source = 'wt';   // Warehouse Transaction ( + or - based on type )  

    // actions do update full stock
    public const UPDATE_SOURCES = [
        self::First_Stocktaking_source,
        self::Stocktaking_source,
    ];

    // actions increase stock
    public const INCREMENT_SOURCES = [
        self::purchases_source,
        self::transfer_to_source,
        self::Incoming_source,
        self::Stock_Difference_source,
        self::notice_creditor_source,
        self::Purchases_Note_source,
    ];

    // actions decrease stock
    public const DECREMENT_SOURCES = [
        self::Sales_source,
        self::Return_Purchases_source,
        self::transfer_from_source,
        self::Outcoming_source,
        self::Gift_Samples_source,
        self::Damage_source,
        self::notice_debitor_source,
        self::Delivery_Note_source,
    ];

    // actions allowed to create new stock record if not exists
    public const CREATE_IF_NOT_EXISTS = [
        self::First_Stocktaking_source,
        self::Stocktaking_source,
        self::purchases_source,
        self::transfer_to_source,
        self::notice_debitor_source
    ];

    public function get_item_stock($params)
    {
        $params['lang'] = $params['lang'] ?? 'en';
        $query = DB::table('items')
            ->leftjoin('stocks', 'stocks.item_id', '=', 'items.item_id')
            ->leftjoin('warehouses', 'stocks.warehouse_id', '=', 'warehouses.warehouse_id')
            ->where('items.item_active', 1)
            ->selectRaw('
	        	IFNULL(stocks.stock_id, 0) as stock_id ,
	        	IFNULL(stocks.branch_id, 0) as branch_id ,
	        	warehouses.warehouse_id ,
                items.sale_price ,
                items.min_sale_price ,
	        	items.item_id ,
	        	items.default_report_unit_type ,
	        	IFNULL(stocks.stock, 0) as stock ,
	        	IFNULL(stocks.stock / small_unit_coefficient, 0) as stock_in_small ,
	        	IFNULL(stocks.stock / mid_unit_coefficient, 0) as stock_in_mid ,
	        	IFNULL(stocks.stock / (mid_unit_coefficient * big_unit_coefficient), 0) as stock_in_big ,
	        	IFNULL(stocks.purchase_cost, 0) as purchase_cost ,
	        	items.name_' . $params['lang'] . ' as item_name ,
	        	warehouses.name_' . $params['lang'] . ' as warehouse_name ,
                (CASE WHEN (items.default_report_unit_type = 1) THEN items.small_unit_id WHEN (items.default_report_unit_type = 2) THEN items.mid_unit_id ELSE items.small_unit_id END) as unit_id ,
                (stocks.stock * (items.min_sale_price)) as balance_in_small ,
                ((stocks.stock / (items.mid_unit_coefficient)) * items.sale_price) as balance_in_mid ,
                ((stocks.stock / (items.mid_unit_coefficient * items.big_unit_coefficient)) * items.sale_price) as balance_in_big ,
                items.small_unit_id ,
                items.mid_unit_id ,
                items.big_unit_id
	        ');

        if (isset($params['warehouse_id']) && is_array($params['warehouse_id']) && count($params['warehouse_id']) > 0) {
            $query->whereIn('stocks.warehouse_id', $params['warehouse_id']);
        } elseif (isset($params['warehouse_id']) && !is_array($params['warehouse_id'])) {
            $query->where('stocks.warehouse_id', $params['warehouse_id']);
        } elseif (!empty($params['warehouse']) && !is_array($params['warehouse'])) {

            $query->where('stocks.warehouse_id', $params['warehouse']);
        }


        if (isset($params['item_id']) && is_array($params['item_id']) && count($params['item_id']) > 0) {
            $query->whereIn('stocks.item_id', $params['item_id']);
        } elseif (isset($params['item_id']) && !is_array($params['item_id'])) {
            $query->where('stocks.item_id', $params['item_id']);
        }

        if (isset($params['qty_min'])) {
            $query->where('stocks.stock', '>=', $params['qty_min']);
        }

        if (isset($params['qty_max'])) {
            $query->where('stocks.stock', '>=', $params['qty_max']);
        }

        if (isset($params['from_date'])) {
            $query->where('stocks.add_date', '>=', $params['from_date'] . ' 00:00:00');
        }

        if (isset($params['to_date'])) {
            $query->where('stocks.add_date', '<=', $params['to_date'] . ' 23:59:59');
        }

        return $query->orderBy('items.item_id')->get();
    }

    public function update_item_stock($branch, $item, $warehouse, $source, $source_m_id, $source_d_id, $qty, $diffrance, $unit_id, $unit_type, $purchase_cost = 0)
    {
        $theItem = DB::table('items')->where('item_id', $item)->first();
        if ($qty == 0 || !$theItem || $theItem->is_service == 1) {
            return false;
        }

        $convert_rate = 1;

        if (in_array($unit_type, [2, 3])) {
            if ($unit_type == 2) {
                $convert_rate = $theItem->mid_unit_coefficient;
            } elseif ($unit_type == 3) {
                $convert_rate = $theItem->big_unit_coefficient * $theItem->mid_unit_coefficient;
            }
        }

        $finalStock      = $qty * $convert_rate;
        $stockForLogs    = $finalStock;
        $source_quantity = $qty;

        if ($source == self::Stocktaking_source) {
            if ($diffrance == 0) {
                return false;
            }
            $stockForLogs = $diffrance;
        }

        if (in_array($source, self::DECREMENT_SOURCES)) {
            $stockForLogs = -abs($qty);
        }

        DB::table('stock_logs')->insert([
            'branch_id'       => $branch,
            'item_id'         => $item,
            'warehouse_id'    => $warehouse,
            'purchase_cost'   => $purchase_cost,
            'stock'           => $stockForLogs,
            'source'          => $source,
            'source_m_id'     => $source_m_id,
            'source_d_id'     => $source_d_id,
            'source_quantity' => $source_quantity,
            'unit_id'         => $unit_id,
            'unit_type'       => $unit_type,
            'add_user'        => auth()->id(),
        ]);

        $query = DB::table('stocks')
            ->where('item_id', $item)
            ->where('warehouse_id', $warehouse)
            ->where('branch_id', $branch);

        if (in_array($source, self::CREATE_IF_NOT_EXISTS)) {
            $check = DB::table('stocks')->where('item_id', $item)->first();
            if (!$check) {
                DB::table('stocks')->insert([
                    'branch_id'     => $branch,
                    'item_id'       => $item,
                    'warehouse_id'  => $warehouse,
                    'purchase_cost' => $purchase_cost,
                    'stock'         => $finalStock,
                ]);
                return true;
            }
        }

        if (in_array($source, self::UPDATE_SOURCES)) {
            $query->update([
                'stock'         => $finalStock,
                'purchase_cost' => $purchase_cost,
            ]);
        }

        if (in_array($source, self::INCREMENT_SOURCES)) {
            $query->increment('stock', $finalStock);
        }

        if (in_array($source, self::DECREMENT_SOURCES)) {
            $query->decrement('stock', $finalStock);
        }

        if ($source === self::Warehouse_transaction_source) {
            // if number is positive 
            if ($finalStock > 0) {
                $query->increment('stock', $finalStock);
            } elseif ($finalStock < 0) {
                $query->decrement('stock', abs($finalStock));
            }
        }


        return true;
    }


    public function get_item_stock_logs($params)
    {
        $query = DB::table('stock_logs')
            ->leftjoin('items', 'stock_logs.item_id', '=', 'items.item_id')
            ->leftjoin('warehouses', 'stock_logs.warehouse_id', '=', 'warehouses.warehouse_id')
            ->leftjoin('unit_measurements', 'stock_logs.unit_id', '=', 'unit_measurements.unit_measurement_id')
            ->selectRaw('
                IFNULL(stock_logs.stock_log_id, 0) as id ,

                stock_logs.item_id ,
                items.name_' . $params['lang'] . ' as item_name ,

                stock_logs.warehouse_id ,
                warehouses.name_' . $params['lang'] . ' as warehouse_name ,

                stock_logs.unit_id ,
                unit_measurements.name_' . $params['lang'] . ' as unit_name ,

                stock_logs.unit_type ,
                stock_logs.source ,
                stock_logs.source_m_id ,
                stock_logs.source_d_id ,

                IFNULL(stock_logs.source_quantity, 0) as source_quantity ,
                IFNULL(stock_logs.stock, 0) as stock_in_small ,
                IFNULL(stock_logs.purchase_cost, 0) as purchase_cost ,

                IFNULL(stock_logs.stock, 0) as stock ,
                IFNULL(stock_logs.stock * items.sale_price, 0) as value

	        ');

        if (isset($params['branch_id'])) {
            $query->where('stock_logs.branch_id', $params['branch_id']);
        }

        if (isset($params['item_id'])) {
            $query->where('stock_logs.item_id', $params['item_id']);
        }

        if (isset($params['warehouse_id'])) {
            $query->where('stock_logs.warehouse_id', $params['warehouse_id']);
        }

        if (isset($params['before'])) {
            $query->where('stock_logs.add_date', '<', $params['before'] . ' 00:00:00');
        }

        if (isset($params['from_date'])) {
            $query->where('stock_logs.add_date', '>=', $params['from_date'] . ' 00:00:00');
        }

        if (isset($params['to_date'])) {
            $query->where('stock_logs.add_date', '<=', $params['to_date'] . ' 23:59:59');
        }

        if (isset($params['stock_in'])) {
            $query->where('stock_logs.stock', '>', 0);
        }

        if (isset($params['stock_out'])) {
            $query->where('stock_logs.stock', '<', 0);
        }

        if (isset($params['source'])) {
            $query->where('stock_logs.source', $params['source']);
        }

        if (isset($params['source_m_id'])) {
            $query->where('stock_logs.source_m_id', $params['source_m_id']);
        }

        if (isset($params['source_d_id'])) {
            $query->where('stock_logs.source_d_id', $params['source_d_id']);
        }

        if (isset($params['unit_id'])) {
            $query->where('stock_logs.unit_id', $params['unit_id']);
        }

        if (isset($params['unit_type'])) {
            $query->where('stock_logs.unit_type', $params['unit_type']);
        }

        if (isset($params['group_item'])) {
            $query->groupBy('stock_logs.item_id');
        }

        if (isset($params['count'])) {
            $query->take(intval($params['count']));
        }

        $data = $query->get();
        return $data;
    }
}
