<?php

namespace App\Classes\Purchases;
use App\Models\Purchases\PurchasesInvoice;
use App\Classes\Finance\DailyJournalHelper;
use App\Models\Main\Setting;
use App\Models\Finance\DailyJournal;
use DB;

class PurchasesInvoiceHelper
{
    function get_next_codes($date, $year, $branch)
    {
        $data['year_ser'] = intval(DB::table('purchases_invoice_m')
                ->where('finance_year_id', $year)
                ->max('year_ser')) + 1;

        $data['month_ser'] = intval(DB::table('purchases_invoice_m')
                ->where('finance_year_id', $year)
                ->max('month_ser')) + 1;

        $data['branch_ser'] = intval(DB::table('purchases_invoice_m')
                ->where('branch_id', $branch)
                ->max('branch_ser')) + 1;

        return $data;
    }

    function can_edit_or_delete($id)
    {
        return true;
    }

    function update_master_values($id)
    {
        $totals = DB::table('purchases_invoice_m')
            ->where('purchases_invoice_m.purchases_invoice_m_id', $id)
            ->join('purchases_invoice_d', 'purchases_invoice_m.purchases_invoice_m_id', '=', 'purchases_invoice_d.purchases_invoice_m_id')
            ->select('purchases_invoice_m.purchases_invoice_m_id',
                DB::raw('SUM(purchases_invoice_d.total_vat) as total_vat'),
                DB::raw('SUM(purchases_invoice_d.total_without_vat) as total_without_vat'),
                DB::raw('SUM(purchases_invoice_d.total_with_vat) as total_with_vat'))
            ->groupBy('purchases_invoice_m.purchases_invoice_m_id')
            ->first();

        return DB::table('purchases_invoice_m')
            ->where('purchases_invoice_m.purchases_invoice_m_id', $id)
            ->update([
                'total_vat'                 => $totals->total_vat,
                'total_without_vat'         => $totals->total_without_vat,
                'total_with_vat'            => $totals->total_with_vat,
                'current_total_vat'         => $totals->total_vat,
                'current_total_without_vat' => $totals->total_without_vat,
                'current_total_with_vat'    => $totals->total_with_vat,
            ]);
    }

    function generate_daily_journal($id)
    {
        $check = Setting::get_main_setting_by_code('purchase_journal')->value ?? false ;
        if(!$check){
            return array( true ,  '' ) ;
        }

        $main       = PurchasesInvoice::get_purchases_invoice_m( $id ,'en' );
        $details    = PurchasesInvoice::get_purchases_invoice_d( $id ,'en' );
        $tax_id     = Setting::get_main_setting_by_code('default_purchases_vat')->value ?? false ;
        $tax        = DB::table('taxes')->where('tax_id' , $tax_id)->first();

        if(!isset($main->purchases_invoice_active) || $main->purchases_invoice_active == 0 ){
            DailyJournal::delete_daily_journal_m($main->daily_journal_m_id);
            return array( true ,  '' ) ;
        }

        $items      = [];
        $journal_data  = array(
            'finance_year_id'   => $main->finance_year_id  ,
            'branch_id'         => $main->branch_id ,
            'des'               => $main->purchases_invoice_description ,
            'journal_date'      => $main->purchases_invoice_date ,
            'document_id'       => $id ,
            'daily_type_id'     => 21 ,
            'auto_generated'    => 1 ,
            'journal_active'    => 1 ,
            'confirmed'         => 1
        );

        if($main->daily_journal_m_id > 0 ){
            $journal_data['daily_journal_id'] = $main->daily_journal_m_id;
        }


         $items[]   = array(
            'account_tree_id'   => $main->purchase_vendor_account_tree_id ,
            'cost_center_id'    => 0 ,
            'debit'             => 0   ,
            'credit'            => $main->total_with_vat ,
            'description'       => $main->purchases_invoice_description
        );

        foreach ( $details as $key => $detail ) {

            $items[]    = array(
                'account_tree_id'   => $detail->purchases_revenue_id ?? 0 ,
                'cost_center_id'    => 0 ,
                'debit'             => $detail->total_without_vat  ,
                'credit'            => 0,
                'description'       => $main->purchases_invoice_description
            );

            if($detail->total_vat > 0 ){

                $tax = DB::table('taxes')->where('tax_id' , $detail->tax_percent_id)->first();
                $items[]    = array(
                    'account_tree_id'   => $tax->account_tree_id ?? 0 ,
                    'cost_center_id'    => 0 ,
                    'debit'             => $detail->total_vat  ,
                    'credit'            => 0,
                    'description'       => $main->purchases_invoice_description
                );
            }

        }

        $journal = (new DailyJournalHelper)->generate_journal($journal_data , $items );
        if($journal[0]){
            
            DB::table('purchases_invoice_m')
                ->where('purchases_invoice_m_id' , $id)
                ->update( ['daily_journal_m_id' => $journal[2]] );
            return $journal;

        }else{

            $response = [
               'check' => false,
               'data'  => $journal ,
               'msg'   => $journal[1]
            ];
            header('Content-Type: application/json; charset=utf-8; ');
            header('Access-Control-Allow-Origin:*');
            header('Access-Control-Allow-Headers:*');
            echo json_encode($response);
            die();

        }


    }
}
