<?php

namespace App\Classes\Purchases;

use DB;

class SupplierStatmentReportHelper
{
    public static function get_statment($id, $lang, $params)
    {
        $query = DB::table('purchases_invoice_m')
            ->leftJoin('purchases_invoice_d', 'purchases_invoice_d.purchases_invoice_m_id', '=', 'purchases_invoice_m.purchases_invoice_m_id')
            ->where('purchases_invoice_m.purchases_vendor_id', $id)
            ->where('purchases_invoice_m.purchases_invoice_active', 1)
            ->groupBy('purchases_invoice_m.purchases_invoice_m_id')
            ->selectRaw('
        purchases_invoice_m.purchases_invoice_m_id as id,
        sum( purchases_invoice_d.total_with_vat ) as total_amount ,
        purchases_invoice_m.purchases_invoice_date as action_date ,

        CASE
            WHEN (purchases_invoice_m.purchases_invoice_description IS NOT NULL AND LENGTH(purchases_invoice_m.purchases_invoice_description) > 0) AND (purchases_invoice_m.purchases_vendor_id)
            THEN CONCAT(purchases_invoice_m.purchases_invoice_description, " - ", "فاتورة مورد رقم ", purchases_invoice_m.purchases_vendor_id)

            WHEN (purchases_invoice_m.purchases_invoice_description IS NOT NULL AND LENGTH(purchases_invoice_m.purchases_invoice_description) > 0) AND (!purchases_invoice_m.purchases_vendor_id)
            THEN purchases_invoice_m.purchases_invoice_description

            WHEN (purchases_invoice_m.purchases_invoice_description IS NULL OR LENGTH(purchases_invoice_m.purchases_invoice_description) < 1) AND (purchases_invoice_m.purchases_vendor_id)
            THEN CONCAT("فاتورة مورد رقم ", purchases_invoice_m.purchases_vendor_id)

            WHEN (purchases_invoice_m.purchases_invoice_description IS NULL OR LENGTH(purchases_invoice_m.purchases_invoice_description) < 1) AND (!purchases_invoice_m.purchases_vendor_id)
            THEN NULL
        END as description,

        "purchase" as type ,
        "2" as money_action_type
    ');

        if (isset($params['branch_id'])) {
            $query->where('purchases_invoice_m.branch_id', $params['branch_id']);
        }


        if (isset($params['before'])) {
            $query->where('purchases_invoice_m.purchases_invoice_date', '<', $params['before']);
        } elseif (isset($params['from']) && isset($params['to'])) {
            $query->where('purchases_invoice_m.purchases_invoice_date', '>=', $params['from']);
            $query->where('purchases_invoice_m.purchases_invoice_date', '<=', $params['to']);
        }

        $purchases     = $query->get()->toArray();


        //=========================================================================//

        $query = DB::table('return_purchases_m')
            ->join('return_purchases_d', 'return_purchases_d.return_purchase_m_id', '=', 'return_purchases_m.return_purchase_m_id')
            ->join('purchases_invoice_m', 'return_purchases_m.purchase_invoice_m_id', '=', 'purchases_invoice_m.purchases_invoice_m_id')
            ->join('purchases_invoice_d', 'return_purchases_d.purchase_invoice_d_id', '=', 'purchases_invoice_d.purchases_invoice_d_id')
            ->where('purchases_invoice_m.purchases_vendor_id', $id)
            ->where('return_purchases_m.active', 1)
            ->where('return_purchases_m.action_date', '<', '2025-07-01')
            ->groupBy('return_purchases_m.return_purchase_m_id')
            ->selectRaw('
        return_purchases_m.return_purchase_m_id as id,
        sum(return_purchases_d.returned_with_vat) as total_amount,
        return_purchases_m.action_date,
        return_purchases_m.description as description,
        "return_purchase" as type,
        "1" as money_action_type
    ');
        if (isset($params['branch_id'])) {
            $query->where('return_purchases_m.branch_id', $params['branch_id']);
        }

        if (isset($params['before'])) {
            $query->where('purchases_invoice_m.purchases_invoice_date', '<', $params['before']);
        } elseif (isset($params['from']) && isset($params['to'])) {
            $query->where('purchases_invoice_m.purchases_invoice_date', '>=', $params['from']);
            $query->where('purchases_invoice_m.purchases_invoice_date', '<=', $params['to']);
        }

        $return_purchases     = $query->get()->toArray();


        //====================================================================


        $query = DB::table('payment_vouchers')
            ->where('payment_vouchers.to_supplier_id', $id)
            ->where('payment_vouchers.payment_voucher_active', 1)
            ->selectRaw('
                    payment_vouchers.payment_voucher_id as id,
                    amount as total_amount ,
                    payment_vouchers.action_date ,
                    payment_vouchers.description ,
                    "pv" as type ,
                    "1" as money_action_type
            ')
            ->groupBy('payment_vouchers.payment_voucher_id');
        if (isset($params['branch_id'])) {
            $query->where('payment_vouchers.branch_id', $params['branch_id']);
        }

        if (isset($params['before'])) {
            $query->where('payment_vouchers.action_date', '<', $params['before']);
        } elseif (isset($params['from']) && isset($params['to'])) {
            $query->where('payment_vouchers.action_date', '>=', $params['from']);
            $query->where('payment_vouchers.action_date', '<=', $params['to']);
        }

        $payment_vouchers     = $query->get()->toArray();


        //=========================================================================//
        $query = DB::table('receipt_vouchers')
            ->where('receipt_vouchers.from_supplier_id', $id)
            ->where('receipt_vouchers.receipt_voucher_active', 1)
            ->selectRaw('
                    receipt_vouchers.receipt_voucher_id as id,
                    amount as total_amount ,
                    receipt_vouchers.action_date ,
                    receipt_vouchers.description ,
                    "rv" as type ,
                    "2" as money_action_type
            ')
            ->groupBy('receipt_vouchers.receipt_voucher_id');
        if (isset($params['branch_id'])) {
            $query->where('receipt_vouchers.branch_id', $params['branch_id']);
        }

        if (isset($params['before'])) {
            $query->where('receipt_vouchers.action_date', '<', $params['before']);
        } elseif (isset($params['from']) && isset($params['to'])) {
            $query->where('receipt_vouchers.action_date', '>=', $params['from']);
            $query->where('receipt_vouchers.action_date', '<=', $params['to']);
        }

        $receipt_vouchers     = $query->get()->toArray();



        //=========================================================================//

        $query = DB::table('multi_voucher_m')
            ->leftjoin('multi_voucher_d', 'multi_voucher_d.multi_voucher_m_id', '=', 'multi_voucher_m.multi_voucher_m_id')
            ->where('multi_voucher_d.dis_supplier_id', $id)
            ->where('multi_voucher_m.multi_voucher_active', 1)
            ->where('multi_voucher_d.multi_voucher_d_active', 1)
            ->where('multi_voucher_d.voucher_type', 1)
            ->selectRaw('
                    multi_voucher_m.multi_voucher_m_id as id,
                    multi_voucher_d.amount as total_amount ,
                    multi_voucher_m.action_date ,
                    multi_voucher_d.description ,
                    "MV" as type ,
                    "1" as money_action_type
            ');
        if (isset($params['branch_id'])) {
            $query->where('multi_voucher_m.branch_id', $params['branch_id']);
        }

        if (isset($params['before'])) {
            $query->where('multi_voucher_m.action_date', '<', $params['before']);
        } elseif (isset($params['from']) && isset($params['to'])) {
            $query->where('multi_voucher_m.action_date', '>=', $params['from']);
            $query->where('multi_voucher_m.action_date', '<=', $params['to']);
        }

        $multi_voucher_d     = $query->get()->toArray();



        //=========================================================================//

        $query = DB::table('multi_voucher_m')
            ->leftjoin('multi_voucher_d', 'multi_voucher_d.multi_voucher_m_id', '=', 'multi_voucher_m.multi_voucher_m_id')
            ->where('multi_voucher_d.dis_supplier_id', $id)
            ->where('multi_voucher_m.multi_voucher_active', 1)
            ->where('multi_voucher_d.multi_voucher_d_active', 1)
            ->where('multi_voucher_d.voucher_type', 2)
            ->selectRaw('
                    multi_voucher_m.multi_voucher_m_id as id,
                    multi_voucher_d.amount as total_amount ,
                    multi_voucher_m.action_date ,
                    multi_voucher_d.description ,
                    "MV" as type ,
                    "2" as money_action_type
            ');
        if (isset($params['branch_id'])) {
            $query->where('multi_voucher_m.branch_id', $params['branch_id']);
        }

        if (isset($params['before'])) {
            $query->where('multi_voucher_m.action_date', '<', $params['before']);
        } elseif (isset($params['from']) && isset($params['to'])) {
            $query->where('multi_voucher_m.action_date', '>=', $params['from']);
            $query->where('multi_voucher_m.action_date', '<=', $params['to']);
        }

        $multi_voucher_c     = $query->get()->toArray();




        //====================================================================
        $data = array_merge(
            $payment_vouchers,
            $receipt_vouchers,
            $multi_voucher_c,
            $multi_voucher_d,
            $purchases,
            $return_purchases
        );



        $final_data     = (object) array(
            'credit_amount'     => collect($data)->where('money_action_type', '2')->sum('total_amount'),
            'debit_amount'      => collect($data)->where('money_action_type', '1')->sum('total_amount'),
        );

        $final_data->total_amount = $final_data->debit_amount  - $final_data->credit_amount;

        return $final_data;
    }
}
