<?php

namespace App\Classes\Sales;

use DB;

class CustomerStatmentReportHelper
{
    public static function get_account_customer_statment($id, $lang, $params)
    {
        $sales_query = DB::table('sales_invoice_m')
            ->leftJoin('customers','sales_invoice_m.customer_id','customers.customer_id')
            ->leftJoin('sales_invoice_types','sales_invoice_m.sales_invoice_type_id','sales_invoice_types.sales_invoice_type_id')
            ->where('sales_invoice_m.customer_id',$id)
            // ->groupBy('customers.customer_id')
            ->selectRaw('
                    sales_invoice_m.sales_invoice_m_id as id,
                    customers.customer_id,
                    concat( sales_invoice_types.sales_invoice_type_title_'.$lang.' , " - " , ifnull(sales_invoice_m.sales_invoice_description , "") ) as description ,
                    sales_invoice_m.sales_invoice_date as action_date,
                    sales_invoice_m.total_with_vat as amount,
                    customers.name_'.$lang.' as customer_name,
                    "فاتوره مبيعات" as type_title ,
                    "1" as type ,
                    "0" as sumtion
            ');

        if(isset($params['before'])){
            $sales_query->where('sales_invoice_m.sales_invoice_date' , '<' , $params['before'] );
        }elseif(isset($params['from']) && isset($params['to'])){
            $sales_query->where('sales_invoice_m.sales_invoice_date' , '>=' , $params['from']);
            $sales_query->where('sales_invoice_m.sales_invoice_date' , '<=' , $params['to'] );
        }

        $customer_status1     = $sales_query->get()->toArray();
        $sales_invoice_amount = collect($customer_status1)->sum('amount');

        //=========================================================================


        $receipt_query = DB::table('receipt_vouchers')
            ->leftJoin('customers','receipt_vouchers.from_customer_id','customers.customer_id')
            ->where('receipt_vouchers.from_customer_id',$id)
            ->where('receipt_voucher_active' , 1 )
            // ->groupBy('customers.customer_id')
            ->selectRaw('
                    receipt_vouchers.receipt_voucher_id as id ,
                    customers.customer_id,
                    receipt_vouchers.description as description ,
                    receipt_vouchers.action_date as action_date ,
                    receipt_vouchers.amount as amount ,
                    customers.name_'.$lang.' as customer_name ,
                    "سند قبض" as type_title ,
                    "2" as type ,
                    "1" as sumtion
            ');


        if(isset($params['before'])){
            $receipt_query->where('receipt_vouchers.action_date' , '<' , $params['before'] );
        }elseif(isset($params['from']) && isset($params['to'])){
            $receipt_query->where('receipt_vouchers.action_date' , '>=' , $params['from'] );
            $receipt_query->where('receipt_vouchers.action_date' , '<=' , $params['to'] );
        }

        $customer_status2        = $receipt_query->get()->toArray();
        $receipt_vouchers_amount = collect($customer_status2)->sum('amount');

        //==============================================================

        $debtors_query = DB::table('notice_debtors_m')
            ->leftJoin('customers','notice_debtors_m.customer_id','customers.customer_id')
            ->leftJoin('notice_debtors_d','notice_debtors_m.notice_debtor_m_id','notice_debtors_d.notice_debtor_m_id')
            ->where('notice_debtors_m.customer_id',$id)
            ->groupBy('notice_debtors_m.notice_debtor_m_id')
            ->selectRaw('
                    notice_debtors_m.notice_debtor_m_id as id ,
                    customers.customer_id,
                    concat("اشعار مدين رقم " , notice_debtors_m.notice_debtor_m_id ) as description ,
                    notice_debtors_m.invoice_date as action_date ,
                    sum( notice_debtors_d.new_total_with_vat ) as amount,
                    customers.name_'.$lang.' as customer_name,
                    "اشعار مدين" as type_title ,
                    "3" as type ,
                    "0" as sumtion
            ');


        if(isset($params['before'])){
            $debtors_query->where('notice_debtors_m.invoice_date' , '<' , $params['before'] );
        }elseif(isset($params['from']) && isset($params['to'])){
            $debtors_query->where('notice_debtors_m.invoice_date' , '>=' , $params['from'] );
            $debtors_query->where('notice_debtors_m.invoice_date' , '<=' , $params['to'] );
        }

        $customer_status3     = $debtors_query->get()->toArray();
        $notice_debtor_amount = collect($customer_status3)->sum('amount');

        //=========================================================================
        $payment_query = DB::table('payment_vouchers')
            ->leftJoin('customers','payment_vouchers.to_customer_id','customers.customer_id')
            ->where('payment_vouchers.to_customer_id',$id)
            // ->groupBy('customers.customer_id')
            ->where('payment_voucher_active' , 1 )
            ->selectRaw('
                    payment_vouchers.payment_voucher_id as id,
                    customers.customer_id,
                    payment_vouchers.description as description ,
                    payment_vouchers.action_date as action_date,
                    payment_vouchers.amount as amount ,
                    customers.name_'.$lang.' as customer_name,
                    "سند دفع" as type_title ,
                    "4" as type ,
                    "0" as sumtion
            ');

        if(isset($params['before'])){
            $payment_query->where('payment_vouchers.action_date' , '<' , $params['before'] );
        }elseif(isset($params['from']) && isset($params['to'])){
            $payment_query->where('payment_vouchers.action_date' , '>=' , $params['from'] );
            $payment_query->where('payment_vouchers.action_date' , '<=' , $params['to'] );
        }

        $customer_status4        = $payment_query->get()->toArray();
        $payment_vouchers_amount = collect($customer_status4)->sum('amount');

        //=========================================================================

        $creditors_query = DB::table('notice_creditors_m')
            ->leftJoin('customers','notice_creditors_m.customer_id','customers.customer_id')
            ->leftJoin('notice_creditors_d','notice_creditors_m.notice_creditor_m_id','notice_creditors_d.notice_creditor_m_id')
            ->where('notice_creditors_m.customer_id',$id)
            ->groupBy('notice_creditors_m.notice_creditor_m_id')
            ->selectRaw('
                    notice_creditors_m.notice_creditor_m_id as id ,
                    concat("اشعار دائن رقم " , notice_creditors_m.notice_creditor_m_id ) as description ,
                    notice_creditors_m.invoice_date  as action_date,
                    sum( notice_creditors_d.new_total_with_vat ) as amount,
                    customers.customer_id,
                    "اشعار دائن" as type_title ,
                    "5" as type ,
                    "1" as sumtion
            ');

        if(isset($params['before'])){
            $creditors_query->where('notice_creditors_m.invoice_date' , '<' , $params['before'] );
        }elseif(isset($params['from']) && isset($params['to'])){
            $creditors_query->where('notice_creditors_m.invoice_date' , '>=' , $params['from'] );
            $creditors_query->where('notice_creditors_m.invoice_date' , '<=' , $params['to'] );
        }

        $customer_status5       = $creditors_query->get()->toArray();
        $notice_creditor_amount = collect($customer_status5)->sum('amount');

        //====================================================================

        $sales_payments_query = DB::table('sales_invoice_payments')
            ->leftJoin('sales_invoice_m','sales_invoice_payments.sales_invoice_m_id','sales_invoice_m.sales_invoice_m_id')
            ->leftJoin('customers','sales_invoice_m.customer_id','customers.customer_id')
            ->where('sales_invoice_m.customer_id',$id)
            // ->groupBy('customers.customer_id')
            ->selectRaw('
                    sales_invoice_m.sales_invoice_m_id as id,
                    customers.customer_id,
                    concat(" دفع فاتورة " ,sales_invoice_payments.payment_text ) as description  ,
                    sales_invoice_m.sales_invoice_date as action_date,
                    sales_invoice_payments.amount as amount,
                    customers.name_'.$lang.' as customer_name,
                    "دفع فاتوره مبيعات " as type_title ,
                    "6" as type ,
                    "1" as sumtion
            ');

        if(isset($params['before'])){
            $sales_payments_query->where('sales_invoice_m.sales_invoice_date' , '<' , $params['before'] );
        }elseif(isset($params['from']) && isset($params['to'])){
            $sales_payments_query->where('sales_invoice_m.sales_invoice_date' , '>=' , $params['from']);
            $sales_payments_query->where('sales_invoice_m.sales_invoice_date' , '<=' , $params['to'] );
        }

        $customer_status6     = $sales_payments_query->get()->toArray();
        $sales_invoice_payments = collect($customer_status6)->sum('amount');



        $creditors_payments_query = DB::table('notice_payments')
            ->leftJoin('notice_creditors_m','notice_payments.notice_creditor_m_id','notice_creditors_m.notice_creditor_m_id')
            ->leftJoin('customers','notice_creditors_m.customer_id','customers.customer_id')
            ->where('notice_creditors_m.customer_id',$id)
            // ->groupBy('customers.customer_id')
            ->selectRaw('
                    notice_payments.notice_creditor_m_id as id,
                    customers.customer_id,
                    concat(" دفع اشعار دائن " ,notice_payments.payment_text ) as description  ,
                    notice_creditors_m.invoice_date as action_date,
                    notice_payments.amount as amount,
                    customers.name_'.$lang.' as customer_name,
                    "7" as type ,
                    "دفع اشعار دائن" as type_title ,
                    "0" as sumtion
            ');

        if(isset($params['before'])){
            $creditors_payments_query->where('notice_creditors_m.invoice_date' , '<' , $params['before'] );
        }elseif(isset($params['from']) && isset($params['to'])){
            $creditors_payments_query->where('notice_creditors_m.invoice_date' , '>=' , $params['from']);
            $creditors_payments_query->where('notice_creditors_m.invoice_date' , '<=' , $params['to'] );
        }

        $customer_status7       = $creditors_payments_query->get()->toArray();
        // $customer_status7       = [];
        $creditors_payments_query = collect($customer_status7)->sum('amount');

        //=========================================================================
        $multi_query = DB::table('multi_voucher_d')
            ->leftJoin('multi_voucher_m','multi_voucher_d.multi_voucher_m_id','multi_voucher_m.multi_voucher_m_id')
            ->leftJoin('customers','multi_voucher_d.dis_customer_id','customers.customer_id')
            ->where('multi_voucher_d.dis_type',3)
            ->where('multi_voucher_d.dis_customer_id',$id)
            ->where('multi_voucher_active' , 1 )
            ->where('multi_voucher_d_active',1)
            ->where('voucher_type' , 1 )
            ->selectRaw('
                multi_voucher_m.multi_voucher_m_id as id,
                customers.customer_id,
                multi_voucher_d.description as description ,
                multi_voucher_m.action_date as action_date,
                multi_voucher_d.amount as amount ,
                customers.name_'.$lang.' as customer_name,
                "سند متعدد مدين" as type_title ,
                "8" as type ,
                "0" as sumtion
            ');

        if(isset($params['before'])){
            $multi_query->where('multi_voucher_m.action_date' , '<' , $params['before'] );
        }elseif(isset($params['from']) && isset($params['to'])){
            $multi_query->where('multi_voucher_m.action_date' , '>=' , $params['from'] );
            $multi_query->where('multi_voucher_m.action_date' , '<=' , $params['to'] );
        }

        $customer_status8        = $multi_query->get()->toArray();
        $multi_d_vouchers_amount = collect($customer_status8)->sum('amount');


    //=========================================================================
        $multi_query = DB::table('multi_voucher_d')
            ->leftJoin('multi_voucher_m','multi_voucher_d.multi_voucher_m_id','multi_voucher_m.multi_voucher_m_id')
            ->leftJoin('customers','multi_voucher_d.dis_customer_id','customers.customer_id')
            ->where('multi_voucher_d.dis_type',3)
            ->where('multi_voucher_d.dis_customer_id',$id)
            ->where('multi_voucher_active' , 1 )
            ->where('multi_voucher_d_active',1)
            ->where('voucher_type' , 2 )
            ->selectRaw('
                multi_voucher_m.multi_voucher_m_id as id,
                customers.customer_id,
                multi_voucher_d.description as description ,
                multi_voucher_m.action_date as action_date,
                multi_voucher_d.amount as amount ,
                customers.name_'.$lang.' as customer_name,
                "سند متعدد دائن" as type_title ,
                "8" as type ,
                "1" as sumtion
            ');

        if(isset($params['before'])){
            $multi_query->where('multi_voucher_m.action_date' , '<' , $params['before'] );
        }elseif(isset($params['from']) && isset($params['to'])){
            $multi_query->where('multi_voucher_m.action_date' , '>=' , $params['from'] );
            $multi_query->where('multi_voucher_m.action_date' , '<=' , $params['to'] );
        }

        $customer_status9        = $multi_query->get()->toArray();
        $multi_c_vouchers_amount = collect($customer_status9)->sum('amount');




        $elevators_query = DB::table('elevators_quotations')
            ->leftJoin('customers','elevators_quotations.customer_id','customers.customer_id')
            ->where('elevators_quotations.customer_id',$id)
            ->where('is_contract' , 1)
            // ->groupBy('customers.customer_id')
            ->selectRaw('
                    elevators_quotations.quotation_id  as id,
                    customers.customer_id,
                    concat("عقد رقم " ,  elevators_quotations.invoice_code ) as description ,
                    elevators_quotations.date as action_date,
                    elevators_quotations.price as amount,
                    customers.name_'.$lang.' as customer_name,
                    concat("عقد رقم  " , elevators_quotations.invoice_code ) as type_title ,
                    "9" as type ,
                    "0" as sumtion
            ');

        if(isset($params['before'])){
            $elevators_query->where('elevators_quotations.date' , '<' , $params['before'] );
        }elseif(isset($params['from']) && isset($params['to'])){
            $elevators_query->where('elevators_quotations.date' , '>=' , $params['from']);
            $elevators_query->where('elevators_quotations.date' , '<=' , $params['to'] );
        }

        $customer_status10     = $elevators_query->get()->toArray();
        $elevatorss_invoice_amount = collect($customer_status10)->sum('amount');




        //=========================================================================
        if(isset($params['with_notes']) && $params['with_notes'] == 1){
            $delevery_notes = DB::table('delivery_note_m')
            ->leftjoin('customers' , 'delivery_note_m.customer_id' , '=' , 'customers.customer_id')
            ->leftjoin('delivery_note_d' , 'delivery_note_m.delivery_note_m_id' , '=' , 'delivery_note_d.delivery_note_m_id')
            ->where('delivery_note_m.customer_id', $id)
            ->where('delivery_note_active' , 1)
            ->selectRaw('
                    delivery_note_m.delivery_note_m_id  as id,
                    customers.customer_id,
                    concat("اذن رقم " ,  delivery_note_m.delivery_note_m_id ) as description ,
                    delivery_note_m.delivery_note_date as action_date,
                    sum(delivery_note_d.total_with_vat) as amount,
                    customers.name_'.$lang.' as customer_name,
                    concat("اذن رقم  " , delivery_note_m.delivery_note_m_id ) as type_title ,
                    "10" as type ,
                    "0" as sumtion

            ');
            if(isset($params['before'])){
                $delevery_notes->where('delivery_note_m.delivery_note_date' , '<' , $params['before'] );
            }elseif(isset($params['from']) && isset($params['to'])){
                $delevery_notes->where('delivery_note_m.delivery_note_date' , '>=' , $params['from'] );
                $delevery_notes->where('delivery_note_m.delivery_note_date' , '<=' , $params['to'] );
            }
            $customer_status11     = $delevery_notes->get()->toArray();
        }else{
            $customer_status11 = [];
        }


        $data = array_merge(
                $customer_status1,
                $customer_status2,
                $customer_status3,
                $customer_status4,
                $customer_status5,
                $customer_status6,
                $customer_status7,
                $customer_status8,
                $customer_status9,
                $customer_status10,
                $customer_status11
            );


        if(isset($params['total'])){

            $data   = (object) array(
                'debit'  => collect($data)->where('sumtion' , 0)->sum('amount'),
                'credit' => collect($data)->where('sumtion' , 1)->sum('amount'),
            );

            if(isset($params['first'])){

                $first = DB::table('customers')
                    ->where('customer_id' , $id)
                    ->selectRaw('first_term_balance , balance_nature' )
                    ->first();

                if($first->balance_nature == 1 )
                    $data->debit = $data->debit + $first->first_term_balance;
                else
                    $data->credit = abs($data->credit) + $first->first_term_balance;
            }

            $data->total = $data->debit - $data->credit;

        }else{



            $data = collect($data)->sortBy('action_date')->values()->all();

        }

        return $data;
    }
}




?>
